/*
 * Decompiled with CFR 0.152.
 */
package obp2.hash;

import java.util.Random;
import obp2.hash.ExternalHash;

public class SpookyHashV2
extends ExternalHash {
    public static native boolean hash128(byte[] var0, long[] var1);

    private static native boolean hash128int4(byte[] var0, int[] var1);

    public static boolean hash128(byte[] buffer, int[] seedin_hashout) {
        return SpookyHashV2.hash128int4(buffer, seedin_hashout);
    }

    public static native long hash64(byte[] var0, long var1);

    public static native int hash32(byte[] var0, int var1);

    private static void testSpooky128(int nb_bytes, int runs) {
        byte[] bytes = new byte[nb_bytes];
        Random rnd = new Random();
        long[] seeds = new long[2];
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < runs; i += 2) {
            rnd.nextBytes(bytes);
            seeds[0] = rnd.nextLong();
            seeds[1] = rnd.nextLong();
            SpookyHashV2.hash128(bytes, seeds);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("spooky2_hash128 (" + nb_bytes + ", " + runs + ") took " + (endTime - startTime) + " milliseconds");
    }

    private static void testSpooky128int(int nb_bytes, int runs) {
        byte[] bytes = new byte[nb_bytes];
        Random rnd = new Random();
        int[] seeds = new int[4];
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < runs; i += 2) {
            rnd.nextBytes(bytes);
            seeds[0] = rnd.nextInt();
            seeds[1] = rnd.nextInt();
            seeds[2] = rnd.nextInt();
            seeds[3] = rnd.nextInt();
            SpookyHashV2.hash128(bytes, seeds);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("spooky2_hash128 (" + nb_bytes + ", " + runs + ") took " + (endTime - startTime) + " milliseconds");
    }

    private static long testSpooky64(int nb_bytes, int runs) {
        byte[] bytes = new byte[nb_bytes];
        Random rnd = new Random();
        long hash = 0L;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < runs; i += 2) {
            rnd.nextBytes(bytes);
            hash = SpookyHashV2.hash64(bytes, rnd.nextLong());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("spooky2_hash64 (" + nb_bytes + ", " + runs + ") took " + (endTime - startTime) + " milliseconds");
        return hash;
    }

    private static long testSpooky32(int nb_bytes, int runs) {
        byte[] bytes = new byte[nb_bytes];
        Random rnd = new Random();
        long hash = 0L;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < runs; i += 2) {
            rnd.nextBytes(bytes);
            hash = SpookyHashV2.hash32(bytes, rnd.nextInt());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("spooky2_hash32 (" + nb_bytes + ", " + runs + ") took " + (endTime - startTime) + " milliseconds");
        return hash;
    }

    public static void main(String[] args) {
        int size = 50000;
        int runs = 10000;
        SpookyHashV2.testSpooky128(size, runs);
        SpookyHashV2.testSpooky128int(size, runs);
        SpookyHashV2.testSpooky64(size, runs);
        SpookyHashV2.testSpooky32(size, runs);
        SpookyHashV2.testArraysHashCode(size, runs);
    }
}

