/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.compiler;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.cte.ABCD.compiler.BaseScope;
import org.cte.ABCD.compiler.Context;
import org.cte.ABCD.compiler.Scope;
import org.cte.ABCD.compiler.Symbol;
import org.cte.ABCD.grammar.ABCDBaseListener;
import org.cte.ABCD.grammar.ABCDParser;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.Asynchronous;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.ConstantDecl;
import org.cte.ABCD.model.declarations.DeclarationWithConstants;
import org.cte.ABCD.model.declarations.DeclarationWithParameters;
import org.cte.ABCD.model.declarations.DeclarationWithPorts;
import org.cte.ABCD.model.declarations.DeclarationWithVariables;
import org.cte.ABCD.model.declarations.ElementWithArgumentMap;
import org.cte.ABCD.model.declarations.EventPool;
import org.cte.ABCD.model.declarations.Field;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.PortMap;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.State;
import org.cte.ABCD.model.declarations.Synchronous;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.declarations.ValueHolder;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Any;
import org.cte.ABCD.model.expressions.ArrayLit;
import org.cte.ABCD.model.expressions.BinaryExp;
import org.cte.ABCD.model.expressions.BinaryOperator;
import org.cte.ABCD.model.expressions.FalseLit;
import org.cte.ABCD.model.expressions.FieldLiteral;
import org.cte.ABCD.model.expressions.FunctionCall;
import org.cte.ABCD.model.expressions.IndexedExp;
import org.cte.ABCD.model.expressions.IntegerLit;
import org.cte.ABCD.model.expressions.QueueLit;
import org.cte.ABCD.model.expressions.RecordLit;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.expressions.SelectedExp;
import org.cte.ABCD.model.expressions.TrueLit;
import org.cte.ABCD.model.expressions.UnaryExp;
import org.cte.ABCD.model.expressions.UnaryOperator;
import org.cte.ABCD.model.expressions.UnionLiteral;
import org.cte.ABCD.model.kernel.Declaration;
import org.cte.ABCD.model.kernel.Element;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.kernel.Type;
import org.cte.ABCD.model.kernel.TypedElement;
import org.cte.ABCD.model.statements.AssignStmt;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.CaseItem;
import org.cte.ABCD.model.statements.CaseStmt;
import org.cte.ABCD.model.statements.DeferredEvent;
import org.cte.ABCD.model.statements.ElementWithCaseItems;
import org.cte.ABCD.model.statements.ForeachStmt;
import org.cte.ABCD.model.statements.GuardStmt;
import org.cte.ABCD.model.statements.IfStmt;
import org.cte.ABCD.model.statements.InputStmt;
import org.cte.ABCD.model.statements.LoopStmt;
import org.cte.ABCD.model.statements.NullStmt;
import org.cte.ABCD.model.statements.OutputStmt;
import org.cte.ABCD.model.statements.ReceiveStmt;
import org.cte.ABCD.model.statements.ReturnStmt;
import org.cte.ABCD.model.statements.SelectStmt;
import org.cte.ABCD.model.statements.SendStmt;
import org.cte.ABCD.model.statements.SpecialTypeStmt;
import org.cte.ABCD.model.statements.ToStmt;
import org.cte.ABCD.model.statements.Transition;
import org.cte.ABCD.model.statements.WaitStmt;
import org.cte.ABCD.model.statements.WhileStmt;
import org.cte.ABCD.model.types.Array;
import org.cte.ABCD.model.types.BoolType;
import org.cte.ABCD.model.types.FieldBasedType;
import org.cte.ABCD.model.types.IntType;
import org.cte.ABCD.model.types.Interval;
import org.cte.ABCD.model.types.MutexType;
import org.cte.ABCD.model.types.NatType;
import org.cte.ABCD.model.types.NoneType;
import org.cte.ABCD.model.types.Queue;
import org.cte.ABCD.model.types.Record;
import org.cte.ABCD.model.types.SemaphoreType;
import org.cte.ABCD.model.types.TimerType;
import org.cte.ABCD.model.types.Union;

public class ASTBuilder
extends ABCDBaseListener {
    public static Type IntType = new IntType();
    public static Type NatType = new NatType();
    public static Type BoolType = new BoolType();
    public static Type NoneType = new NoneType();
    public static Type TimerType = new TimerType();
    public static Type MutexType = new MutexType();
    public static Type SemaphoreType = new SemaphoreType();
    private Stack<Context> context;
    private Stack<Expression> exprStack;
    private ABCDSystem result;
    private ParseTreeProperty<Block> blockMap;
    private BaseScope globalScope;
    private Map<String, ConstantDecl> constantsScope;
    private Stack<BaseScope> compositeLiteralScope = new Stack();

    public ASTBuilder() {
        this.context = new Stack();
        this.blockMap = new ParseTreeProperty();
        this.globalScope = new BaseScope(null);
        this.exprStack = new Stack();
        this.constantsScope = new LinkedHashMap<String, ConstantDecl>();
    }

    public Context peekContext() {
        return this.context.peek();
    }

    public <T extends Element> T peekNode(Class<T> type) {
        return (T)((Element)type.cast(this.peekContext().getNode()));
    }

    public void pushContext(Element node, Scope scope) {
        this.context.push(new Context().setNode(node).setScope(scope));
    }

    public void pushContext(Element node) {
        this.pushContext(node, this.currentScope());
    }

    public Context popContext() {
        return this.context.pop();
    }

    public Scope currentScope() {
        if (this.context.size() == 0) {
            return this.globalScope;
        }
        return this.context.peek().getScope();
    }

    public ABCDSystem getResult() {
        return this.result;
    }

    @Override
    public void enterSystem(ABCDParser.SystemContext ctx) {
        ABCDSystem theNode = new ABCDSystem();
        this.pushContext(theNode);
        this.addPrimitiveTypes(theNode);
    }

    private void addPrimitiveTypes(ABCDSystem s) {
        s.addAllCoreTypes(Arrays.asList(IntType, BoolType, NatType, NoneType, TimerType, MutexType, SemaphoreType));
    }

    @Override
    public void exitSystem(ABCDParser.SystemContext ctx) {
        this.result = (ABCDSystem)this.popContext().getNode();
        if (ctx.systemName().IDENTIFIER() != null) {
            this.result.setName(ctx.systemName().IDENTIFIER().getText());
        }
        assert (this.exprStack.isEmpty());
        assert (this.context.isEmpty());
    }

    @Override
    public void exitBoolType(ABCDParser.BoolTypeContext ctx) {
        this.peekNode(TypedElement.class).setType(BoolType);
    }

    @Override
    public void exitIntType(ABCDParser.IntTypeContext ctx) {
        this.peekNode(TypedElement.class).setType(IntType);
    }

    @Override
    public void exitNatType(ABCDParser.NatTypeContext ctx) {
        this.peekNode(TypedElement.class).setType(NatType);
    }

    @Override
    public void exitNoneType(ABCDParser.NoneTypeContext ctx) {
        this.peekNode(TypedElement.class).setType(NoneType);
    }

    @Override
    public void exitTimerType(ABCDParser.TimerTypeContext ctx) {
        this.peekNode(TypedElement.class).setType(TimerType);
    }

    @Override
    public void exitSemaphoreType(ABCDParser.SemaphoreTypeContext ctx) {
        this.peekNode(TypedElement.class).setType(SemaphoreType);
    }

    @Override
    public void exitMutexType(ABCDParser.MutexTypeContext ctx) {
        this.peekNode(TypedElement.class).setType(MutexType);
    }

    @Override
    public void exitAliasType(ABCDParser.AliasTypeContext ctx) {
        Type t = this.resolveGlobalName(ctx.getText(), TypeDecl.class);
        this.peekNode(TypedElement.class).setType(t);
    }

    @Override
    public void enterTypeDecl(ABCDParser.TypeDeclContext ctx) {
        TypeDecl ta = new TypeDecl();
        ta.setName(ctx.IDENTIFIER().getText());
        this.pushContext(ta);
    }

    @Override
    public void exitTypeDecl(ABCDParser.TypeDeclContext ctx) {
        TypeDecl ta = (TypeDecl)this.popContext().getNode();
        this.defineInCurrentScope(ta);
        ABCDSystem system = this.peekNode(ABCDSystem.class);
        system.addTypes(ta);
        system.addDeclarations(ta);
    }

    private void reportError(String description) {
        throw new Error("ASTBuiler:" + description);
    }

    private <T extends NamedDeclaration> T resolve(String name, Class<T> type, boolean tryEnclosingScope) {
        Symbol s = this.peekContext().getScope().resolve(name, tryEnclosingScope);
        NamedDeclaration n = null;
        if (s == null) {
            n = this.constantsScope.get(name);
            if (n == null) {
                this.reportError("cannot find " + type.getSimpleName() + " named '" + name + "' in scope\n");
                return null;
            }
        } else {
            n = s.getValue();
        }
        if (type.isAssignableFrom(n.getClass())) {
            return (T)((NamedDeclaration)type.cast(n));
        }
        this.reportError("ASTBuilder: Cannot use the '" + n.getClass().getSimpleName() + "' object named '" + name + "' as '" + type.getSimpleName() + "'");
        return null;
    }

    private <T extends NamedDeclaration> T resolveName(String name, Class<T> type) {
        return this.resolve(name, type, false);
    }

    private <T extends NamedDeclaration> T resolveGlobalName(String name, Class<T> type) {
        return this.resolve(name, type, true);
    }

    @Override
    public void exitIntervalType(ABCDParser.IntervalTypeContext ctx) {
        Interval i = new Interval();
        i.setMaxi(this.exprStack.pop());
        i.setMini(this.exprStack.pop());
        this.peekNode(TypedElement.class).setType(i);
        this.currentSystem().addCoreTypes(i);
    }

    private void enterField() {
        this.pushContext(new Field());
    }

    private void inlineFields(List<ABCDParser.AnnotatedIdentifierContext> list, FieldBasedType fbt, Type t) {
        for (ABCDParser.AnnotatedIdentifierContext e : list) {
            if (e.LTT() != null) {
                this.reportError("LTT annotation is not allowed in this context");
            }
            Field f = new Field();
            f.setName(e.IDENTIFIER().getText());
            f.setType(t);
            this.defineInCurrentScope(f);
            fbt.addFieldsAndOpposite(f);
        }
    }

    @Override
    public void enterUnionFieldGroup(ABCDParser.UnionFieldGroupContext ctx) {
        this.enterField();
    }

    @Override
    public void exitUnionFieldGroup(ABCDParser.UnionFieldGroupContext ctx) {
        Field t = (Field)this.popContext().getNode();
        Union u = this.peekNode(Union.class);
        this.inlineFields(ctx.identifierList().annotatedIdentifier(), u, t.getType());
    }

    @Override
    public void enterUnionType(ABCDParser.UnionTypeContext ctx) {
        this.pushContext(new Union(), new BaseScope(this.currentScope()));
    }

    public void exitFieldBaseType(ParserRuleContext ctx) {
        Type t = (Type)this.popContext().getNode();
        this.peekNode(TypedElement.class).setType(t);
        this.currentSystem().addCoreTypes(t);
    }

    @Override
    public void exitUnionType(ABCDParser.UnionTypeContext ctx) {
        this.exitFieldBaseType(ctx);
    }

    @Override
    public void enterRecordFieldGroup(ABCDParser.RecordFieldGroupContext ctx) {
        this.enterField();
    }

    @Override
    public void exitRecordFieldGroup(ABCDParser.RecordFieldGroupContext ctx) {
        Field t = (Field)this.popContext().getNode();
        Record r = this.peekNode(Record.class);
        this.inlineFields(ctx.identifierList().annotatedIdentifier(), r, t.getType());
    }

    @Override
    public void enterRecordType(ABCDParser.RecordTypeContext ctx) {
        this.pushContext(new Record(), new BaseScope(this.currentScope()));
    }

    @Override
    public void exitRecordType(ABCDParser.RecordTypeContext ctx) {
        this.exitFieldBaseType(ctx);
    }

    @Override
    public void enterArrayType(ABCDParser.ArrayTypeContext ctx) {
        this.pushContext(new Array());
    }

    @Override
    public void exitArrayType(ABCDParser.ArrayTypeContext ctx) {
        Array a = (Array)this.popContext().getNode();
        a.setSize(this.exprStack.pop());
        this.peekNode(TypedElement.class).setType(a);
        this.currentSystem().addCoreTypes(a);
    }

    @Override
    public void enterQueueType(ABCDParser.QueueTypeContext ctx) {
        this.pushContext(new Queue());
    }

    @Override
    public void exitQueueType(ABCDParser.QueueTypeContext ctx) {
        Queue a = (Queue)this.popContext().getNode();
        a.setSize(this.exprStack.pop());
        this.peekNode(TypedElement.class).setType(a);
        this.currentSystem().addCoreTypes(a);
    }

    @Override
    public void exitSynchronous(ABCDParser.SynchronousContext ctx) {
        this.peekNode(ChannelTypeDecl.class).setSynchronizationPolicy(new Synchronous());
    }

    private Expression buildIntLiteral(int value) {
        IntegerLit l = new IntegerLit();
        l.setValue(value);
        return l;
    }

    @Override
    public void exitAsynchronous(ABCDParser.AsynchronousContext ctx) {
        Asynchronous a = new Asynchronous();
        if (ctx.BLOCK() != null) {
            a.setIsBlocking(true);
        } else {
            a.setIsBlocking(false);
        }
        if (ctx.bufferSize() == null) {
            a.setSize(this.buildIntLiteral(1));
        } else {
            a.setSize(this.exprStack.pop());
        }
        this.peekNode(ChannelTypeDecl.class).setSynchronizationPolicy(a);
    }

    @Override
    public void exitEventPool(ABCDParser.EventPoolContext ctx) {
        EventPool a = new EventPool();
        if (ctx.bufferSize() == null) {
            a.setSize(this.buildIntLiteral(1));
        } else {
            a.setSize(this.exprStack.pop());
        }
        this.peekNode(ChannelTypeDecl.class).setSynchronizationPolicy(a);
    }

    @Override
    public void enterChannelTypeDecl(ABCDParser.ChannelTypeDeclContext ctx) {
        this.pushContext(new ChannelTypeDecl());
    }

    @Override
    public void exitChannelTypeDecl(ABCDParser.ChannelTypeDeclContext ctx) {
        String id = ctx.IDENTIFIER().getText();
        ChannelTypeDecl ctd = (ChannelTypeDecl)this.popContext().getNode();
        ctd.setName(id);
        this.defineInCurrentScope(ctd);
        ABCDSystem system = this.peekNode(ABCDSystem.class);
        system.addChannelTypes(ctd);
    }

    private void defineInCurrentScope(NamedDeclaration e) {
        if (!this.currentScope().define(new Symbol(e)).booleanValue()) {
            this.reportError("illegal redefinition of '" + e.getName() + "'\n");
        }
    }

    private void defineConstant(ConstantDecl cD) {
        if (this.currentScope().resolve(cD.getName(), false) != null) {
            this.reportError("illegal redefinition of '" + cD.getName() + "' as constant\n");
        }
        if (this.constantsScope.put(cD.getName(), cD) != null) {
            this.reportError("illegal redefinition of constant '" + cD.getName() + "'\n");
        }
    }

    @Override
    public void enterConstantDecl(ABCDParser.ConstantDeclContext ctx) {
        this.pushContext(new ConstantDecl());
    }

    @Override
    public void exitConstantDecl(ABCDParser.ConstantDeclContext ctx) {
        Expression e = this.exprStack.pop();
        Type t = ((TypedElement)this.popContext().getNode()).getType();
        for (ABCDParser.AnnotatedIdentifierContext s : ctx.typedIdentifierGroup().identifierList().annotatedIdentifier()) {
            ConstantDecl c = new ConstantDecl();
            c.setName(s.IDENTIFIER().getText());
            c.setType(t);
            c.setValue(e);
            if (s.LTT() != null) {
                this.reportError("LTT annotation is not allowed in this context");
            }
            this.defineConstant(c);
            DeclarationWithConstants node = this.peekNode(DeclarationWithConstants.class);
            node.addConstantsAndOpposite(c);
            if (!(node instanceof ABCDSystem)) continue;
            ((ABCDSystem)node).addDeclarations(c);
        }
    }

    @Override
    public void enterInitializedIdentifierGroup(ABCDParser.InitializedIdentifierGroupContext ctx) {
        this.pushContext(new VariableDecl());
    }

    @Override
    public void exitInitializedIdentifierGroup(ABCDParser.InitializedIdentifierGroupContext ctx) {
        Type t = ((TypedElement)this.popContext().getNode()).getType();
        Expression e = ctx.expression() != null ? this.exprStack.pop() : null;
        for (ABCDParser.AnnotatedIdentifierContext s : ctx.typedIdentifierGroup().identifierList().annotatedIdentifier()) {
            VariableDecl v = new VariableDecl();
            v.setName(s.IDENTIFIER().getText());
            v.setIsLTT(s.LTT() != null);
            v.setType(t);
            if (e != null) {
                v.setValue(e);
            }
            this.defineInCurrentScope(v);
            DeclarationWithVariables node = this.peekNode(DeclarationWithVariables.class);
            node.addVariablesAndOpposite(v);
        }
    }

    @Override
    public void enterChannelDecl(ABCDParser.ChannelDeclContext ctx) {
        this.pushContext(new ChannelDecl());
    }

    @Override
    public void exitChannelDecl(ABCDParser.ChannelDeclContext ctx) {
        Type t = ((TypedElement)this.popContext().getNode()).getType();
        if (!(t instanceof ChannelTypeDecl)) {
            this.reportError("Expected channeltype declaration for channel(s) '" + ctx.typedIdentifierGroup().identifierList().getText() + "'");
            return;
        }
        for (ABCDParser.AnnotatedIdentifierContext s : ctx.typedIdentifierGroup().identifierList().annotatedIdentifier()) {
            ChannelDecl v = new ChannelDecl();
            v.setName(s.IDENTIFIER().getText());
            v.setType(t);
            if (s.LTT() != null) {
                this.reportError("LTT annotation is not allowed in this context");
            }
            this.defineInCurrentScope(v);
            ABCDSystem system = this.peekNode(ABCDSystem.class);
            system.addChannels(v);
        }
    }

    @Override
    public void exitIntegerLiteral(ABCDParser.IntegerLiteralContext ctx) {
        IntegerLit exp = new IntegerLit();
        exp.setValue(Integer.parseInt(ctx.INTEGER().getText()));
        this.exprStack.push(exp);
    }

    @Override
    public void exitBooleanLiteral(ABCDParser.BooleanLiteralContext ctx) {
        switch (ctx.start.getType()) {
            case 60: {
                this.exprStack.push(new TrueLit());
                break;
            }
            case 18: {
                this.exprStack.push(new FalseLit());
                break;
            }
            default: {
                this.reportError("unexpected boolean literal");
            }
        }
    }

    @Override
    public void exitArrayLiteral(ABCDParser.ArrayLiteralContext ctx) {
        int size = ctx.expressionList().expression().size();
        ArrayLit a = new ArrayLit();
        Expression[] l = new Expression[size];
        for (int i = 0; i < size; ++i) {
            l[size - i - 1] = this.exprStack.pop();
        }
        a.addAllValue(Arrays.asList(l));
        this.exprStack.push(a);
    }

    @Override
    public void exitQueueLiteral(ABCDParser.QueueLiteralContext ctx) {
        int size = ctx.expressionList() == null ? 0 : ctx.expressionList().expression().size();
        QueueLit a = new QueueLit();
        Expression[] l = new Expression[size];
        for (int i = 0; i < size; ++i) {
            l[size - i - 1] = this.exprStack.pop();
        }
        a.addAllValue(Arrays.asList(l));
        this.exprStack.push(a);
    }

    @Override
    public void exitField(ABCDParser.FieldContext ctx) {
        FieldLiteral fl = new FieldLiteral();
        fl.setValue(this.exprStack.pop());
        fl.setName(ctx.IDENTIFIER().getText());
        if (!this.compositeLiteralScope.peek().define(new Symbol(fl)).booleanValue()) {
            this.reportError("illegal redefinition of '" + fl.getName() + "' in record literal\n");
        }
        this.exprStack.push(fl);
    }

    @Override
    public void enterRecordLiteral(ABCDParser.RecordLiteralContext ctx) {
        this.pushContext(new RecordLit());
        this.compositeLiteralScope.push(new BaseScope(this.currentScope()));
    }

    @Override
    public void exitRecordLiteral(ABCDParser.RecordLiteralContext ctx) {
        RecordLit r = (RecordLit)this.popContext().getNode();
        int size = ctx.fieldList().field().size();
        for (int i = 0; i < size; ++i) {
            r.addValue((FieldLiteral)this.exprStack.pop());
        }
        this.exprStack.push(r);
        this.compositeLiteralScope.pop();
    }

    @Override
    public void enterUnionLiteral(ABCDParser.UnionLiteralContext ctx) {
        this.pushContext(new UnionLiteral(), this.currentScope());
    }

    @Override
    public void exitUnionLiteral(ABCDParser.UnionLiteralContext ctx) {
        UnionLiteral r = (UnionLiteral)this.popContext().getNode();
        TypeDecl referencedUnion = this.resolveGlobalName(ctx.IDENTIFIER(0).getText(), TypeDecl.class);
        boolean found = false;
        for (Field f : ((Union)referencedUnion.getType()).getFieldsList()) {
            if (!f.getName().equals(ctx.IDENTIFIER(1).getText())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.reportError(ctx.IDENTIFIER(1).getText() + " is not a valid member of union " + referencedUnion.getName());
        }
        r.setType((Union)referencedUnion.getType());
        r.setTypeName(referencedUnion.getName());
        r.setSelector(ctx.IDENTIFIER(1).getText());
        if (ctx.expression() != null) {
            r.setExpression(this.exprStack.pop());
        }
        this.exprStack.push(r);
    }

    @Override
    public void exitUnaryExp(ABCDParser.UnaryExpContext ctx) {
        UnaryOperator op;
        switch (ctx.operator.getType()) {
            case 36: {
                op = UnaryOperator.UNOT;
                break;
            }
            case 85: {
                op = UnaryOperator.UMINUS;
                break;
            }
            case 84: {
                return;
            }
            default: {
                this.reportError("unexpected unary operator");
                return;
            }
        }
        UnaryExp exp = new UnaryExp();
        exp.setOperator(op);
        exp.setOperand(this.exprStack.pop());
        this.exprStack.push(exp);
    }

    @Override
    public void exitBinaryExp(ABCDParser.BinaryExpContext ctx) {
        BinaryOperator op;
        switch (ctx.operator.getType()) {
            case 86: {
                op = BinaryOperator.BMUL;
                break;
            }
            case 87: {
                op = BinaryOperator.BDIV;
                break;
            }
            case 88: {
                op = BinaryOperator.BMOD;
                break;
            }
            case 84: {
                op = BinaryOperator.BADD;
                break;
            }
            case 85: {
                op = BinaryOperator.BMINUS;
                break;
            }
            case 90: {
                op = BinaryOperator.BLT;
                break;
            }
            case 89: {
                op = BinaryOperator.BLE;
                break;
            }
            case 92: {
                op = BinaryOperator.BGT;
                break;
            }
            case 91: {
                op = BinaryOperator.BGE;
                break;
            }
            case 93: {
                op = BinaryOperator.BEQ;
                break;
            }
            case 94: {
                op = BinaryOperator.BNE;
                break;
            }
            case 40: {
                op = BinaryOperator.BOR;
                break;
            }
            case 2: {
                op = BinaryOperator.BAND;
                break;
            }
            case 35: {
                op = BinaryOperator.BNOR;
                break;
            }
            case 31: {
                op = BinaryOperator.BNAND;
                break;
            }
            case 66: {
                op = BinaryOperator.BXOR;
                break;
            }
            default: {
                this.reportError("unexpected binary operator");
                return;
            }
        }
        BinaryExp exp = new BinaryExp();
        Expression right = this.exprStack.pop();
        Expression left = this.exprStack.pop();
        exp.setOperator(op);
        exp.addOperands(left);
        exp.addOperands(right);
        this.exprStack.push(exp);
    }

    @Override
    public void exitIndexedExp(ABCDParser.IndexedExpContext ctx) {
        IndexedExp exp = new IndexedExp();
        exp.setIndex(this.exprStack.pop());
        exp.setPrefix(this.exprStack.pop());
        this.exprStack.push(exp);
    }

    @Override
    public void exitSelectedExp(ABCDParser.SelectedExpContext ctx) {
        SelectedExp exp = new SelectedExp();
        exp.setSelector(ctx.IDENTIFIER().getText());
        exp.setPrefix(this.exprStack.pop());
        this.exprStack.push(exp);
    }

    @Override
    public void exitReferenceExp(ABCDParser.ReferenceExpContext ctx) {
        Reference exp = new Reference();
        exp.setRef(this.resolveName(ctx.reference().IDENTIFIER().getText(), NamedDeclaration.class));
        this.exprStack.push(exp);
    }

    @Override
    public void enterFunctionCall(ABCDParser.FunctionCallContext ctx) {
        this.pushContext(new FunctionCall());
    }

    @Override
    public void exitFunctionCall(ABCDParser.FunctionCallContext ctx) {
        FunctionCall fctC = (FunctionCall)this.popContext().getNode();
        fctC.setFunctionName(ctx.IDENTIFIER().getText());
        this.exprStack.push(fctC);
    }

    @Override
    public void exitInputStatement(ABCDParser.InputStatementContext ctx) {
        InputStmt stm = new InputStmt();
        Port p = this.resolveName(ctx.portName().IDENTIFIER().getText(), Port.class);
        if (!p.isIsInput()) {
            this.reportError("Cannot use output port " + p.getName() + " in input statement");
            return;
        }
        stm.setPort(p);
        if (ctx.expression() != null) {
            stm.setExpression(this.exprStack.pop());
        }
        this.peekNode(Block.class).addStatements(stm);
    }

    @Override
    public void exitOutputStatement(ABCDParser.OutputStatementContext ctx) {
        OutputStmt stm = new OutputStmt();
        Port p = this.resolveName(ctx.portName().IDENTIFIER().getText(), Port.class);
        if (p.isIsInput()) {
            this.reportError("Cannot use input port " + p.getName() + " in output statement");
            return;
        }
        stm.setPort(p);
        if (ctx.expression() != null) {
            stm.setExpression(this.exprStack.pop());
        }
        this.peekNode(Block.class).addStatements(stm);
    }

    @Override
    public void exitLoopStatement(ABCDParser.LoopStatementContext ctx) {
        LoopStmt s = new LoopStmt();
        s.setParent(this.currentTransition(ctx));
        this.peekNode(Block.class).addStatements(s);
    }

    private Transition currentTransition(ParserRuleContext ctx) {
        for (int i = this.context.size() - 1; i >= 0; --i) {
            if (!(((Context)this.context.get(i)).getNode() instanceof Transition)) continue;
            return (Transition)((Context)this.context.get(i)).getNode();
        }
        this.reportError("(internal error) no transition context at line " + ctx.start.getLine() + "[" + ctx.getText() + "]");
        return null;
    }

    private ABCDSystem currentSystem() {
        for (int i = this.context.size() - 1; i >= 0; --i) {
            if (!(((Context)this.context.get(i)).getNode() instanceof ABCDSystem)) continue;
            return (ABCDSystem)((Context)this.context.get(i)).getNode();
        }
        this.reportError("(internal error) no process context");
        return null;
    }

    private <T extends Declaration> T currentContext(Class<T> type) {
        for (int i = this.context.size() - 1; i >= 0; --i) {
            if (!type.isInstance(((Context)this.context.get(i)).getNode())) continue;
            return (T)((Declaration)type.cast(((Context)this.context.get(i)).getNode()));
        }
        this.reportError("(internal error) no process context");
        return null;
    }

    @Override
    public void enterTransition(ABCDParser.TransitionContext ctx) {
        this.pushContext(new Transition());
    }

    @Override
    public void exitTransition(ABCDParser.TransitionContext ctx) {
        Transition stm = (Transition)this.popContext().getNode();
        Block b = (Block)this.blockMap.get((ParseTree)ctx.block());
        String name = ctx.IDENTIFIER().getText();
        ProcessDecl context = this.currentContext(ProcessDecl.class);
        State state = this.lookupState(context, name);
        if (state == null) {
            state = new State();
            state.setName(ctx.IDENTIFIER().getText());
            context.addStatesAndOpposite(state);
        }
        stm.setFrom(state);
        stm.setBehavior(b);
        this.peekNode(ProcessDecl.class).addTransitionsAndOpposite(stm);
    }

    private State lookupState(ProcessDecl p, String name) {
        for (State s : p.getStatesList()) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    @Override
    public void exitToStatement(ABCDParser.ToStatementContext ctx) {
        ToStmt stm = new ToStmt();
        String name = ctx.IDENTIFIER().getText();
        ProcessDecl context = this.currentContext(ProcessDecl.class);
        State state = this.lookupState(context, name);
        if (state == null) {
            state = new State();
            state.setName(name);
            context.addStatesAndOpposite(state);
        }
        stm.setState(state);
        this.peekNode(Block.class).addStatements(stm);
    }

    @Override
    public void exitSpecialTypeStatement(ABCDParser.SpecialTypeStatementContext ctx) {
        SpecialTypeStmt stm = new SpecialTypeStmt();
        ValueHolder vD = this.resolveName(ctx.IDENTIFIER(0).getText(), ValueHolder.class);
        stm.setReceiver(vD);
        stm.setSelector(ctx.IDENTIFIER(1).getText());
        if (ctx.expressionList() != null) {
            int size = ctx.expressionList().expression().size();
            Expression[] exps = new Expression[size];
            for (int i = 0; i < size; ++i) {
                exps[size - i - 1] = this.exprStack.pop();
            }
            stm.addAllArguments(Arrays.asList(exps));
        }
        this.peekNode(Block.class).addStatements(stm);
    }

    @Override
    public void exitSelectStatement(ABCDParser.SelectStatementContext ctx) {
        SelectStmt stm = new SelectStmt();
        for (ABCDParser.BlockContext bc : ctx.block()) {
            stm.addStatements((Statement)this.blockMap.get((ParseTree)bc));
        }
        this.peekNode(Block.class).addStatements(stm);
    }

    @Override
    public void exitWaitStatement(ABCDParser.WaitStatementContext ctx) {
        WaitStmt stm = new WaitStmt();
        if (ctx.getChild(1).getText().equals("[")) {
            stm.setMinIncluded(true);
        } else if (ctx.getChild(1).getText().equals("]")) {
            stm.setMinIncluded(false);
        }
        if (ctx.getChild(5).getText().equals("]")) {
            stm.setMaxIncluded(true);
        } else if (ctx.getChild(5).getText().equals("[")) {
            stm.setMaxIncluded(false);
        }
        stm.setMaxBound(this.exprStack.pop());
        stm.setMinBound(this.exprStack.pop());
        this.peekNode(Block.class).addStatements(stm);
    }

    @Override
    public void exitAssignStatement(ABCDParser.AssignStatementContext ctx) {
        AssignStmt stm = new AssignStmt();
        stm.setRhs(this.exprStack.pop());
        stm.setLhs(this.exprStack.pop());
        this.peekNode(Block.class).addStatements(stm);
    }

    @Override
    public void enterBlock(ABCDParser.BlockContext ctx) {
        this.pushContext(new Block());
    }

    @Override
    public void exitBlock(ABCDParser.BlockContext ctx) {
        this.blockMap.put((ParseTree)ctx, (Object)((Block)this.popContext().getNode()));
    }

    private Statement buildIfChain(List<Expression> expressions, List<Block> blocks, IfStmt inIf) {
        if (expressions.isEmpty()) {
            if (blocks.isEmpty()) {
                return null;
            }
            return blocks.remove(0);
        }
        inIf.setCondition(expressions.remove(0));
        inIf.setTrueBranch(blocks.remove(0));
        inIf.setFalseBranch(this.buildIfChain(expressions, blocks, new IfStmt()));
        return inIf;
    }

    @Override
    public void exitIfStatement(ABCDParser.IfStatementContext ctx) {
        IfStmt stm = new IfStmt();
        int expSize = ctx.expression().size();
        Expression[] exps = new Expression[expSize];
        Block[] blocks = new Block[ctx.block().size()];
        for (int i = 0; i < expSize; ++i) {
            exps[expSize - i - 1] = this.exprStack.pop();
            blocks[i] = (Block)this.blockMap.get((ParseTree)ctx.block(i));
        }
        if (ctx.block().size() > expSize) {
            blocks[expSize] = (Block)this.blockMap.get((ParseTree)ctx.block(expSize));
        }
        this.buildIfChain(new LinkedList<Expression>(Arrays.asList(exps)), new LinkedList<Block>(Arrays.asList(blocks)), stm);
        this.peekNode(Block.class).addStatements(stm);
    }

    @Override
    public void enterFunctionDecl(ABCDParser.FunctionDeclContext ctx) {
        this.pushContext(new FunctionDecl(), new BaseScope(this.currentScope()));
    }

    @Override
    public void exitFunctionDecl(ABCDParser.FunctionDeclContext ctx) {
        FunctionDecl fd = (FunctionDecl)this.popContext().getNode();
        String id = ctx.IDENTIFIER().getText();
        fd.setName(id);
        fd.setBody((Block)this.blockMap.get((ParseTree)ctx.functionBody().block()));
        this.peekNode(ABCDSystem.class).addFunctions(fd);
    }

    @Override
    public void enterProcessDecl(ABCDParser.ProcessDeclContext ctx) {
        this.pushContext(new ProcessDecl(), new BaseScope(this.currentScope()));
    }

    @Override
    public void exitProcessDecl(ABCDParser.ProcessDeclContext ctx) {
        ProcessDecl pd = (ProcessDecl)this.popContext().getNode();
        String id = ctx.IDENTIFIER().getText();
        pd.setName(id);
        this.peekNode(ABCDSystem.class).addProcesses(pd);
    }

    @Override
    public void exitInitDecl(ABCDParser.InitDeclContext ctx) {
        Block init = (Block)this.blockMap.get((ParseTree)ctx.block());
        this.currentContext(ProcessDecl.class).setInitialization(init);
    }

    @Override
    public void enterPortList(ABCDParser.PortListContext ctx) {
        this.pushContext(new Port());
    }

    @Override
    public void exitPortList(ABCDParser.PortListContext ctx) {
        Port pt = (Port)this.popContext().getNode();
        for (ABCDParser.AnnotatedIdentifierContext s : ctx.identifierList().annotatedIdentifier()) {
            Port p = new Port();
            p.setType(pt.getType());
            p.setName(s.IDENTIFIER().getText());
            if (s.LTT() != null) {
                this.reportError("LTT annotation is not allowed in this context");
            }
            p.setIsInput(ctx.direction().start.getType() == 24);
            this.currentContext(DeclarationWithPorts.class).addPortsAndOpposite(p);
            this.defineInCurrentScope(p);
        }
    }

    @Override
    public void enterParameterList(ABCDParser.ParameterListContext ctx) {
        this.pushContext(new ParameterDecl());
    }

    @Override
    public void exitParameterList(ABCDParser.ParameterListContext ctx) {
        ParameterDecl pt = (ParameterDecl)this.popContext().getNode();
        for (ABCDParser.AnnotatedIdentifierContext s : ctx.typedIdentifierGroup().identifierList().annotatedIdentifier()) {
            ParameterDecl p = new ParameterDecl();
            p.setType(pt.getType());
            p.setName(s.IDENTIFIER().getText());
            if (s.LTT() != null) {
                this.reportError("LTT annotation is not allowed in this context");
            }
            this.currentContext(DeclarationWithParameters.class).addParametersAndOpposite(p);
            this.defineInCurrentScope(p);
        }
    }

    @Override
    public void enterInstantiation(ABCDParser.InstantiationContext ctx) {
        this.pushContext(new ProcessInstance());
    }

    @Override
    public void exitInstantiation(ABCDParser.InstantiationContext ctx) {
        ProcessInstance pI = (ProcessInstance)this.popContext().getNode();
        int size = ctx.IDENTIFIER().size();
        if (size == 2) {
            pI.setInstanceName(ctx.IDENTIFIER(0).getText());
        }
        pI.setName(ctx.IDENTIFIER(size - 1).getText());
        this.currentSystem().addCompositionAndOpposite(pI);
    }

    @Override
    public void exitArgumentMap(ABCDParser.ArgumentMapContext ctx) {
        if (ctx.formalActualMap() == null) {
            return;
        }
        List<ABCDParser.FormalActualAssociationContext> formalActualMap = ctx.formalActualMap().formalActualAssociation();
        int size = formalActualMap.size();
        ArgumentMap[] exp = new ArgumentMap[size];
        for (int i = 0; i < size; ++i) {
            ArgumentMap am = new ArgumentMap();
            if (formalActualMap.get(size - i - 1).IDENTIFIER() != null) {
                am.setFormalName(formalActualMap.get(size - i - 1).IDENTIFIER().getText());
            }
            am.setActual(this.exprStack.pop());
            exp[size - i - 1] = am;
        }
        this.peekNode(ElementWithArgumentMap.class).addAllArgumentsAndOpposite(Arrays.asList(exp));
    }

    private void buildPortMap(List<ABCDParser.FormalActualAssociationContext> list, boolean isInput) {
        int size = list.size();
        PortMap[] exp = new PortMap[size];
        for (int i = 0; i < size; ++i) {
            PortMap pm = new PortMap();
            if (list.get(size - i - 1).IDENTIFIER() != null) {
                pm.setFormalName(list.get(size - i - 1).IDENTIFIER().getText());
            }
            pm.setActual(this.exprStack.pop());
            exp[size - i - 1] = pm;
        }
        if (isInput) {
            this.peekNode(ProcessInstance.class).addAllInputs(Arrays.asList(exp));
        } else {
            this.peekNode(ProcessInstance.class).addAllOutputs(Arrays.asList(exp));
        }
    }

    @Override
    public void exitInputs(ABCDParser.InputsContext ctx) {
        this.buildPortMap(ctx.portMap().formalActualMap().formalActualAssociation(), true);
    }

    @Override
    public void exitOutputs(ABCDParser.OutputsContext ctx) {
        this.buildPortMap(ctx.portMap().formalActualMap().formalActualAssociation(), false);
    }

    @Override
    public void exitWhileStatement(ABCDParser.WhileStatementContext ctx) {
        WhileStmt stm = new WhileStmt();
        stm.setCondition(this.exprStack.pop());
        stm.setBody((Block)this.blockMap.get((ParseTree)ctx.block()));
        this.peekNode(Block.class).addStatements(stm);
    }

    @Override
    public void exitForeachStatement(ABCDParser.ForeachStatementContext ctx) {
        ForeachStmt stm = new ForeachStmt();
        Reference exp = new Reference();
        exp.setRef(this.resolveName(ctx.IDENTIFIER().getText(), NamedDeclaration.class));
        stm.setVariable(exp);
        stm.setBody((Block)this.blockMap.get((ParseTree)ctx.block()));
        this.peekNode(Block.class).addStatements(stm);
    }

    @Override
    public void exitNullStatement(ABCDParser.NullStatementContext ctx) {
        this.peekNode(Block.class).addStatements(new NullStmt());
    }

    @Override
    public void exitReturnStatement(ABCDParser.ReturnStatementContext ctx) {
        ReturnStmt stmt = new ReturnStmt();
        stmt.setExpression(this.exprStack.pop());
        this.peekNode(Block.class).addStatements(stmt);
    }

    @Override
    public void exitAnyExp(ABCDParser.AnyExpContext ctx) {
        this.exprStack.push(new Any());
    }

    @Override
    public void exitCaseItem(ABCDParser.CaseItemContext ctx) {
        CaseItem stmt = new CaseItem();
        stmt.setExpression(this.exprStack.pop());
        stmt.setBlock((Statement)this.blockMap.get((ParseTree)ctx.block()));
        this.peekNode(ElementWithCaseItems.class).addItems(stmt);
    }

    @Override
    public void enterCaseStatement(ABCDParser.CaseStatementContext ctx) {
        this.pushContext(new CaseStmt());
    }

    @Override
    public void exitCaseStatement(ABCDParser.CaseStatementContext ctx) {
        CaseStmt stmt = (CaseStmt)this.popContext().getNode();
        stmt.setExpression(this.exprStack.pop());
        this.peekNode(Block.class).addStatements(stmt);
    }

    @Override
    public void exitSendStatement(ABCDParser.SendStatementContext ctx) {
        SendStmt stmt = new SendStmt();
        Port p = this.resolveName(ctx.portName().IDENTIFIER().getText(), Port.class);
        if (p.isIsInput()) {
            this.reportError("Cannot use input port " + p.getName() + " in send statement");
            return;
        }
        stmt.setPort(p);
        stmt.setExpression(this.exprStack.pop());
        this.peekNode(Block.class).addStatements(stmt);
    }

    @Override
    public void exitReceiveStatement(ABCDParser.ReceiveStatementContext ctx) {
        ReceiveStmt stmt = new ReceiveStmt();
        Port p = this.resolveName(ctx.portName().IDENTIFIER().getText(), Port.class);
        if (!p.isIsInput()) {
            this.reportError("Cannot use output port " + p.getName() + " in receive statement");
            return;
        }
        stmt.setPort(p);
        stmt.setExpression(this.exprStack.pop());
        this.peekNode(Block.class).addStatements(stmt);
    }

    @Override
    public void exitDeferredEventGroup(ABCDParser.DeferredEventGroupContext ctx) {
        Port port = this.resolveName(ctx.portName().IDENTIFIER().getText(), Port.class);
        Type t = port.getType();
        while (t instanceof TypeDecl) {
            t = ((TypeDecl)t).getType();
        }
        Union vocabulary = null;
        if (!(t instanceof Union)) {
            this.reportError("Invalid port type (should be a port of union type)");
            return;
        }
        vocabulary = (Union)t;
        for (ABCDParser.AnnotatedIdentifierContext terminal : ctx.identifierList().annotatedIdentifier()) {
            boolean found = false;
            for (Field f : vocabulary.getFieldsList()) {
                if (!f.getName().equals(terminal.IDENTIFIER().getText())) continue;
                found = true;
                UnionLiteral lit = new UnionLiteral();
                lit.setType(vocabulary);
                lit.setSelector(f.getName());
                DeferredEvent deferred = new DeferredEvent();
                deferred.setPort(port);
                deferred.setEventType(lit);
                this.peekNode(Transition.class).addDeferredEvents(deferred);
                break;
            }
            if (found) continue;
            this.reportError("Invalid event type, no event '" + terminal.getText() + "'");
            return;
        }
    }

    @Override
    public void exitGuardStatement(ABCDParser.GuardStatementContext ctx) {
        GuardStmt guard = new GuardStmt();
        guard.setExpression(this.exprStack.pop());
        this.peekNode(Block.class).addStatements(guard);
    }
}

