/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.Assignment;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.Pattern;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class NonDeterministicAssignment
extends Assignment
implements BoostObject {
    private final List<Pattern> lhsList = new ArrayList<Pattern>();
    private Exp condition;

    public NonDeterministicAssignment() {
    }

    protected NonDeterministicAssignment(Boost boost) {
        super(boost);
        for (Pattern oneChild : BoostUtil.readObjectList((Boost)boost, Pattern.class)) {
            this.lhsList.add(oneChild);
        }
        this.condition = (Exp)boost.readObject(Exp.class);
    }

    public List<Pattern> getLhsList() {
        return Collections.unmodifiableList(this.lhsList);
    }

    public int getLhsCount() {
        return this.lhsList.size();
    }

    public Pattern getLhs(int index) {
        if (index < 0 || index >= this.getLhsCount()) {
            return null;
        }
        return this.lhsList.get(index);
    }

    public void addLhs(Pattern newValue) {
        this.addLhs(this.getLhsCount(), newValue);
    }

    public void addLhs(int index, Pattern newValue) {
        this.lhsList.add(index, newValue);
    }

    public Pattern setLhs(int index, Pattern newValue) {
        return this.lhsList.set(index, newValue);
    }

    public void addAllLhs(Collection<Pattern> toAddList) {
        for (Pattern newValue : toAddList) {
            this.addLhs(this.getLhsCount(), newValue);
        }
    }

    public void removeLhs(Pattern value) {
        int index = this.lhsList.indexOf(value);
        if (index >= 0) {
            this.removeLhs(index);
        }
    }

    public void removeLhs(int index) {
        this.lhsList.remove(index);
    }

    public Exp getCondition() {
        return this.condition;
    }

    public void setCondition(Exp newValue) {
        if (this.condition == null ? newValue != null : !this.condition.equals(newValue)) {
            this.condition = newValue;
        }
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeObjectCollection((Boost)boost, this.lhsList);
        boost.writeObject((BoostObject)this.condition);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitNonDeterministicAssignment(this);
    }
}

