/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import java.io.BufferedWriter;
import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.module.AnySet;
import tlc2.output.MP;
import tlc2.tool.EvalException;
import tlc2.tool.TLARegistry;
import tlc2.util.IdThread;
import tlc2.value.Applicable;
import tlc2.value.BoolValue;
import tlc2.value.FcnRcdValue;
import tlc2.value.IntValue;
import tlc2.value.IntervalValue;
import tlc2.value.RecordValue;
import tlc2.value.SetEnumValue;
import tlc2.value.SetOfFcnsValue;
import tlc2.value.SetOfRcdsValue;
import tlc2.value.SetOfTuplesValue;
import tlc2.value.StringValue;
import tlc2.value.TupleValue;
import tlc2.value.Value;
import tlc2.value.ValueConstants;
import tlc2.value.ValueVec;
import util.Assert;
import util.ToolIO;

public class TLC
implements ValueConstants {
    public static final long serialVersionUID = 20160822L;
    public static BufferedWriter OUTPUT;

    public static Value Print(Value v1, Value v2) {
        Value v1c = v1.deepCopy();
        Value v2c = v2.deepCopy();
        v1c.deepNormalize();
        v2c.deepNormalize();
        if (OUTPUT == null) {
            ToolIO.out.println(Value.ppr(v1c.toString()) + "  " + Value.ppr(v2c.toString()));
        } else {
            try {
                OUTPUT.write(Value.ppr(v1c.toString()) + "  " + Value.ppr(v2c.toString()) + "\n");
            }
            catch (IOException e) {
                MP.printError(1000, e);
            }
        }
        return v2;
    }

    public static Value PrintT(Value v1) {
        Value v1c = v1.deepCopy();
        v1c.deepNormalize();
        if (OUTPUT == null) {
            String ppr = Value.ppr(v1c.toString());
            ToolIO.out.println(ppr);
        } else {
            try {
                OUTPUT.write(Value.ppr(v1c.toString("\n")));
            }
            catch (IOException e) {
                MP.printError(1000, e);
            }
        }
        return ValTrue;
    }

    public static Value ToString(Value v) {
        return new StringValue(v.toString());
    }

    public static Value Assert(Value v1, Value v2) {
        if (v1 instanceof BoolValue && ((BoolValue)v1).val) {
            return v1;
        }
        throw new EvalException(2132, Value.ppr(v2.toString()));
    }

    public static Value JavaTime() {
        int t = (int)System.currentTimeMillis();
        return IntValue.gen(t & Integer.MAX_VALUE);
    }

    public static Value TLCGet(Value vidx) {
        int idx;
        if (vidx instanceof IntValue && (idx = ((IntValue)vidx).val) >= 0) {
            Thread th = Thread.currentThread();
            Value res = null;
            res = th instanceof IdThread ? ((IdThread)th).getLocalValue(idx) : (TLCGlobals.mainChecker != null ? TLCGlobals.mainChecker.getValue(0, idx) : TLCGlobals.simulator.getLocalValue(idx));
            if (res == null) {
                throw new EvalException(2145, String.valueOf(idx));
            }
            return res;
        }
        throw new EvalException(2169, new String[]{"\b", "TLCGet", "nonnegative integer", Value.ppr(vidx.toString())});
    }

    public static Value TLCSet(Value vidx, Value val) {
        int idx;
        if (vidx instanceof IntValue && (idx = ((IntValue)vidx).val) >= 0) {
            Thread th = Thread.currentThread();
            if (th instanceof IdThread) {
                ((IdThread)th).setLocalValue(idx, val);
            } else if (TLCGlobals.mainChecker != null) {
                TLCGlobals.mainChecker.setAllValues(idx, val);
            } else {
                TLCGlobals.simulator.setLocalValue(idx, val);
            }
            return ValTrue;
        }
        throw new EvalException(2169, new String[]{"first", "TLCSet", "nonnegative integer", Value.ppr(vidx.toString())});
    }

    public static Value MakeFcn(Value d, Value e) {
        Value[] dom = new Value[1];
        Value[] vals = new Value[1];
        dom[0] = d;
        vals[0] = e;
        return new FcnRcdValue(dom, vals, true);
    }

    public static Value CombineFcn(Value f1, Value f2) {
        FcnRcdValue fcn1 = FcnRcdValue.convert(f1);
        FcnRcdValue fcn2 = FcnRcdValue.convert(f2);
        if (fcn1 == null) {
            throw new EvalException(2169, new String[]{"first", "@@", "function", Value.ppr(f1.toString())});
        }
        if (fcn2 == null) {
            throw new EvalException(2169, new String[]{"second", "@@", "function", Value.ppr(f2.toString())});
        }
        ValueVec dom = new ValueVec();
        ValueVec vals = new ValueVec();
        Value[] vals1 = fcn1.values;
        Value[] vals2 = fcn2.values;
        Value[] dom1 = fcn1.domain;
        if (dom1 == null) {
            IntervalValue intv1 = fcn1.intv;
            for (int i = intv1.low; i <= intv1.high; ++i) {
                dom.addElement(IntValue.gen(i));
                vals.addElement(vals1[i - intv1.low]);
            }
        } else {
            for (int i = 0; i < dom1.length; ++i) {
                dom.addElement(dom1[i]);
                vals.addElement(vals1[i]);
            }
        }
        int len1 = dom.size();
        Value[] dom2 = fcn2.domain;
        if (dom2 == null) {
            IntervalValue intv2 = fcn2.intv;
            for (int i = intv2.low; i <= intv2.high; ++i) {
                IntValue val = IntValue.gen(i);
                boolean found = false;
                for (int j = 0; j < len1; ++j) {
                    if (!((Object)val).equals(dom.elementAt(j))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                dom.addElement(val);
                vals.addElement(vals2[i - intv2.low]);
            }
        } else {
            for (int i = 0; i < dom2.length; ++i) {
                Value val = dom2[i];
                boolean found = false;
                for (int j = 0; j < len1; ++j) {
                    if (!val.equals(dom.elementAt(j))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                dom.addElement(val);
                vals.addElement(vals2[i]);
            }
        }
        Value[] domain = new Value[dom.size()];
        Value[] values = new Value[dom.size()];
        for (int i = 0; i < domain.length; ++i) {
            domain[i] = dom.elementAt(i);
            values[i] = vals.elementAt(i);
        }
        return new FcnRcdValue(domain, values, false);
    }

    public static Value SortSeq(Value s, Value cmp) {
        TupleValue seq = TupleValue.convert(s);
        if (seq == null) {
            throw new EvalException(2169, new String[]{"first", "SortSeq", "natural number", Value.ppr(s.toString())});
        }
        if (!(cmp instanceof Applicable)) {
            throw new EvalException(2169, new String[]{"second", "SortSeq", "function", Value.ppr(cmp.toString())});
        }
        Applicable fcmp = (Applicable)((Object)cmp);
        Value[] elems = seq.elems;
        int len = elems.length;
        if (len == 0) {
            return seq;
        }
        Value[] args = new Value[2];
        Value[] newElems = new Value[len];
        newElems[0] = elems[0];
        for (int i = 1; i < len; ++i) {
            int j = i;
            args[0] = elems[i];
            args[1] = newElems[j - 1];
            while (TLC.compare(fcmp, args)) {
                newElems[j] = newElems[j - 1];
                if (--j == 0) break;
                args[1] = newElems[j - 1];
            }
            newElems[j] = args[0];
        }
        return new TupleValue(newElems);
    }

    private static boolean compare(Applicable fcmp, Value[] args) {
        Value res = fcmp.apply(args, 0);
        if (res instanceof BoolValue) {
            return ((BoolValue)res).val;
        }
        throw new EvalException(2169, new String[]{"second", "SortSeq", "noolean function", Value.ppr(res.toString())});
    }

    public static Value Permutations(Value s) {
        SetEnumValue s1 = SetEnumValue.convert(s);
        if (s1 == null) {
            throw new EvalException(2176, new String[]{"Permutations", "a finite set", Value.ppr(s.toString())});
        }
        s1.normalize();
        ValueVec elems = s1.elems;
        int len = elems.size();
        if (len == 0) {
            Value[] elems1 = new Value[]{EmptyFcn};
            return new SetEnumValue(elems1, true);
        }
        int factorial = 1;
        Value[] domain = new Value[len];
        int[] idxArray = new int[len];
        boolean[] inUse = new boolean[len];
        for (int i = 0; i < len; ++i) {
            domain[i] = elems.elementAt(i);
            idxArray[i] = i;
            inUse[i] = true;
            factorial *= i + 1;
        }
        ValueVec fcns = new ValueVec(factorial);
        block1: while (true) {
            int i;
            Value[] vals = new Value[len];
            for (i = 0; i < len; ++i) {
                vals[i] = domain[idxArray[i]];
            }
            fcns.addElement(new FcnRcdValue(domain, vals, true));
            for (i = len - 1; i >= 0; --i) {
                boolean found = false;
                for (int j = idxArray[i] + 1; j < len; ++j) {
                    if (inUse[j]) continue;
                    inUse[j] = true;
                    inUse[idxArray[i]] = false;
                    idxArray[i] = j;
                    found = true;
                    break;
                }
                if (found) break;
                if (i == 0) break block1;
                inUse[idxArray[i]] = false;
            }
            int j = i + 1;
            while (true) {
                if (j >= len) continue block1;
                for (int k = 0; k < len; ++k) {
                    if (inUse[k]) continue;
                    inUse[k] = true;
                    idxArray[j] = k;
                    break;
                }
                ++j;
            }
            break;
        }
        return new SetEnumValue(fcns, false);
    }

    public static Value RandomElement(Value val) {
        switch (val.getKind()) {
            case 13: {
                SetOfFcnsValue sfv = (SetOfFcnsValue)val;
                sfv.normalize();
                SetEnumValue domSet = SetEnumValue.convert(sfv.domain);
                if (domSet == null) {
                    throw new EvalException(2176, new String[]{"RandomElement", "a finite set", Value.ppr(val.toString())});
                }
                domSet.normalize();
                ValueVec elems = domSet.elems;
                Value[] dom = new Value[elems.size()];
                Value[] vals = new Value[elems.size()];
                for (int i = 0; i < dom.length; ++i) {
                    dom[i] = elems.elementAt(i);
                    vals[i] = TLC.RandomElement(sfv.range);
                }
                return new FcnRcdValue(dom, vals, true);
            }
            case 14: {
                SetOfRcdsValue srv = (SetOfRcdsValue)val;
                srv.normalize();
                Value[] vals = new Value[srv.names.length];
                for (int i = 0; i < vals.length; ++i) {
                    vals[i] = TLC.RandomElement(srv.values[i]);
                }
                return new RecordValue(srv.names, vals, true);
            }
            case 15: {
                SetOfTuplesValue stv = (SetOfTuplesValue)val;
                stv.normalize();
                Value[] vals = new Value[stv.sets.length];
                for (int i = 0; i < vals.length; ++i) {
                    vals[i] = TLC.RandomElement(stv.sets[i]);
                }
                return new TupleValue(vals);
            }
        }
        SetEnumValue enumVal = SetEnumValue.convert(val);
        if (enumVal == null) {
            throw new EvalException(2176, new String[]{"RandomElement", "a finite set", Value.ppr(val.toString())});
        }
        return enumVal.randomElement();
    }

    public static Value Any() {
        return AnySet.ANY();
    }

    public static Value TLCEval(Value val) {
        Value evalVal = SetEnumValue.convert(val);
        if (evalVal != null) {
            return evalVal;
        }
        evalVal = FcnRcdValue.convert(val);
        if (evalVal != null) {
            return evalVal;
        }
        return val;
    }

    static {
        Assert.check(TLARegistry.put("MakeFcn", ":>") == null, 2131, "MakeFcn");
        Assert.check(TLARegistry.put("CombineFcn", "@@") == null, 2131, "CombineFcn");
    }
}

