/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.Debug;

public abstract class CharReader {
    private String currentLine = null;
    private boolean uninitialized = true;
    protected int line = 0;
    private int column = 0;
    private int vcolumn = 0;
    private boolean tabToSpaces = false;

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.vcolumn;
    }

    public char getNextChar() {
        if (this.uninitialized) {
            this.currentLine = this.innerGetNextLine();
            this.uninitialized = false;
        }
        if (this.currentLine == null) {
            return '\t';
        }
        if (this.tabToSpaces) {
            ++this.vcolumn;
            if (this.vcolumn % 8 == 0) {
                this.tabToSpaces = false;
            }
            return ' ';
        }
        if (this.currentLine.length() == this.column) {
            ++this.line;
            this.column = 0;
            this.vcolumn = 0;
            this.currentLine = this.innerGetNextLine();
            return '\n';
        }
        char readChar = this.currentLine.charAt(this.column);
        ++this.column;
        ++this.vcolumn;
        if (readChar == '\t') {
            if (this.vcolumn % 8 != 0) {
                this.tabToSpaces = true;
            }
            return ' ';
        }
        return readChar;
    }

    public void backspace() {
        if (this.column == 0) {
            Debug.ReportBug("CharReader.backspace trying to move past beginning of line");
        }
        --this.column;
        --this.vcolumn;
    }

    public abstract String innerGetNextLine();

    public abstract void close();
}

