/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.state_event.diagnosis.dsl.model;

import obp2.language.state_event.diagnosis.dsl.DiagnosisModelVisitor;
import obp2.language.state_event.diagnosis.dsl.model.DiagnosisExp;
import obp2.language.state_event.diagnosis.dsl.model.Type;

public class ConditionalExp
extends DiagnosisExp {
    DiagnosisExp condition;
    DiagnosisExp trueBranch;
    DiagnosisExp falseBranch;

    public DiagnosisExp getCondition() {
        return this.condition;
    }

    public DiagnosisExp getTrueBranch() {
        return this.trueBranch;
    }

    public DiagnosisExp getFalseBranch() {
        return this.falseBranch;
    }

    public ConditionalExp(DiagnosisExp condition, DiagnosisExp trueBranch, DiagnosisExp falseBranch) {
        this.condition = condition;
        this.trueBranch = trueBranch;
        this.falseBranch = falseBranch;
    }

    @Override
    public Type getType() {
        if (this.type == null || this.type == Type.UNKNOWN) {
            Type condT = this.condition.getType();
            Type trueT = this.trueBranch.getType();
            Type falseT = this.falseBranch.getType();
            if (condT != Type.BOOLEAN) {
                throw new RuntimeException("the condition should be boolean");
            }
            if (trueT != falseT) {
                throw new RuntimeException("both conditional branches should have the same type");
            }
            this.type = trueT;
            return this.type;
        }
        return this.type;
    }

    @Override
    public <T> T accept(DiagnosisModelVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

