/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.bitstate;

import java.util.Arrays;
import java.util.Random;
import obp2.hash.SpookyHashV2;

class BloomFilter {
    int capacity = 1024;
    boolean[] store = new boolean[this.capacity];
    int size = 0;
    int seed = new Random().nextInt();

    BloomFilter() {
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        if (!(o instanceof byte[])) {
            return false;
        }
        return this.store[Arrays.hashCode((byte[])o) % this.capacity];
    }

    public boolean add(byte[] bytes) {
        int hash = SpookyHashV2.hash32((byte[])bytes, (int)this.seed);
        int slot = (hash > 0 ? hash : -hash) % this.capacity;
        boolean alreadyIn = this.store[slot];
        this.store[slot] = true;
        if (!alreadyIn) {
            ++this.size;
        }
        return !alreadyIn;
    }

    public boolean remove(byte[] bytes) {
        int hash = Arrays.hashCode(bytes);
        int slot = (hash > 0 ? hash : -hash) % this.capacity;
        boolean wasIn = this.store[slot];
        if (wasIn) {
            --this.size;
        }
        this.store[slot] = false;
        return wasIn;
    }
}

