/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.model;

import java.lang.reflect.Method;
import org.xid.basics.model.ChangeMark;
import org.xid.basics.model.ModelObject;

public class PutObjectChangeMark
extends ChangeMark {
    protected final ModelObject receiver;
    protected final String attributeName;
    protected final Object index;
    protected final Object oldValue;

    public PutObjectChangeMark(long timestamp, ModelObject receiver, String attributeName, Object index, Object oldValue) {
        super(timestamp);
        this.receiver = receiver;
        this.attributeName = attributeName;
        this.index = index;
        this.oldValue = oldValue;
    }

    protected String getRemoverName() {
        String firstUppercaseAttribute = this.attributeName.substring(0, 1).toUpperCase() + this.attributeName.substring(1);
        return "remove" + firstUppercaseAttribute;
    }

    protected String getPutterName() {
        String firstUppercaseAttribute = this.attributeName.substring(0, 1).toUpperCase() + this.attributeName.substring(1);
        return "put" + firstUppercaseAttribute;
    }

    @Override
    public void undo() {
        try {
            if (this.oldValue == null) {
                this.undoAdd();
            } else {
                this.undoPut();
            }
        }
        catch (Exception e) {
            System.err.println("PutObjectChangeMark.undo(): " + e.getClass().getName());
        }
    }

    private void undoPut() throws Exception {
        Method method = this.getMethod(this.receiver.getClass(), this.getPutterName(), this.index.getClass(), this.oldValue.getClass());
        if (method != null) {
            method.invoke((Object)this.receiver, this.index, this.oldValue);
        } else {
            System.err.println("PutObjectChangeMark.undoPut():No method to undo");
        }
    }

    private void undoAdd() throws Exception {
        Method method = this.getMethod(this.receiver.getClass(), this.getRemoverName(), new Class[]{null});
        if (method != null) {
            method.invoke((Object)this.receiver, this.index);
        } else {
            System.err.println("PutObjectChangeMark.undoAdd():No method to undo");
        }
    }

    @Override
    public String toString() {
        return "Put|" + this.attributeName;
    }
}

