/*
 * Decompiled with CFR 0.152.
 */
package obp2.runtime.core.defaults;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import obp2.runtime.core.TreeItem;
import plug.utils.ObjectGraphExploration;
import plug.utils.Pair;

public class Object2TreeItem {
    Visitor visitor = new Visitor();
    ObjectGraphExploration explorer = new ObjectGraphExploration((ObjectGraphExploration.IVisitor)this.visitor);

    public static TreeItem getTreeItem(Object o) {
        Object2TreeItem o2t = new Object2TreeItem();
        o2t.explorer.explore(o, o.getClass());
        return (TreeItem)o2t.visitor.stack.pop().children.stream().findAny().get();
    }

    public static void main(String[] args) {
        Object2TreeItem o2t = new Object2TreeItem();
        byte[][] bytes = new byte[3][2];
        Pair pair = new Pair((Object)2, (Object)3);
        o2t.explorer.explore((Object)bytes, bytes.getClass());
        System.out.println(o2t.visitor.stack.peek().children);
    }

    class Visitor
    implements ObjectGraphExploration.IVisitor {
        ArrayDeque<TreeItem> stack = new ArrayDeque();

        public Visitor() {
            this.stack.push(new TreeItem("root", new ArrayList<TreeItem>()));
        }

        public boolean startObject(Object object, Class<?> clazz) {
            if (object == null) {
                return false;
            }
            if (clazz.isEnum()) {
                TreeItem node = new TreeItem(object.toString(), new ArrayList<TreeItem>());
                this.stack.push(node);
                return true;
            }
            if (object instanceof String) {
                TreeItem node = new TreeItem(object.toString());
                this.stack.push(node);
                return false;
            }
            TreeItem node = new TreeItem(object.toString(), new ArrayList<TreeItem>());
            this.stack.push(node);
            return true;
        }

        public boolean endObject(Object object, Class<?> clazz) {
            if (object == null) {
                return false;
            }
            TreeItem item = this.stack.pop();
            TreeItem parent = this.stack.peek();
            parent.children.add(item);
            return false;
        }

        public boolean startPrimitive(Object object, Class<?> clazz) {
            this.stack.push(new TreeItem(object.toString()));
            return true;
        }

        public boolean endPrimitive(Object object, Class<?> clazz) {
            TreeItem item = this.stack.pop();
            TreeItem parent = this.stack.peek();
            parent.children.add(item);
            return false;
        }

        public boolean startArray(Object object, Class<?> clazz) {
            if (object == null) {
                return false;
            }
            if (object instanceof boolean[]) {
                TreeItem node = new TreeItem(Arrays.toString((boolean[])object));
                this.stack.push(node);
                return false;
            }
            if (object instanceof byte[]) {
                TreeItem node = new TreeItem(Arrays.toString((byte[])object));
                this.stack.push(node);
                return false;
            }
            if (object instanceof int[]) {
                TreeItem node = new TreeItem(Arrays.toString((int[])object));
                this.stack.push(node);
                return false;
            }
            if (object instanceof float[]) {
                TreeItem node = new TreeItem(Arrays.toString((float[])object));
                this.stack.push(node);
                return false;
            }
            if (object instanceof double[]) {
                TreeItem node = new TreeItem(Arrays.toString((double[])object));
                this.stack.push(node);
                return false;
            }
            if (object instanceof Object[]) {
                TreeItem node = new TreeItem(Arrays.toString((Object[])object), new ArrayList<TreeItem>());
                this.stack.push(node);
                return true;
            }
            TreeItem node = new TreeItem(object.getClass().getSimpleName(), new ArrayList<TreeItem>());
            this.stack.push(node);
            return true;
        }

        public boolean endArray(Object object, Class<?> clazz) {
            if (object == null) {
                return false;
            }
            TreeItem item = this.stack.pop();
            TreeItem parent = this.stack.peek();
            parent.children.add(item);
            return false;
        }

        public boolean startField(Field field, Object object, Class<?> clazz) {
            try {
                Object o = field.get(object);
                if (clazz.isEnum() || clazz.isPrimitive() || o instanceof String) {
                    TreeItem treeItem = new TreeItem(field.getName() + " = " + (o == null ? "null" : o.toString()));
                    this.stack.push(treeItem);
                    return false;
                }
                TreeItem treeItem = new TreeItem(field.getName() + " =  [" + clazz.getSimpleName() + "]", new ArrayList<TreeItem>());
                this.stack.push(treeItem);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return true;
        }

        public boolean endField(Field field, Object object, Class<?> clazz) {
            TreeItem item = this.stack.pop();
            TreeItem parent = this.stack.peek();
            parent.children.add(item);
            return false;
        }
    }
}

