/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.compiler;

import java.util.ArrayList;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.ABCDWalker;
import org.cte.ABCD.compiler.PrimitiveUtils;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.kernel.TypedElement;
import org.cte.ABCD.model.types.MutexType;

public class MutexChecker {
    public List<VariableDecl> localMutexList(ABCDSystem sys) {
        ArrayList<VariableDecl> mutexVars = new ArrayList<VariableDecl>();
        for (ProcessDecl pD : sys.getProcessesList()) {
            mutexVars.addAll(this.localMutexList(pD));
        }
        return mutexVars;
    }

    public List<VariableDecl> localMutexList(final ProcessDecl process) {
        final ArrayList<VariableDecl> mutexVars = new ArrayList<VariableDecl>();
        for (final VariableDecl vD : process.getVariablesList()) {
            vD.accept(new ABCDVisitor.Stub(){

                @Override
                public void visitVariableDecl(VariableDecl toVisit) {
                    toVisit.getType().accept(this);
                }

                @Override
                public void visitMutexType(MutexType toVisit) {
                    mutexVars.add(vD);
                    System.out.println("WARNING: local mutex '" + vD.getName() + "' in process " + process.getName() + " will be removed");
                }
            });
        }
        return mutexVars;
    }

    public List<TypedElement> unusedMutexList(ABCDSystem sys) {
        ArrayList<TypedElement> unusedM = new ArrayList<TypedElement>();
        for (ProcessDecl process : sys.getProcessesList()) {
            for (TypedElement typedElement : this.mutexList(process)) {
                if (!PrimitiveUtils.lockOnMutex(typedElement, process).isEmpty() || !PrimitiveUtils.unlockOnMutex(typedElement, process).isEmpty()) continue;
                unusedM.add(typedElement);
            }
        }
        return unusedM;
    }

    public List<ParameterDecl> incompleteMutexList(ABCDSystem sys) {
        ArrayList<ParameterDecl> incompleteM = new ArrayList<ParameterDecl>();
        for (ProcessDecl process : sys.getProcessesList()) {
            for (ParameterDecl mutex : this.mutexList(process)) {
                boolean nolock = PrimitiveUtils.lockOnMutex(mutex, process).isEmpty();
                boolean nounlock = PrimitiveUtils.unlockOnMutex(mutex, process).isEmpty();
                if (!nolock && nounlock) {
                    System.err.println("Process " + process.getName() + " locks mutex '" + mutex.getName() + "' and does not unlock it");
                }
                if (!nolock && !nounlock) continue;
                incompleteM.add(mutex);
            }
        }
        return incompleteM;
    }

    public List<ParameterDecl> mutexList(ProcessDecl process) {
        final ArrayList<ParameterDecl> mutexAtt = new ArrayList<ParameterDecl>();
        for (final ParameterDecl aD : process.getParametersList()) {
            aD.accept(new ABCDWalker(new ABCDVisitor.Stub(){

                @Override
                public void visitParameterDecl(ParameterDecl toVisit) {
                    toVisit.getType().accept(this);
                }

                @Override
                public void visitMutexType(MutexType toVisit) {
                    mutexAtt.add(aD);
                }
            }));
        }
        return mutexAtt;
    }
}

