/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.data.types.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.data.types.complex.DerivedType;

public abstract class CompositeType
extends DerivedType {
    private final List<DerivedType> nestedTypesList = new ArrayList<DerivedType>();

    public List<DerivedType> getNestedTypesList() {
        return Collections.unmodifiableList(this.nestedTypesList);
    }

    public int getNestedTypesCount() {
        return this.nestedTypesList.size();
    }

    public DerivedType getNestedTypes(int index) {
        if (index < 0 || index >= this.getNestedTypesCount()) {
            return null;
        }
        return this.nestedTypesList.get(index);
    }

    public void addNestedTypes(DerivedType newValue) {
        this.addNestedTypes(this.getNestedTypesCount(), newValue);
    }

    public void addNestedTypes(int index, DerivedType newValue) {
        this.nestedTypesList.add(index, newValue);
    }

    public DerivedType setNestedTypes(int index, DerivedType newValue) {
        return this.nestedTypesList.set(index, newValue);
    }

    public void addAllNestedTypes(Collection<DerivedType> toAddList) {
        for (DerivedType newValue : toAddList) {
            this.addNestedTypes(this.getNestedTypesCount(), newValue);
        }
    }

    public void removeNestedTypes(DerivedType value) {
        int index = this.nestedTypesList.indexOf(value);
        if (index >= 0) {
            this.removeNestedTypes(index);
        }
    }

    public void removeNestedTypes(int index) {
        this.nestedTypesList.remove(index);
    }

    public void addNestedTypesAndOpposite(DerivedType newValue) {
        this.addNestedTypes(newValue);
        if (newValue != null) {
            newValue.setParentType(this);
        }
    }

    public void addAllNestedTypesAndOpposite(Collection<DerivedType> toAddList) {
        for (DerivedType newValue : toAddList) {
            this.addNestedTypesAndOpposite(this.getNestedTypesCount(), newValue);
        }
    }

    public void addNestedTypesAndOpposite(int index, DerivedType newValue) {
        this.addNestedTypes(index, newValue);
        if (newValue != null) {
            newValue.setParentType(this);
        }
    }

    public DerivedType setNestedTypesAndOpposite(int index, DerivedType newValue) {
        DerivedType oldValue = this.nestedTypesList.set(index, newValue);
        if (newValue != null) {
            newValue.setParentType(this);
        }
        return oldValue;
    }

    public void removeNestedTypesAndOpposite(DerivedType removed) {
        this.removeNestedTypes(removed);
        if (removed != null) {
            removed.setParentType(null);
        }
    }

    public void removeNestedTypesAndOpposite(int index) {
        DerivedType removed = this.nestedTypesList.get(index);
        this.removeNestedTypes(index);
        if (removed != null) {
            removed.setParentType(null);
        }
    }

    @Override
    public abstract void accept(If2Visitor var1);
}

