/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.fiacre;

import java.lang.reflect.Field;
import java.util.Stack;
import obp.event.Event;
import obp.event.EventVisitor;
import obp.event.GammaEvent;
import obp.event.Informal;
import obp.event.Input;
import obp.event.Output;
import obp.event.PredicateEvent;
import obp.event.Signal;
import obp.event.Synchronous;
import obp.event.Value;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.fiacre.LiteralToMatcher;
import obp.explorer.runtime.matcher.AsynchronousEventMatcher;
import obp.explorer.runtime.matcher.ClassMatcher;
import obp.explorer.runtime.matcher.ComposedMatcher;
import obp.explorer.runtime.matcher.ConstantMatcher;
import obp.explorer.runtime.matcher.FieldMatcher;
import obp.explorer.runtime.matcher.Matcher;
import obp.explorer.runtime.matcher.SynchronousEventMatcher;
import obp.explorer.runtime.obs.InformalAction;
import obp.literal.Literal;
import obp.util.CDLUtil;

public class ActionEventToMatcher
implements EventVisitor {
    private final ExplorationContext context;
    private final SymbolsTable symbols;
    private final Stack<Matcher> matcherStack = new Stack();

    public static Matcher toMatcher(Event event, ExplorationContext context, SymbolsTable symbols) {
        ActionEventToMatcher transformer = new ActionEventToMatcher(context, symbols);
        event.accept(transformer);
        return transformer.matcherStack.pop();
    }

    private ActionEventToMatcher(ExplorationContext context, SymbolsTable symbols) {
        this.context = context;
        this.symbols = symbols;
    }

    @Override
    public void visitGammaEvent(GammaEvent toVisit) {
        throw new IllegalArgumentException("Gamma event should be removed.");
    }

    @Override
    public void visitPredicateEvent(PredicateEvent toVisit) {
        throw new IllegalArgumentException("Predicate event aren't I/O events.");
    }

    @Override
    public void visitInformal(Informal toVisit) {
        try {
            Matcher[] matchers;
            Class<InformalAction> informalClass = InformalAction.class;
            ClassMatcher classMatcher = new ClassMatcher(this.context, informalClass);
            short informalId = this.symbols.getInformalId(toVisit.getTag());
            ConstantMatcher constantMatcher = new ConstantMatcher(this.context, informalId);
            Field informalIdField = informalClass.getField("informalId");
            FieldMatcher informalIdFieldMatcher = new FieldMatcher(this.context, informalIdField, constantMatcher);
            if (toVisit.getFrom() != null) {
                short fromId = this.symbols.getBehaviorId(CDLUtil.toString(toVisit.getFrom()));
                Field fromIdField = informalClass.getField("behaviorId");
                FieldMatcher fromIdFieldMatcher = new FieldMatcher(this.context, fromIdField, new ConstantMatcher(this.context, fromId));
                matchers = new Matcher[]{classMatcher, informalIdFieldMatcher, fromIdFieldMatcher};
            } else {
                matchers = new Matcher[]{classMatcher, informalIdFieldMatcher};
            }
            ComposedMatcher composedMatcher = new ComposedMatcher(this.context, matchers);
            this.matcherStack.push(composedMatcher);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Internal error, field 'informalId' doesn't exist in InformalAction, contact OBP team.");
        }
    }

    @Override
    public void visitInput(Input toVisit) {
        Literal literal = toVisit.getMessage().getLiteral();
        this.matcherStack.push(LiteralToMatcher.toMatcher(literal, this.context));
        short targetId = toVisit.getTo() == null ? (short)-1 : (short)this.symbols.getBehaviorId(CDLUtil.toString(toVisit.getTo()));
        AsynchronousEventMatcher matcher = new AsynchronousEventMatcher(this.context, 1, targetId, this.matcherStack.pop());
        this.matcherStack.push(matcher);
    }

    @Override
    public void visitOutput(Output toVisit) {
        Literal literal = toVisit.getMessage().getLiteral();
        this.matcherStack.push(LiteralToMatcher.toMatcher(literal, this.context));
        short sourceId = toVisit.getFrom() == null ? (short)-1 : (short)this.symbols.getBehaviorId(CDLUtil.toString(toVisit.getFrom()));
        AsynchronousEventMatcher matcher = new AsynchronousEventMatcher(this.context, 2, sourceId, this.matcherStack.pop());
        this.matcherStack.push(matcher);
    }

    @Override
    public void visitSynchronous(Synchronous toVisit) {
        Signal signal = toVisit.getMessage();
        Matcher[] messageMatchers = new Matcher[signal.getArgumentCount()];
        for (int i = 0; i < messageMatchers.length; ++i) {
            messageMatchers[i] = LiteralToMatcher.toMatcher(signal.getArgument(i), this.context);
        }
        short channelId = this.symbols.getChannelId(CDLUtil.toString(signal.getPid()) + ":" + signal.getName());
        short sourceId = toVisit.getFrom() == null ? (short)-1 : (short)this.symbols.getBehaviorId(CDLUtil.toString(toVisit.getFrom()));
        short targetId = toVisit.getTo() == null ? (short)-1 : (short)this.symbols.getBehaviorId(CDLUtil.toString(toVisit.getTo()));
        SynchronousEventMatcher matcher = new SynchronousEventMatcher(this.context, channelId, sourceId, targetId, messageMatchers);
        this.matcherStack.push(matcher);
    }

    @Override
    public void visitSignal(Signal toVisit) {
    }

    @Override
    public void visitValue(Value toVisit) {
    }
}

