/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Enumeration;
import java.util.Hashtable;
import tla2sany.explorer.ExploreNode;
import tla2sany.semantic.Context;
import tla2sany.semantic.ModuleNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import util.UniqueString;

public class ExternalModuleTable
implements ExploreNode {
    public Hashtable moduleHashTable = new Hashtable();
    public Vector moduleNodeVector = new Vector();
    public ModuleNode rootModule;

    public ModuleNode getRootModule() {
        return this.rootModule;
    }

    public void setRootModule(ModuleNode mn) {
        this.rootModule = mn;
    }

    public final Context getContext(UniqueString key) {
        ExternalModuleTableEntry p = (ExternalModuleTableEntry)this.moduleHashTable.get(key);
        if (p == null) {
            return null;
        }
        return p.ctxt;
    }

    public ModuleNode[] getModuleNodes() {
        ModuleNode[] mods = new ModuleNode[this.moduleNodeVector.size()];
        for (int i = 0; i < mods.length; ++i) {
            mods[i] = (ModuleNode)this.moduleNodeVector.elementAt(i);
        }
        return mods;
    }

    public final ModuleNode getModuleNode(UniqueString key) {
        ExternalModuleTableEntry p = (ExternalModuleTableEntry)this.moduleHashTable.get(key);
        if (p == null) {
            return null;
        }
        return p.moduleNode;
    }

    public final void put(UniqueString key, Context ctxt, ModuleNode moduleNode) {
        ExternalModuleTableEntry c = (ExternalModuleTableEntry)this.moduleHashTable.get(key);
        if (c == null) {
            this.moduleHashTable.put(key, new ExternalModuleTableEntry(ctxt, moduleNode));
            this.moduleNodeVector.addElement(moduleNode);
        }
    }

    public String toString() {
        Enumeration Enum2 = this.moduleHashTable.elements();
        String ret = "";
        int i = 1;
        while (Enum2.hasMoreElements()) {
            ExternalModuleTableEntry mte = (ExternalModuleTableEntry)Enum2.nextElement();
            ret = ret + mte.toString();
            ++i;
        }
        return "\nModule Table:" + Strings.indent(2, ret);
    }

    public void printExternalModuleTable(int depth, boolean b) {
        System.out.print("\nExternal Module Table:");
        for (int i = 0; i < this.moduleNodeVector.size(); ++i) {
            ModuleNode mn = (ModuleNode)this.moduleNodeVector.elementAt(i);
            if (mn != null) {
                System.out.print(Strings.indent(2, "\nModule: "));
                mn.print(2, depth, b);
                continue;
            }
            System.out.print(Strings.indent(2, "\nModule: " + Strings.indent(2, "\n***Null ExternalModuleTable entry; module contained error and was not created.")));
        }
    }

    @Override
    public String levelDataToString() {
        return "Dummy level string";
    }

    @Override
    public String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String ret = "";
        for (int i = 0; i < this.moduleNodeVector.size(); ++i) {
            ModuleNode mn = (ModuleNode)this.moduleNodeVector.elementAt(i);
            if (mn != null) {
                ret = ret + Strings.indent(2, "\nModule: " + Strings.indent(2, mn.toString(depth)));
                continue;
            }
            String str = "\n***Null ExternalModuleTable entry; module contained error and was not created.";
            ret = ret + Strings.indent(2, "\nModule: " + Strings.indent(2, str));
        }
        return ret;
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> moduleNodesTable) {
        Enumeration Enum2 = this.moduleHashTable.elements();
        while (Enum2.hasMoreElements()) {
            ExternalModuleTableEntry mte = (ExternalModuleTableEntry)Enum2.nextElement();
            mte.walkGraph(moduleNodesTable);
        }
    }

    public class ExternalModuleTableEntry
    implements ExploreNode {
        ModuleNode moduleNode;
        Context ctxt;

        ExternalModuleTableEntry(Context ctxt, ModuleNode modn) {
            this.ctxt = ctxt;
            this.moduleNode = modn;
        }

        public ModuleNode getModuleNode() {
            return this.moduleNode;
        }

        public void printMTE(int depth, boolean b) {
            if (this.moduleNode != null) {
                System.out.print(Strings.indent(2, "\nModule: "));
                this.moduleNode.print(2, depth, b);
            } else {
                System.out.print(Strings.indent(2, "\nModule: " + Strings.indent(2, "\n***Null ExternalModuleTable entry; module contained error and was not created.")));
            }
        }

        @Override
        public String levelDataToString() {
            return "Dummy level string";
        }

        @Override
        public void walkGraph(Hashtable<Integer, ExploreNode> moduleNodesTable) {
            if (this.moduleNode != null) {
                this.moduleNode.walkGraph(moduleNodesTable);
            }
            if (this.ctxt != null) {
                this.ctxt.walkGraph(moduleNodesTable);
            }
        }

        @Override
        public String toString(int depth) {
            if (depth <= 0) {
                return "";
            }
            if (this.moduleNode != null) {
                return Strings.indent(2, "\nModule: " + Strings.indent(2, this.moduleNode.toString(depth)));
            }
            return Strings.indent(2, "\nModule: " + Strings.indent(2, "\n***Null ExternalModuleTable entry; module contained error and was not created."));
        }
    }
}

