/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.sexp;

import java.util.HashMap;
import java.util.Map;
import org.xid.basics.sexp.SAtom;
import org.xid.basics.sexp.SExp;
import org.xid.basics.sexp.SExpVisitor;
import org.xid.basics.sexp.SList;
import org.xid.basics.sexp.SVariable;

public class SMatcher {
    private final SExpVisitor sCatcherSearchVisitor = new SExpVisitor.Walker(){

        @Override
        public void visit(SVariable toVisit) {
            String name = toVisit.getName();
            if (SMatcher.this.variableMap.containsKey(name)) {
                throw new IllegalArgumentException("Multiple catcher named '" + name + "'.");
            }
            SMatcher.this.variableMap.put(name, toVisit);
        }
    };
    private final SExp root;
    private final Map<String, SExp> variableMap = new HashMap<String, SExp>();

    public SMatcher(SExp root) {
        this.root = root;
        root.accept(this.sCatcherSearchVisitor);
    }

    public SMatcher(SExp ... elements) {
        this.root = new SList(elements);
        this.root.accept(this.sCatcherSearchVisitor);
    }

    public SExp getRoot() {
        return this.root;
    }

    public SExp catched(String name) {
        return this.variableMap.get(name);
    }

    public boolean matches(SExp tested) {
        return this.recursiveMatches(tested, this.root);
    }

    private boolean recursiveMatches(SExp tested, SExp tester) {
        if (tester instanceof SVariable) {
            SVariable variable = (SVariable)tester;
            this.variableMap.put(variable.getName(), tested);
            return true;
        }
        if (tested instanceof SAtom && tester instanceof SAtom) {
            return tested.getValue().equals(tester.getValue());
        }
        if (tested instanceof SList && tester instanceof SList) {
            int count = tested.getChildCount();
            if (tester.getChildCount() != count) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                SExp testerChild;
                SExp testedChild = tested.getChild(i);
                if (this.recursiveMatches(testedChild, testerChild = tester.getChild(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

