/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.behaviour;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.NamedElement;
import obp.if2.behaviour.Statement;
import obp.if2.behaviour.Transition;

public abstract class State
implements NamedElement {
    private final List<Transition> incomingTransitionsList = new ArrayList<Transition>();
    private Statement entryAction;
    private final List<State> nestedSubstatesList = new ArrayList<State>();
    private State entryState;
    private State parentState;
    private Statement exitAction;
    private final List<Transition> outgoingTransitionsList = new ArrayList<Transition>();
    private String name;

    public List<Transition> getIncomingTransitionsList() {
        return Collections.unmodifiableList(this.incomingTransitionsList);
    }

    public int getIncomingTransitionsCount() {
        return this.incomingTransitionsList.size();
    }

    public Transition getIncomingTransitions(int index) {
        if (index < 0 || index >= this.getIncomingTransitionsCount()) {
            return null;
        }
        return this.incomingTransitionsList.get(index);
    }

    public void addIncomingTransitions(Transition newValue) {
        this.addIncomingTransitions(this.getIncomingTransitionsCount(), newValue);
    }

    public void addIncomingTransitions(int index, Transition newValue) {
        this.incomingTransitionsList.add(index, newValue);
    }

    public Transition setIncomingTransitions(int index, Transition newValue) {
        return this.incomingTransitionsList.set(index, newValue);
    }

    public void addAllIncomingTransitions(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addIncomingTransitions(this.getIncomingTransitionsCount(), newValue);
        }
    }

    public void removeIncomingTransitions(Transition value) {
        int index = this.incomingTransitionsList.indexOf(value);
        if (index >= 0) {
            this.removeIncomingTransitions(index);
        }
    }

    public void removeIncomingTransitions(int index) {
        this.incomingTransitionsList.remove(index);
    }

    public void addIncomingTransitionsAndOpposite(Transition newValue) {
        this.addIncomingTransitions(newValue);
        if (newValue != null) {
            newValue.setTarget(this);
        }
    }

    public void addAllIncomingTransitionsAndOpposite(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addIncomingTransitionsAndOpposite(this.getIncomingTransitionsCount(), newValue);
        }
    }

    public void addIncomingTransitionsAndOpposite(int index, Transition newValue) {
        this.addIncomingTransitions(index, newValue);
        if (newValue != null) {
            newValue.setTarget(this);
        }
    }

    public Transition setIncomingTransitionsAndOpposite(int index, Transition newValue) {
        Transition oldValue = this.incomingTransitionsList.set(index, newValue);
        if (newValue != null) {
            newValue.setTarget(this);
        }
        return oldValue;
    }

    public void removeIncomingTransitionsAndOpposite(Transition removed) {
        this.removeIncomingTransitions(removed);
        if (removed != null) {
            removed.setTarget(null);
        }
    }

    public void removeIncomingTransitionsAndOpposite(int index) {
        Transition removed = this.incomingTransitionsList.get(index);
        this.removeIncomingTransitions(index);
        if (removed != null) {
            removed.setTarget(null);
        }
    }

    public Statement getEntryAction() {
        return this.entryAction;
    }

    public void setEntryAction(Statement newValue) {
        if (this.entryAction == null ? newValue != null : !this.entryAction.equals(newValue)) {
            this.entryAction = newValue;
        }
    }

    public List<State> getNestedSubstatesList() {
        return Collections.unmodifiableList(this.nestedSubstatesList);
    }

    public int getNestedSubstatesCount() {
        return this.nestedSubstatesList.size();
    }

    public State getNestedSubstates(int index) {
        if (index < 0 || index >= this.getNestedSubstatesCount()) {
            return null;
        }
        return this.nestedSubstatesList.get(index);
    }

    public void addNestedSubstates(State newValue) {
        this.addNestedSubstates(this.getNestedSubstatesCount(), newValue);
    }

    public void addNestedSubstates(int index, State newValue) {
        this.nestedSubstatesList.add(index, newValue);
    }

    public State setNestedSubstates(int index, State newValue) {
        return this.nestedSubstatesList.set(index, newValue);
    }

    public void addAllNestedSubstates(Collection<State> toAddList) {
        for (State newValue : toAddList) {
            this.addNestedSubstates(this.getNestedSubstatesCount(), newValue);
        }
    }

    public void removeNestedSubstates(State value) {
        int index = this.nestedSubstatesList.indexOf(value);
        if (index >= 0) {
            this.removeNestedSubstates(index);
        }
    }

    public void removeNestedSubstates(int index) {
        this.nestedSubstatesList.remove(index);
    }

    public void addNestedSubstatesAndOpposite(State newValue) {
        this.addNestedSubstates(newValue);
        if (newValue != null) {
            newValue.setParentState(this);
        }
    }

    public void addAllNestedSubstatesAndOpposite(Collection<State> toAddList) {
        for (State newValue : toAddList) {
            this.addNestedSubstatesAndOpposite(this.getNestedSubstatesCount(), newValue);
        }
    }

    public void addNestedSubstatesAndOpposite(int index, State newValue) {
        this.addNestedSubstates(index, newValue);
        if (newValue != null) {
            newValue.setParentState(this);
        }
    }

    public State setNestedSubstatesAndOpposite(int index, State newValue) {
        State oldValue = this.nestedSubstatesList.set(index, newValue);
        if (newValue != null) {
            newValue.setParentState(this);
        }
        return oldValue;
    }

    public void removeNestedSubstatesAndOpposite(State removed) {
        this.removeNestedSubstates(removed);
        if (removed != null) {
            removed.setParentState(null);
        }
    }

    public void removeNestedSubstatesAndOpposite(int index) {
        State removed = this.nestedSubstatesList.get(index);
        this.removeNestedSubstates(index);
        if (removed != null) {
            removed.setParentState(null);
        }
    }

    public State getEntryState() {
        return this.entryState;
    }

    public void setEntryState(State newValue) {
        if (this.entryState != newValue) {
            this.entryState = newValue;
        }
    }

    public State getParentState() {
        return this.parentState;
    }

    public void setParentState(State newValue) {
        if (this.parentState != newValue) {
            this.parentState = newValue;
        }
    }

    public Statement getExitAction() {
        return this.exitAction;
    }

    public void setExitAction(Statement newValue) {
        if (this.exitAction == null ? newValue != null : !this.exitAction.equals(newValue)) {
            this.exitAction = newValue;
        }
    }

    public List<Transition> getOutgoingTransitionsList() {
        return Collections.unmodifiableList(this.outgoingTransitionsList);
    }

    public int getOutgoingTransitionsCount() {
        return this.outgoingTransitionsList.size();
    }

    public Transition getOutgoingTransitions(int index) {
        if (index < 0 || index >= this.getOutgoingTransitionsCount()) {
            return null;
        }
        return this.outgoingTransitionsList.get(index);
    }

    public void addOutgoingTransitions(Transition newValue) {
        this.addOutgoingTransitions(this.getOutgoingTransitionsCount(), newValue);
    }

    public void addOutgoingTransitions(int index, Transition newValue) {
        this.outgoingTransitionsList.add(index, newValue);
    }

    public Transition setOutgoingTransitions(int index, Transition newValue) {
        return this.outgoingTransitionsList.set(index, newValue);
    }

    public void addAllOutgoingTransitions(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addOutgoingTransitions(this.getOutgoingTransitionsCount(), newValue);
        }
    }

    public void removeOutgoingTransitions(Transition value) {
        int index = this.outgoingTransitionsList.indexOf(value);
        if (index >= 0) {
            this.removeOutgoingTransitions(index);
        }
    }

    public void removeOutgoingTransitions(int index) {
        this.outgoingTransitionsList.remove(index);
    }

    public void addOutgoingTransitionsAndOpposite(Transition newValue) {
        this.addOutgoingTransitions(newValue);
        if (newValue != null) {
            newValue.setSource(this);
        }
    }

    public void addAllOutgoingTransitionsAndOpposite(Collection<Transition> toAddList) {
        for (Transition newValue : toAddList) {
            this.addOutgoingTransitionsAndOpposite(this.getOutgoingTransitionsCount(), newValue);
        }
    }

    public void addOutgoingTransitionsAndOpposite(int index, Transition newValue) {
        this.addOutgoingTransitions(index, newValue);
        if (newValue != null) {
            newValue.setSource(this);
        }
    }

    public Transition setOutgoingTransitionsAndOpposite(int index, Transition newValue) {
        Transition oldValue = this.outgoingTransitionsList.set(index, newValue);
        if (newValue != null) {
            newValue.setSource(this);
        }
        return oldValue;
    }

    public void removeOutgoingTransitionsAndOpposite(Transition removed) {
        this.removeOutgoingTransitions(removed);
        if (removed != null) {
            removed.setSource(null);
        }
    }

    public void removeOutgoingTransitionsAndOpposite(int index) {
        Transition removed = this.outgoingTransitionsList.get(index);
        this.removeOutgoingTransitions(index);
        if (removed != null) {
            removed.setSource(null);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public abstract void accept(If2Visitor var1);
}

