/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDBitVector;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDException;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;
import net.sf.javabdd.BuDDyFactory;

public class TypedBDDFactory
extends BDDFactory {
    static PrintStream out = System.out;
    static boolean STACK_TRACES = true;
    BDDFactory factory;
    public static final Comparator domain_comparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            BDDDomain d1 = (BDDDomain)arg0;
            BDDDomain d2 = (BDDDomain)arg1;
            if (d1.getIndex() < d2.getIndex()) {
                return -1;
            }
            if (d1.getIndex() > d2.getIndex()) {
                return 1;
            }
            return 0;
        }
    };
    public static final String REVISION = "$Revision: 1.7 $";

    public TypedBDDFactory(BDDFactory f) {
        this.factory = f;
    }

    public static BDDFactory init(int nodenum, int cachesize) {
        String factoryName = TypedBDDFactory.getProperty("bdd", null);
        BDDFactory a = factoryName != null && factoryName.equals("typed") ? BuDDyFactory.init(nodenum, cachesize) : BDDFactory.init(nodenum, cachesize);
        return new TypedBDDFactory(a);
    }

    public BDD zero() {
        return new TypedBDD(this.factory.zero(), TypedBDDFactory.makeSet());
    }

    public BDD one() {
        Set s = TypedBDDFactory.makeSet();
        return new TypedBDD(this.factory.one(), s);
    }

    protected void initialize(int nodenum, int cachesize) {
        this.factory.initialize(nodenum, cachesize);
    }

    public boolean isInitialized() {
        return this.factory.isInitialized();
    }

    public void done() {
        this.factory.done();
    }

    public void setError(int code) {
        this.factory.setError(code);
    }

    public void clearError() {
        this.factory.clearError();
    }

    public int setMaxNodeNum(int size) {
        return this.factory.setMaxNodeNum(size);
    }

    public int setNodeTableSize(int size) {
        return this.factory.setNodeTableSize(size);
    }

    public int setCacheSize(int size) {
        return this.factory.setCacheSize(size);
    }

    public double setMinFreeNodes(double x) {
        return this.factory.setMinFreeNodes(x);
    }

    public double setIncreaseFactor(double x) {
        return this.factory.setIncreaseFactor(x);
    }

    public int setMaxIncrease(int x) {
        return this.factory.setMaxIncrease(x);
    }

    public double setCacheRatio(double x) {
        return this.factory.setCacheRatio(x);
    }

    public int varNum() {
        return this.factory.varNum();
    }

    public int setVarNum(int num) {
        return this.factory.setVarNum(num);
    }

    public int duplicateVar(int var) {
        return this.factory.duplicateVar(var);
    }

    public BDDDomain whichDomain(int var) {
        for (int i = 0; i < this.numberOfDomains(); ++i) {
            int[] vars = this.getDomain(i).vars();
            for (int j = 0; j < vars.length; ++j) {
                if (var != vars[j]) continue;
                return this.getDomain(i);
            }
        }
        return null;
    }

    public BDD ithVar(int var) {
        Set s = TypedBDDFactory.makeSet();
        return new TypedBDD(this.factory.ithVar(var), s);
    }

    public BDD nithVar(int var) {
        Set s = TypedBDDFactory.makeSet();
        return new TypedBDD(this.factory.nithVar(var), s);
    }

    public void printAll() {
        this.factory.printAll();
    }

    public void printTable(BDD b) {
        TypedBDD bdd1 = (TypedBDD)b;
        this.factory.printTable(bdd1.bdd);
    }

    public BDD load(String filename) throws IOException {
        Set d = TypedBDDFactory.makeSet();
        return new TypedBDD(this.factory.load(filename), d);
    }

    public void save(String filename, BDD var) throws IOException {
        TypedBDD bdd1 = (TypedBDD)var;
        this.factory.save(filename, bdd1.bdd);
    }

    public int level2Var(int level) {
        return this.factory.level2Var(level);
    }

    public int var2Level(int var) {
        return this.factory.var2Level(var);
    }

    public void reorder(BDDFactory.ReorderMethod m) {
        this.factory.reorder(m);
    }

    public void autoReorder(BDDFactory.ReorderMethod method) {
        this.factory.autoReorder(method);
    }

    public void autoReorder(BDDFactory.ReorderMethod method, int max) {
        this.factory.autoReorder(method, max);
    }

    public BDDFactory.ReorderMethod getReorderMethod() {
        return this.factory.getReorderMethod();
    }

    public int getReorderTimes() {
        return this.factory.getReorderTimes();
    }

    public void disableReorder() {
        this.factory.disableReorder();
    }

    public void enableReorder() {
        this.factory.enableReorder();
    }

    public int reorderVerbose(int v) {
        return this.factory.reorderVerbose(v);
    }

    public void setVarOrder(int[] neworder) {
        this.factory.setVarOrder(neworder);
    }

    public void addVarBlock(BDD var, boolean fixed) {
        TypedBDD bdd1 = (TypedBDD)var;
        this.factory.addVarBlock(bdd1.bdd, fixed);
    }

    public void addVarBlock(int first, int last, boolean fixed) {
        this.factory.addVarBlock(first, last, fixed);
    }

    public void varBlockAll() {
        this.factory.varBlockAll();
    }

    public void clearVarBlocks() {
        this.factory.clearVarBlocks();
    }

    public void printOrder() {
        this.factory.printOrder();
    }

    public int nodeCount(Collection r) {
        LinkedList<BDD> s = new LinkedList<BDD>();
        Iterator i = r.iterator();
        while (i.hasNext()) {
            TypedBDD bdd1 = (TypedBDD)i.next();
            s.add(bdd1.bdd);
        }
        return this.factory.nodeCount(s);
    }

    public int getNodeTableSize() {
        return this.factory.getNodeTableSize();
    }

    public int getNodeNum() {
        return this.factory.getNodeNum();
    }

    public int getCacheSize() {
        return this.factory.getCacheSize();
    }

    public int reorderGain() {
        return this.factory.reorderGain();
    }

    public void printStat() {
        this.factory.printStat();
    }

    public BDDPairing makePair() {
        return new TypedBDDPairing(this.factory.makePair());
    }

    public void swapVar(int v1, int v2) {
        this.factory.swapVar(v1, v2);
    }

    protected BDDDomain createDomain(int a, BigInteger b) {
        return new TypedBDDDomain(this.factory.getDomain(a), a, b);
    }

    protected BDDBitVector createBitVector(int a) {
        return this.factory.createBitVector(a);
    }

    public BDDDomain[] extDomain(long[] domainSizes) {
        this.factory.extDomain(domainSizes);
        return super.extDomain(domainSizes);
    }

    public static Set makeSet() {
        return new TreeSet(domain_comparator);
    }

    public static Set makeSet(Set s) {
        TreeSet r = new TreeSet(domain_comparator);
        r.addAll(s);
        return r;
    }

    public Set allDomains() {
        Set r = TypedBDDFactory.makeSet();
        for (int i = 0; i < this.factory.numberOfDomains(); ++i) {
            r.add(this.factory.getDomain(i));
        }
        return r;
    }

    public static Map makeMap() {
        return new TreeMap(domain_comparator);
    }

    public static String domainNames(Set dom) {
        StringBuffer sb = new StringBuffer();
        Iterator i = dom.iterator();
        while (i.hasNext()) {
            BDDDomain d = (BDDDomain)i.next();
            sb.append(d.getName());
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public String getVersion() {
        return "TypedBDD " + REVISION.substring(11, REVISION.length() - 2) + " with " + this.factory.getVersion();
    }

    private static class TypedBDDPairing
    extends BDDPairing {
        final Map domMap = TypedBDDFactory.makeMap();
        final BDDPairing pairing;

        TypedBDDPairing(BDDPairing pairing) {
            this.pairing = pairing;
        }

        public void set(BDDDomain p1, BDDDomain p2) {
            if (this.domMap.containsValue(p2)) {
                out.println("Warning! Set domain that already exists: " + p2.getName());
            }
            this.domMap.put(p1, p2);
            this.pairing.set(p1, p2);
        }

        public void set(int oldvar, int newvar) {
            this.pairing.set(oldvar, newvar);
        }

        public void set(int oldvar, BDD newvar) {
            throw new BDDException();
        }

        public void reset() {
            this.domMap.clear();
            this.pairing.reset();
        }
    }

    private class TypedBDDDomain
    extends BDDDomain {
        BDDDomain domain;

        protected TypedBDDDomain(BDDDomain domain, int index, BigInteger range) {
            super(index, range);
            this.domain = domain;
        }

        public BDDFactory getFactory() {
            return TypedBDDFactory.this;
        }

        public BDD ithVar(long val) {
            BDD v = this.domain.ithVar(val);
            Set s = TypedBDDFactory.makeSet();
            s.add(this);
            return new TypedBDD(v, s);
        }

        public BDD domain() {
            BDD v = this.domain.domain();
            Set s = TypedBDDFactory.makeSet();
            s.add(this);
            return new TypedBDD(v, s);
        }

        public BDD buildAdd(BDDDomain that, int bits, long value) {
            TypedBDDDomain d = (TypedBDDDomain)that;
            BDD v = this.domain.buildAdd(d.domain, bits, value);
            Set s = TypedBDDFactory.makeSet();
            s.add(this);
            s.add(that);
            return new TypedBDD(v, s);
        }

        public BDD buildEquals(BDDDomain that) {
            TypedBDDDomain d = (TypedBDDDomain)that;
            BDD v = this.domain.buildEquals(d.domain);
            Set s = TypedBDDFactory.makeSet();
            s.add(this);
            s.add(that);
            return new TypedBDD(v, s);
        }

        public BDD set() {
            BDD v = this.domain.set();
            Set s = TypedBDDFactory.makeSet();
            s.add(this);
            return new TypedBDD(v, s);
        }

        public BDD varRange(BigInteger lo, BigInteger hi) {
            BDD v = this.domain.varRange(lo, hi);
            Set s = TypedBDDFactory.makeSet();
            s.add(this);
            return new TypedBDD(v, s);
        }
    }

    public class TypedBDD
    extends BDD {
        final BDD bdd;
        final Set dom;

        public TypedBDD(BDD bdd2, Set dom) {
            this.bdd = bdd2;
            this.dom = dom;
        }

        public Set getDomainSet() {
            return this.dom;
        }

        public void setDomains(Set d) {
            this.dom.clear();
            this.dom.addAll(d);
        }

        public void setDomains(BDDDomain d) {
            this.dom.clear();
            this.dom.add(d);
        }

        public void setDomains(BDDDomain d1, BDDDomain d2) {
            this.dom.clear();
            this.dom.add(d1);
            this.dom.add(d2);
        }

        public void setDomains(BDDDomain d1, BDDDomain d2, BDDDomain d3) {
            this.dom.clear();
            this.dom.add(d1);
            this.dom.add(d2);
            this.dom.add(d3);
        }

        public void setDomains(BDDDomain d1, BDDDomain d2, BDDDomain d3, BDDDomain d4) {
            this.dom.clear();
            this.dom.add(d1);
            this.dom.add(d2);
            this.dom.add(d3);
            this.dom.add(d4);
        }

        public void setDomains(BDDDomain d1, BDDDomain d2, BDDDomain d3, BDDDomain d4, BDDDomain d5) {
            this.dom.clear();
            this.dom.add(d1);
            this.dom.add(d2);
            this.dom.add(d3);
            this.dom.add(d4);
            this.dom.add(d5);
        }

        BDD getDomains() {
            BDD b = TypedBDDFactory.this.factory.one();
            Iterator i = this.dom.iterator();
            while (i.hasNext()) {
                TypedBDDDomain d = (TypedBDDDomain)i.next();
                b.andWith(d.domain.set());
            }
            return b;
        }

        public BDDFactory getFactory() {
            return TypedBDDFactory.this;
        }

        public boolean isZero() {
            return this.bdd.isZero();
        }

        public boolean isOne() {
            return this.bdd.isOne();
        }

        public int var() {
            return this.bdd.var();
        }

        public BDD high() {
            return new TypedBDD(this.bdd.high(), TypedBDDFactory.makeSet(this.dom));
        }

        public BDD low() {
            return new TypedBDD(this.bdd.low(), TypedBDDFactory.makeSet(this.dom));
        }

        public BDD id() {
            return new TypedBDD(this.bdd.id(), TypedBDDFactory.makeSet(this.dom));
        }

        public BDD not() {
            return new TypedBDD(this.bdd.not(), TypedBDDFactory.makeSet(this.dom));
        }

        public BDD ite(BDD thenBDD, BDD elseBDD) {
            TypedBDD bdd1 = (TypedBDD)thenBDD;
            TypedBDD bdd2 = (TypedBDD)elseBDD;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            newDom.addAll(bdd1.dom);
            newDom.addAll(bdd2.dom);
            return new TypedBDD(this.bdd.ite(bdd1.bdd, bdd2.bdd), newDom);
        }

        public BDD relprod(BDD that, BDD var) {
            TypedBDD bdd1 = (TypedBDD)that;
            TypedBDD bdd2 = (TypedBDD)var;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            newDom.addAll(bdd1.dom);
            if (!newDom.containsAll(bdd2.dom)) {
                out.println("Warning! Quantifying domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd2.dom));
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            newDom.removeAll(bdd2.dom);
            return new TypedBDD(this.bdd.relprod(bdd1.bdd, bdd2.bdd), newDom);
        }

        public BDD compose(BDD g, int var) {
            TypedBDD bdd1 = (TypedBDD)g;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            return new TypedBDD(this.bdd.compose(bdd1.bdd, var), newDom);
        }

        public BDD veccompose(BDDPairing pair) {
            TypedBDDPairing p = (TypedBDDPairing)pair;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            return new TypedBDD(this.bdd.veccompose(p.pairing), newDom);
        }

        public BDD constrain(BDD that) {
            TypedBDD bdd1 = (TypedBDD)that;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            return new TypedBDD(this.bdd.constrain(bdd1.bdd), newDom);
        }

        public BDD exist(BDD var) {
            TypedBDD bdd1 = (TypedBDD)var;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            if (!newDom.containsAll(bdd1.dom)) {
                out.println("Warning! Quantifying domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd1.dom));
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            newDom.removeAll(bdd1.dom);
            return new TypedBDD(this.bdd.exist(bdd1.bdd), newDom);
        }

        public BDD forAll(BDD var) {
            TypedBDD bdd1 = (TypedBDD)var;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            if (!newDom.containsAll(bdd1.dom)) {
                out.println("Warning! Quantifying domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd1.dom));
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            newDom.removeAll(bdd1.dom);
            return new TypedBDD(this.bdd.forAll(bdd1.bdd), newDom);
        }

        public BDD unique(BDD var) {
            TypedBDD bdd1 = (TypedBDD)var;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            if (!newDom.containsAll(bdd1.dom)) {
                out.println("Warning! Quantifying domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd1.dom));
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            newDom.removeAll(bdd1.dom);
            return new TypedBDD(this.bdd.unique(bdd1.bdd), newDom);
        }

        public BDD restrict(BDD var) {
            TypedBDD bdd1 = (TypedBDD)var;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            if (!newDom.containsAll(bdd1.dom)) {
                out.println("Warning! Restricting domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd1.dom));
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            if (bdd1.bdd.satCount(bdd1.getDomains()) > 1.0) {
                out.println("Warning! Using restrict with more than one value");
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            newDom.removeAll(bdd1.dom);
            return new TypedBDD(this.bdd.restrict(bdd1.bdd), newDom);
        }

        public BDD restrictWith(BDD var) {
            TypedBDD bdd1 = (TypedBDD)var;
            if (!this.dom.containsAll(bdd1.dom)) {
                out.println("Warning! Restricting domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd1.dom));
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            if (bdd1.bdd.satCount(bdd1.getDomains()) > 1.0) {
                out.println("Warning! Using restrict with more than one value");
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            this.dom.removeAll(bdd1.dom);
            this.bdd.restrictWith(bdd1.bdd);
            return this;
        }

        public BDD simplify(BDD d) {
            TypedBDD bdd1 = (TypedBDD)d;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            return new TypedBDD(this.bdd.simplify(bdd1.bdd), newDom);
        }

        public BDD support() {
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            return new TypedBDD(this.bdd.support(), newDom);
        }

        void applyHelper(Set newDom, TypedBDD bdd0, TypedBDD bdd1, BDDFactory.BDDOp opr) {
            switch (opr.id) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    if (!(bdd0.isZero() || bdd1.isZero() || ((Object)newDom).equals(bdd1.dom))) {
                        out.println("Warning! Or'ing BDD with different domains: " + TypedBDDFactory.domainNames(newDom) + " != " + TypedBDDFactory.domainNames(bdd1.dom));
                        if (STACK_TRACES) {
                            new Exception().printStackTrace(out);
                        }
                    }
                }
                case 0: 
                case 3: {
                    newDom.addAll(bdd1.dom);
                    break;
                }
                default: {
                    throw new BDDException();
                }
            }
        }

        public BDD apply(BDD that, BDDFactory.BDDOp opr) {
            TypedBDD bdd1 = (TypedBDD)that;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            this.applyHelper(newDom, this, bdd1, opr);
            return new TypedBDD(this.bdd.apply(bdd1.bdd, opr), newDom);
        }

        public BDD applyWith(BDD that, BDDFactory.BDDOp opr) {
            TypedBDD bdd1 = (TypedBDD)that;
            this.applyHelper(this.dom, this, bdd1, opr);
            this.bdd.applyWith(bdd1.bdd, opr);
            return this;
        }

        public BDD applyAll(BDD that, BDDFactory.BDDOp opr, BDD var) {
            TypedBDD bdd1 = (TypedBDD)that;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            this.applyHelper(newDom, this, bdd1, opr);
            TypedBDD bdd2 = (TypedBDD)var;
            if (!newDom.containsAll(bdd2.dom)) {
                out.println("Warning! Quantifying domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd2.dom));
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            newDom.removeAll(bdd2.dom);
            out.println(TypedBDDFactory.domainNames(this.dom) + " " + opr + " " + TypedBDDFactory.domainNames(bdd1.dom) + " / " + TypedBDDFactory.domainNames(bdd2.dom) + " = " + TypedBDDFactory.domainNames(newDom));
            return new TypedBDD(this.bdd.applyAll(bdd1.bdd, opr, bdd2.bdd), newDom);
        }

        public BDD applyEx(BDD that, BDDFactory.BDDOp opr, BDD var) {
            TypedBDD bdd1 = (TypedBDD)that;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            this.applyHelper(newDom, this, bdd1, opr);
            TypedBDD bdd2 = (TypedBDD)var;
            if (!newDom.containsAll(bdd2.dom)) {
                out.println("Warning! Quantifying domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd2.dom));
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            newDom.removeAll(bdd2.dom);
            out.println(TypedBDDFactory.domainNames(this.dom) + " " + opr + " " + TypedBDDFactory.domainNames(bdd1.dom) + " / " + TypedBDDFactory.domainNames(bdd2.dom) + " = " + TypedBDDFactory.domainNames(newDom));
            return new TypedBDD(this.bdd.applyEx(bdd1.bdd, opr, bdd2.bdd), newDom);
        }

        public BDD applyUni(BDD that, BDDFactory.BDDOp opr, BDD var) {
            TypedBDD bdd1 = (TypedBDD)that;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            this.applyHelper(newDom, this, bdd1, opr);
            TypedBDD bdd2 = (TypedBDD)var;
            if (!newDom.containsAll(bdd2.dom)) {
                out.println("Warning! Quantifying domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd2.dom));
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            newDom.removeAll(bdd2.dom);
            out.println(TypedBDDFactory.domainNames(this.dom) + " " + opr + " " + TypedBDDFactory.domainNames(bdd1.dom) + " / " + TypedBDDFactory.domainNames(bdd2.dom) + " = " + TypedBDDFactory.domainNames(newDom));
            return new TypedBDD(this.bdd.applyUni(bdd1.bdd, opr, bdd2.bdd), newDom);
        }

        public BDD satOne() {
            return new TypedBDD(this.bdd.satOne(), TypedBDDFactory.makeSet(this.dom));
        }

        public BDD fullSatOne() {
            return new TypedBDD(this.bdd.fullSatOne(), TypedBDDFactory.this.allDomains());
        }

        public BDD satOne(BDD var, boolean pol) {
            TypedBDD bdd1 = (TypedBDD)var;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            if (!newDom.containsAll(bdd1.dom)) {
                out.println("Warning! Selecting domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd1.dom));
                if (STACK_TRACES) {
                    new Exception().printStackTrace(out);
                }
            }
            newDom.addAll(bdd1.dom);
            return new TypedBDD(this.bdd.satOne(bdd1.bdd, pol), newDom);
        }

        public List allsat() {
            return this.bdd.allsat();
        }

        public BDD replace(BDDPairing pair) {
            TypedBDDPairing tpair = (TypedBDDPairing)pair;
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            Iterator i = tpair.domMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                BDDDomain d_from = (BDDDomain)e.getKey();
                BDDDomain d_to = (BDDDomain)e.getValue();
                if (!this.dom.contains(d_from)) {
                    out.println("Warning! Replacing domain that doesn't exist: " + d_from.getName());
                    new Exception().printStackTrace();
                }
                if (!this.dom.contains(d_to) || tpair.domMap.containsKey(d_to)) continue;
                out.println("Warning! Overwriting domain that exists: " + d_to.getName());
                new Exception().printStackTrace();
            }
            newDom.removeAll(tpair.domMap.keySet());
            newDom.addAll(tpair.domMap.values());
            return new TypedBDD(this.bdd.replace(tpair.pairing), newDom);
        }

        public BDD replaceWith(BDDPairing pair) {
            TypedBDDPairing tpair = (TypedBDDPairing)pair;
            Iterator i = tpair.domMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                BDDDomain d_from = (BDDDomain)e.getKey();
                BDDDomain d_to = (BDDDomain)e.getValue();
                if (!this.dom.contains(d_from)) {
                    out.println("Warning! Replacing domain that doesn't exist: " + d_from.getName());
                    new Exception().printStackTrace();
                }
                if (!this.dom.contains(d_to) || tpair.domMap.containsKey(d_to)) continue;
                out.println("Warning! Overwriting domain that exists: " + d_to.getName());
                new Exception().printStackTrace();
            }
            this.dom.removeAll(tpair.domMap.keySet());
            this.dom.addAll(tpair.domMap.values());
            this.bdd.replaceWith(tpair.pairing);
            return this;
        }

        public int nodeCount() {
            return this.bdd.nodeCount();
        }

        public double pathCount() {
            return this.bdd.pathCount();
        }

        public double satCount() {
            return this.bdd.satCount();
        }

        public double satCount(BDD set) {
            TypedBDD bdd1 = (TypedBDD)set;
            if (!this.bdd.isZero() && !((Object)bdd1.dom).equals(this.dom)) {
                out.println("Warning! satCount on the wrong domains: " + TypedBDDFactory.domainNames(this.dom) + " != " + TypedBDDFactory.domainNames(bdd1.dom));
                new Exception().printStackTrace();
            }
            return this.bdd.satCount(bdd1.bdd);
        }

        public int[] varProfile() {
            return this.bdd.varProfile();
        }

        public boolean equals(BDD that) {
            TypedBDD bdd1 = (TypedBDD)that;
            if (!this.dom.containsAll(bdd1.dom)) {
                out.println("Warning! Comparing domain that doesn't exist: " + TypedBDDFactory.domainNames(bdd1.dom));
            }
            return this.bdd.equals(bdd1.bdd);
        }

        public int hashCode() {
            return this.bdd.hashCode();
        }

        public BDD.BDDIterator iterator(BDD var) {
            TypedBDD bdd1 = (TypedBDD)var;
            if (!((Object)this.dom).equals(bdd1.dom)) {
                out.println("Warning! iterator on the wrong domain(s): " + TypedBDDFactory.domainNames(this.dom) + " != " + TypedBDDFactory.domainNames(bdd1.dom));
            }
            return super.iterator(var);
        }

        public BDD.BDDIterator iterator() {
            Set newDom = TypedBDDFactory.makeSet();
            newDom.addAll(this.dom);
            return super.iterator(new TypedBDD(this.getDomains(), newDom));
        }

        public void free() {
            this.bdd.free();
            this.dom.clear();
        }
    }
}

