/*
 * Decompiled with CFR 0.152.
 */
package obp.tina;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import obp.result.ExplorationResultInfo;
import obp.result.FinalState;
import obp.tool.OutputAnalyzer;

public class TinaResultAnalyzer
implements OutputAnalyzer<ExplorationResultInfo> {
    private static final Pattern statesPattern = Pattern.compile("^# *states +([0-9]+) +([0-9]+) +([0-9]+) +([0-9]+|\\?) +([0-9]+|\\?) *# *$");
    private static final Pattern transitionsPattern = Pattern.compile("^# *transitions +([0-9]+) +([0-9]+) +([0-9]+) +([0-9]+|\\?) +([0-9]+|\\?) *# *$");
    private ExplorationResultInfo result;

    public TinaResultAnalyzer(ExplorationResultInfo result) {
        this.result = result;
    }

    @Override
    public boolean hideOutput() {
        return false;
    }

    @Override
    public void analyze(String line) {
        Matcher matcher = statesPattern.matcher(line);
        if (matcher.matches()) {
            this.result.setConfigurationCount(BigInteger.valueOf(Long.parseLong(matcher.group(1))));
            this.result.setState("?".equals(matcher.group(4)) ? FinalState.Incomplete : FinalState.Complete);
        } else {
            matcher = transitionsPattern.matcher(line);
            if (matcher.matches()) {
                this.result.setActionCount(BigInteger.valueOf(Long.parseLong(matcher.group(1))));
                this.result.setState("?".equals(matcher.group(4)) ? FinalState.Incomplete : FinalState.Complete);
            }
        }
    }

    @Override
    public boolean ended(int value, double duration) {
        if (value != 0) {
            this.result.setState(FinalState.Incomplete);
        }
        this.result.setDuration(duration);
        return true;
    }

    @Override
    public ExplorationResultInfo getResult() {
        return this.result;
    }
}

