/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.ExternalArgument;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.Type;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class ExternalFunctionDecl
extends Declaration
implements BoostObject {
    private String externalName;
    private final List<ExternalArgument> argList = new ArrayList<ExternalArgument>();
    private Type returnType;

    public ExternalFunctionDecl() {
    }

    protected ExternalFunctionDecl(Boost boost) {
        super(boost);
        this.externalName = boost.readString();
        for (ExternalArgument oneChild : BoostUtil.readObjectList((Boost)boost, ExternalArgument.class)) {
            this.argList.add(oneChild);
        }
        this.returnType = (Type)boost.readObject(Type.class);
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String newValue) {
        if (this.externalName == null ? newValue != null : !this.externalName.equals(newValue)) {
            this.externalName = newValue;
        }
    }

    public List<ExternalArgument> getArgList() {
        return Collections.unmodifiableList(this.argList);
    }

    public int getArgCount() {
        return this.argList.size();
    }

    public ExternalArgument getArg(int index) {
        if (index < 0 || index >= this.getArgCount()) {
            return null;
        }
        return this.argList.get(index);
    }

    public void addArg(ExternalArgument newValue) {
        this.addArg(this.getArgCount(), newValue);
    }

    public void addArg(int index, ExternalArgument newValue) {
        this.argList.add(index, newValue);
    }

    public ExternalArgument setArg(int index, ExternalArgument newValue) {
        return this.argList.set(index, newValue);
    }

    public void addAllArg(Collection<ExternalArgument> toAddList) {
        for (ExternalArgument newValue : toAddList) {
            this.addArg(this.getArgCount(), newValue);
        }
    }

    public void removeArg(ExternalArgument value) {
        int index = this.argList.indexOf(value);
        if (index >= 0) {
            this.removeArg(index);
        }
    }

    public void removeArg(int index) {
        this.argList.remove(index);
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Type newValue) {
        if (this.returnType == null ? newValue != null : !this.returnType.equals(newValue)) {
            this.returnType = newValue;
        }
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        boost.writeString(this.externalName);
        BoostUtil.writeObjectCollection((Boost)boost, this.argList);
        boost.writeObject((BoostObject)this.returnType);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitExternalFunctionDecl(this);
    }
}

