/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl.diagram;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import obp.cdl.Activity;
import obp.cdl.CDLDeclaration;
import obp.ui.cdl.CDLResources;
import obp.ui.cdl.diagram.ActivityElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.FileDialog;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.Resources;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.DiagramUtils;
import org.xid.basics.ui.diagram.Element;
import org.xid.basics.ui.diagram.gc.GC;

public class CDLDiagram
extends Diagram<CDLDeclaration> {
    public static final RGB defaultBackGroundRgb = new RGB(255, 251, 246);
    private final Set<Activity> unfoldedSet = new HashSet<Activity>();

    public CDLDiagram() {
    }

    public CDLDiagram(CDLDeclaration cdl) {
        this.setModel(cdl);
    }

    public void build() {
        this.clearElements();
        if (this.getModel() != null) {
            ActivityElement main;
            float[] northWestPoint = new float[]{50.0f, 50.0f};
            float delta = 0.0f;
            ActivityElement init = null;
            if (((CDLDeclaration)this.getModel()).getInit() != null && (init = ActivityElement.createElement(this, ((CDLDeclaration)this.getModel()).getInit(), true, northWestPoint)) != null) {
                this.addElement((Element)init);
                northWestPoint = Geometry.copyPoints((float[])northWestPoint);
                northWestPoint[1] = northWestPoint[1] + init.size[1];
                delta = Math.max(init.getSize()[0] / 2.0f, delta);
            }
            if ((main = ActivityElement.createElement(this, ((CDLDeclaration)this.getModel()).getMain(), false, northWestPoint)) != null) {
                this.addElement((Element)main);
                delta = Math.max(main.getSize()[0] / 2.0f, delta);
            }
            if (init != null) {
                init.moveNorthPoint(delta, 0.0f);
            }
            if (main != null) {
                main.moveNorthPoint(delta, 0.0f);
            }
        }
        this.invalidateBounds();
    }

    public Class<? extends Resources> getResourcesClass() {
        return CDLResources.class;
    }

    public void resetGc(GC gc, DiagramContext context) {
        super.resetGc(gc, context);
    }

    public Color getBackground(DiagramContext context) {
        return context.getResources().getColor(defaultBackGroundRgb);
    }

    public void computeActions(List<Action> result, final DiagramContext context) {
        result.add((Action)new Action.Stub("Fold All", context.getResources().getImage("fold.gif")){

            public int getVisibility() {
                return CDLDiagram.this.unfoldedSet.isEmpty() ? 2 : 1;
            }

            public int run(ActionMonitor monitor) {
                CDLDiagram.this.unfoldedSet.clear();
                CDLDiagram.this.invalidateBounds();
                return 1;
            }
        });
        result.add((Action)new Action.Stub("Export to PNG\u2026", 8){

            public int run(ActionMonitor monitor) {
                FileDialog dialog = new FileDialog(context.getControl().getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.png"});
                dialog.setFilterNames(new String[]{"PNG image"});
                String filename = dialog.open();
                if (filename == null) {
                    return 2;
                }
                if (!filename.endsWith(".png")) {
                    filename = filename + ".png";
                }
                DiagramUtils.exportToImage((Diagram)CDLDiagram.this, (String)filename, (float)1.0f, (int)5);
                return 1;
            }
        });
    }

    public boolean isUnfolded(Activity activity) {
        return this.unfoldedSet.contains(activity);
    }

    public void setUnfolded(Activity activity, boolean folded) {
        if (folded) {
            this.unfoldedSet.add(activity);
        } else {
            this.unfoldedSet.remove(activity);
        }
    }
}

