/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.state_event.diagnosis.dsl.model;

import obp2.language.state_event.diagnosis.dsl.DiagnosisModelVisitor;
import obp2.language.state_event.diagnosis.dsl.model.DiagnosisExp;
import obp2.language.state_event.diagnosis.dsl.model.Type;

public class BinaryExp
extends DiagnosisExp {
    DiagnosisExp lhs;
    DiagnosisExp rhs;
    Operator operator;

    public DiagnosisExp getLhs() {
        return this.lhs;
    }

    public DiagnosisExp getRhs() {
        return this.rhs;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public BinaryExp(DiagnosisExp lhs, Operator operator, DiagnosisExp rhs) {
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    @Override
    public <T> T accept(DiagnosisModelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Type getType() {
        if (this.type == null || this.type == Type.UNKNOWN) {
            Type lhsT = this.lhs.getType();
            Type rhsT = this.rhs.getType();
            switch (this.operator) {
                case MULT: {
                    if (lhsT != Type.NUMBER || rhsT != Type.NUMBER) {
                        throw new RuntimeException("BinaryExp expecting number operands");
                    }
                    this.type = Type.NUMBER;
                    break;
                }
                case MOD: {
                    if (lhsT != Type.NUMBER || rhsT != Type.NUMBER) {
                        throw new RuntimeException("BinaryExp expecting number operands");
                    }
                    this.type = Type.NUMBER;
                    break;
                }
                case PLUS: {
                    if (lhsT != Type.NUMBER || rhsT != Type.NUMBER) {
                        throw new RuntimeException("BinaryExp expecting number operands");
                    }
                    this.type = Type.NUMBER;
                    break;
                }
                case MINUS: {
                    if (lhsT != Type.NUMBER || rhsT != Type.NUMBER) {
                        throw new RuntimeException("BinaryExp expecting number operands");
                    }
                    this.type = Type.NUMBER;
                    break;
                }
                case LT: {
                    if (lhsT != Type.NUMBER || rhsT != Type.NUMBER) {
                        throw new RuntimeException("BinaryExp expecting number operands");
                    }
                    this.type = Type.BOOLEAN;
                    break;
                }
                case LTE: {
                    if (lhsT != Type.NUMBER || rhsT != Type.NUMBER) {
                        throw new RuntimeException("BinaryExp expecting number operands");
                    }
                    this.type = Type.BOOLEAN;
                    break;
                }
                case GT: {
                    if (lhsT != Type.NUMBER || rhsT != Type.NUMBER) {
                        throw new RuntimeException("BinaryExp expecting number operands");
                    }
                    this.type = Type.BOOLEAN;
                    break;
                }
                case GTE: {
                    if (lhsT != Type.NUMBER || rhsT != Type.NUMBER) {
                        throw new RuntimeException("BinaryExp expecting number operands");
                    }
                    this.type = Type.BOOLEAN;
                    break;
                }
                case EQ: {
                    this.type = Type.BOOLEAN;
                    break;
                }
                case NEQ: {
                    this.type = Type.BOOLEAN;
                }
            }
            return this.type;
        }
        return this.type;
    }

    public static enum Operator {
        MULT,
        MOD,
        PLUS,
        MINUS,
        LT,
        LTE,
        GT,
        GTE,
        EQ,
        NEQ;

    }
}

