/*
 * Decompiled with CFR 0.152.
 */
package obp2.ui2.model_view;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Collection;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.Background;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import org.kordamp.ikonli.javafx.FontIcon;

public class LoadFilePane
extends HBox {
    String name;
    final FontIcon fileSelectIcon = new FontIcon("gmi-find-in-page:18");
    final FontIcon fileClearIcon = new FontIcon("gmi-close:18");
    final ObjectProperty<Path> path;
    final Collection<FileChooser.ExtensionFilter> extensionFilters;
    private SimpleObjectProperty<File> lastKnownDirectoryProperty = new SimpleObjectProperty();
    private File defaultDirectoryFile;
    private String initialDirectory;

    public LoadFilePane(String name, ObjectProperty<Path> path, Collection<FileChooser.ExtensionFilter> extensionFilters) {
        this.name = name;
        this.path = path;
        this.extensionFilters = extensionFilters;
        TextField pathTextField = new TextField();
        StringBinding pathBinding = Bindings.createStringBinding(() -> this.path.get() != null ? ((Path)this.path.get()).toString() : "No path selected", (Observable[])new Observable[]{this.path});
        pathTextField.textProperty().bind((ObservableValue)pathBinding);
        Button fileSelectBtn = new Button(null, (Node)this.fileSelectIcon);
        fileSelectBtn.setOnAction(this::selectFilePath);
        Button fileClearBtn = new Button(null, (Node)this.fileClearIcon);
        fileClearBtn.setOnAction(e -> path.set(null));
        ToolBar toolBar = new ToolBar();
        toolBar.setBackground(Background.EMPTY);
        toolBar.getItems().addAll((Object[])new Node[]{fileSelectBtn, fileClearBtn});
        File resDirectory = new File(".runtime-data");
        if (!resDirectory.exists()) {
            resDirectory.mkdir();
        }
        this.defaultDirectoryFile = new File(resDirectory, name + "_default_dir.txt");
        this.initialDirectory = null;
        if (this.defaultDirectoryFile.exists() && this.defaultDirectoryFile.isFile()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(this.defaultDirectoryFile));
                String initialDirectoryRead = br.readLine();
                br.close();
                File initialDirectoryFile = new File(initialDirectoryRead);
                if (initialDirectoryFile.exists() && initialDirectoryFile.isDirectory()) {
                    this.initialDirectory = initialDirectoryRead;
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        this.getChildren().addAll((Object[])new Node[]{new Label(" " + name + " "), pathTextField, toolBar});
        LoadFilePane.setHgrow((Node)pathTextField, (Priority)Priority.ALWAYS);
        this.setAlignment(Pos.CENTER);
    }

    public Object selectFilePath(Event evt) {
        FileChooser chooser = new FileChooser();
        chooser.initialDirectoryProperty().bindBidirectional(this.lastKnownDirectoryProperty);
        if (this.initialDirectory != null && this.lastKnownDirectoryProperty.getValue() == null) {
            chooser.setInitialDirectory(new File(this.initialDirectory));
        }
        chooser.getExtensionFilters().addAll(this.extensionFilters);
        chooser.setTitle("Open a " + this.name);
        File file = chooser.showOpenDialog(this.getScene().getWindow());
        if (file != null) {
            this.path.set((Object)file.toPath());
            this.lastKnownDirectoryProperty.setValue((Object)file.getParentFile());
            try {
                PrintWriter writer = new PrintWriter(this.defaultDirectoryFile);
                writer.print(file.getParentFile().getCanonicalPath());
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

