/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.transformations;

import java.util.LinkedHashMap;
import org.cte.ABCD.ABCDReplacer;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.ABCDWalker;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.types.MutexType;
import org.cte.ABCD.model.types.SemaphoreType;
import org.cte.ABCD.model.types.SpecialType;
import org.cte.ABCD.model.types.TimerType;

public class TInlinePrimitiveTypes {
    public void runOn(ABCDSystem s) {
        final LinkedHashMap primitiveTypes = new LinkedHashMap();
        final ABCDReplacer replacer = new ABCDReplacer();
        s.accept(new ABCDWalker(new ABCDVisitor.Stub(){
            private boolean isPrimitive = false;
            private SpecialType cannonicalType = null;

            @Override
            public void visitTypeDecl(TypeDecl toVisit) {
                this.isPrimitive = false;
                toVisit.getType().accept(this);
                if (this.isPrimitive) {
                    primitiveTypes.put(toVisit, this.cannonicalType);
                    replacer.addRemove(toVisit);
                }
            }

            @Override
            public void visitTimerType(TimerType toVisit) {
                this.isPrimitive = true;
                this.cannonicalType = toVisit;
            }

            @Override
            public void visitSemaphoreType(SemaphoreType toVisit) {
                this.isPrimitive = true;
                this.cannonicalType = toVisit;
            }

            @Override
            public void visitMutexType(MutexType toVisit) {
                this.isPrimitive = true;
                this.cannonicalType = toVisit;
            }

            @Override
            public void visitVariableDecl(VariableDecl toVisit) {
                SpecialType theSpecial = (SpecialType)primitiveTypes.get(toVisit.getType());
                if (theSpecial != null) {
                    toVisit.setType(theSpecial);
                }
            }
        }));
        s.accept(replacer);
    }
}

