/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.transformations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cte.ABCD.ABCDReplacer;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.builder.Builder;
import org.cte.ABCD.builder.ComplexBuilder;
import org.cte.ABCD.compiler.MutexChecker;
import org.cte.ABCD.compiler.PrimitiveUtils;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.kernel.TypedElement;
import org.cte.ABCD.model.statements.OutputStmt;
import org.cte.ABCD.model.statements.SpecialTypeStmt;
import org.cte.ABCD.model.types.MutexType;

public class TInlineMutex {
    private MutexChecker checker = new MutexChecker();
    private Builder builder;
    ComplexBuilder mutexBuilder;
    private Map<TypedElement, Port[]> mutexPortsMap = new LinkedHashMap<TypedElement, Port[]>();
    private Map<TypedElement, Map<ProcessInstance, List<ArgumentMap>>> mutexUsageMap = new LinkedHashMap<TypedElement, Map<ProcessInstance, List<ArgumentMap>>>();
    private Map<Integer, ProcessDecl> sizeMutexMap = new LinkedHashMap<Integer, ProcessDecl>();
    private ABCDSystem currentSystem;
    private ChannelTypeDecl mutexChannelType;

    public void runOn(ABCDSystem sys) throws Exception {
        this.currentSystem = sys;
        this.removeLocalMutexes();
        this.processUsagePattern();
        this.builder = new Builder(sys.getCoreTypesList());
        this.mutexBuilder = new ComplexBuilder(sys.getCoreTypesList());
        this.inlineMutexAttributes();
        this.computeUsageMap();
        this.inlineSharedMutexes();
    }

    private void inlineSharedMutexes() throws Exception {
        ABCDReplacer replacer = new ABCDReplacer();
        this.mutexChannelType = this.builder.syncChannelType("mutexNone", this.builder.noneType());
        this.currentSystem.addChannelTypes(this.mutexChannelType);
        for (TypedElement mutex : this.mutexUsageMap.keySet()) {
            int numberClients = this.computeClients(mutex);
            if (numberClients == 0) continue;
            replacer.addRemove(mutex);
            ProcessDecl mutexProcess = this.sizeMutexMap.get(numberClients);
            if (mutexProcess == null) {
                mutexProcess = this.mutexBuilder.mutex("mutex_" + numberClients, numberClients);
                this.sizeMutexMap.put(numberClients, mutexProcess);
            }
            ChannelDecl[] chans = this.createMutexChannels(mutex, numberClients);
            this.currentSystem.addAllChannels(Arrays.asList(chans));
            this.currentSystem.addCompositionAndOpposite(this.builder.instance(mutexProcess, chans, null, null));
            this.replaceMutexBindings(mutex, chans, replacer);
        }
        this.currentSystem.addAllProcesses(this.sizeMutexMap.values());
        this.currentSystem.accept(replacer);
    }

    private void replaceMutexBindings(TypedElement mutex, ChannelDecl[] chans, ABCDReplacer replacer) {
        Map<ProcessInstance, List<ArgumentMap>> oldBindings = this.mutexUsageMap.get(mutex);
        int useIdx = 0;
        for (ProcessInstance instance : oldBindings.keySet()) {
            for (ArgumentMap arg : oldBindings.get(instance)) {
                replacer.addRemove(arg);
                Port[] ports = this.mutexPortsMap.get(arg.getFormal());
                instance.addOutputs(this.builder.portMap(ports[0], chans[2 * useIdx]));
                instance.addOutputs(this.builder.portMap(ports[1], chans[2 * useIdx + 1]));
                ++useIdx;
            }
        }
    }

    private ChannelDecl[] createMutexChannels(TypedElement mutex, int numberPairs) {
        ChannelDecl[] channels = new ChannelDecl[numberPairs * 2];
        NamedDeclaration theMutex = mutex instanceof NamedDeclaration ? (NamedDeclaration)((Object)mutex) : null;
        for (int i = 0; i < numberPairs; ++i) {
            channels[2 * i] = this.builder.syncChannel(theMutex.getName() + "lock" + i, this.mutexChannelType);
            channels[2 * i + 1] = this.builder.syncChannel(theMutex.getName() + "unlock" + i, this.mutexChannelType);
        }
        return channels;
    }

    private int computeClients(TypedElement mutex) {
        Map<ProcessInstance, List<ArgumentMap>> instancesMap = this.mutexUsageMap.get(mutex);
        if (instancesMap == null) {
            return 0;
        }
        int sum = 0;
        for (List<ArgumentMap> args : instancesMap.values()) {
            for (ArgumentMap arg : args) {
                Port[] ports = this.mutexPortsMap.get(arg.getFormal());
                if (ports == null || ports[0] == null || ports[1] == null) continue;
                ++sum;
            }
        }
        return sum;
    }

    private void computeUsageMap() {
        List<VariableDecl> mutexes = this.sharedMutexes();
        for (VariableDecl mutex : mutexes) {
            this.mutexUsageMap.put(mutex, new LinkedHashMap());
        }
        for (ProcessInstance instance : this.currentSystem.getCompositionList()) {
            instance.accept(new ABCDVisitor.Stub(){
                ProcessInstance currentInstance;
                ArgumentMap currentArgMap;

                @Override
                public void visitProcessInstance(ProcessInstance i) {
                    this.currentInstance = i;
                    for (ArgumentMap args : i.getArgumentsList()) {
                        args.accept(this);
                    }
                }

                @Override
                public void visitArgumentMap(ArgumentMap arg) {
                    this.currentArgMap = arg;
                    arg.getActual().accept(this);
                }

                @Override
                public void visitReference(Reference ref) {
                    ref.getRef().accept(this);
                }

                @Override
                public void visitVariableDecl(VariableDecl var) {
                    if (var.getType() instanceof MutexType) {
                        Map mutexPerInstance = (Map)TInlineMutex.this.mutexUsageMap.get(var);
                        List args = (List)mutexPerInstance.get(this.currentInstance);
                        if (args == null) {
                            mutexPerInstance.put(this.currentInstance, Arrays.asList(this.currentArgMap));
                        } else {
                            args.add(this.currentArgMap);
                        }
                    }
                }
            });
        }
    }

    private List<VariableDecl> sharedMutexes() {
        ArrayList<VariableDecl> list = new ArrayList<VariableDecl>();
        for (VariableDecl var : this.currentSystem.getVariablesList()) {
            if (!(var.getType() instanceof MutexType)) continue;
            list.add(var);
        }
        return list;
    }

    private void inlineMutexAttributes() {
        for (ProcessDecl process : this.currentSystem.getProcessesList()) {
            int id = 1;
            for (TypedElement mutex : PrimitiveUtils.mutexList(process)) {
                this.mutexPortsMap.put(mutex, this.inlineMutexIn(mutex, id++, process));
            }
        }
    }

    private Port[] inlineMutexIn(TypedElement mutex, int id, ProcessDecl process) {
        ABCDReplacer repl = new ABCDReplacer();
        Port lockPort = this.builder.port("mlock" + id, this.builder.noneType(), false);
        List<SpecialTypeStmt> lockList = PrimitiveUtils.lockOnMutex(mutex, process);
        for (Statement statement : lockList) {
            OutputStmt lock = this.builder.output(lockPort);
            repl.addReplacement(statement, lock);
        }
        Port unlockPort = this.builder.port("munlock" + id, this.builder.noneType(), false);
        List<SpecialTypeStmt> list = PrimitiveUtils.unlockOnMutex(mutex, process);
        for (Statement statement : list) {
            OutputStmt lock = this.builder.output(unlockPort);
            repl.addReplacement(statement, lock);
        }
        repl.addRemove(mutex);
        process.accept(repl);
        process.addPortsAndOpposite(lockPort);
        process.addPortsAndOpposite(unlockPort);
        return new Port[]{lockPort, unlockPort};
    }

    private void processUsagePattern() throws Exception {
        ABCDReplacer replacer = new ABCDReplacer();
        for (ProcessDecl process : this.currentSystem.getProcessesList()) {
            for (ParameterDecl mutex : this.checker.mutexList(process)) {
                List<SpecialTypeStmt> lockList = PrimitiveUtils.lockOnMutex(mutex, process);
                List<SpecialTypeStmt> unlockList = PrimitiveUtils.unlockOnMutex(mutex, process);
                boolean nolock = lockList.isEmpty();
                boolean nounlock = unlockList.isEmpty();
                if (!nolock && nounlock) {
                    System.err.println("ERROR: Process " + process.getName() + " locks mutex '" + mutex.getName() + "' and does not unlock it");
                    throw new Exception();
                }
                if (nolock && !nounlock) {
                    System.out.println("WARNING: Process " + process.getName() + " tries to unlocks mutex '" + mutex.getName() + "' but it never locks it");
                    replacer.addRemove(mutex);
                    for (Statement statement : unlockList) {
                        replacer.addRemove(statement);
                    }
                }
                if (!nolock || !nounlock) continue;
                replacer.addRemove(mutex);
            }
        }
        this.currentSystem.accept(replacer);
    }

    private void removeLocalMutexes() {
        ABCDReplacer replacer = new ABCDReplacer();
        for (ProcessDecl process : this.currentSystem.getProcessesList()) {
            List<VariableDecl> localM = this.checker.localMutexList(process);
            for (VariableDecl mutex : localM) {
                replacer.addRemove(mutex);
                for (Statement statement : PrimitiveUtils.lockOnMutex(mutex, process)) {
                    replacer.addRemove(statement);
                }
                for (Statement statement : PrimitiveUtils.unlockOnMutex(mutex, process)) {
                    replacer.addRemove(statement);
                }
            }
        }
        this.currentSystem.accept(replacer);
    }
}

