/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.explorer;

import java.util.List;
import obp.dot.util.DotUtil;
import obp.explorer.ConfsFileHandler;
import obp.explorer.ExplorerResult;
import obp.explorer.NullExplorerResult;
import obp.ui.dot.diagram.GraphDiagram;
import obp.ui.explorer.ConfsFileHandlerController;
import obp.util.ResultInfoUtil;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.Resources;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.dialog.FieldDialog;
import org.xid.basics.ui.field.ChoiceField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.DiagramField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.TextField;

public class ExplorerResultListController
extends Controller<List<ExplorerResult>> {
    private final ErrorHandler errorHandler;
    private final ConfsFileHandlerController confFileHandlerController;
    private ChoiceField<ExplorerResult> resultChoiceField;
    private CompositeField compositeField;

    public ExplorerResultListController(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.confFileHandlerController = new ConfsFileHandlerController(errorHandler);
    }

    public CompositeField createFields() {
        this.resultChoiceField = new ChoiceField<ExplorerResult>("Context", 8194){

            public String getText(ExplorerResult element) {
                if (element.getContext() == null) {
                    return "no context";
                }
                return element.getContext().getName();
            }
        };
        Resources resources = Resources.getInstance(Resources.class);
        this.resultChoiceField.addAction((Action)new Action.Stub("", resources.getImage("eclipse/info_obj.gif")){

            public int getVisibility() {
                return ExplorerResultListController.this.resultChoiceField.getValue() == null ? 2 : 1;
            }

            public int run(ActionMonitor monitor) {
                ExplorerResult result = (ExplorerResult)ExplorerResultListController.this.resultChoiceField.getValue();
                TextField infoField = new TextField(null, 3);
                infoField.setNbLines(10);
                infoField.setValue(result.toString());
                FieldDialog dialog = new FieldDialog("OBP", "Explorer result", 1, (Field)infoField);
                dialog.setButtonLabel(new String[]{"Ok"});
                dialog.open();
                return 1;
            }
        });
        this.resultChoiceField.addAction((Action)new Action.Stub("", resources.getImage("eclipse/tree_mode.gif")){

            public int getVisibility() {
                return ExplorerResultListController.this.getSubject() == null || ((List)ExplorerResultListController.this.getSubject()).size() <= 1 ? 2 : 1;
            }

            public int run(ActionMonitor monitor) {
                try {
                    DiagramField diagramField = new DiagramField((Diagram)new GraphDiagram());
                    diagramField.addAction(diagramField.getController().createIncreaseZoomAction());
                    diagramField.addAction(diagramField.getController().createDecreaseZoomAction());
                    diagramField.setValue((Object)DotUtil.layoutDot(ResultInfoUtil.toDotSplitGraph((List)ExplorerResultListController.this.getSubject())));
                    FieldDialog dialog = new FieldDialog("OBP", "Context split tree", 1, (Field)diagramField);
                    dialog.setButtonLabel(new String[]{"Ok"});
                    dialog.open();
                    return 1;
                }
                catch (Exception e) {
                    ExplorerResultListController.this.getErrorHandler().handleError(2, DiagnosticUtil.createMessage((Throwable)e));
                    return 3;
                }
            }
        });
        Resources.releaseInstance(Resources.class);
        CompositeField confsFileHandlerField = this.confFileHandlerController.createFields();
        this.compositeField = new CompositeField("Configurations", 0, new Field[]{this.resultChoiceField, confsFileHandlerField});
        return this.compositeField;
    }

    public void refreshFields() {
        if (this.getSubject() == null) {
            this.confFileHandlerController.setSubject(null);
            this.compositeField.setEnable(false);
        } else {
            this.resultChoiceField.setRange((List)this.getSubject());
            if (!((List)this.getSubject()).contains(this.resultChoiceField.getValue())) {
                this.resultChoiceField.setValue(null);
            }
            if (this.resultChoiceField.getValue() == null && ((List)this.getSubject()).size() > 0) {
                this.resultChoiceField.setValue(((List)this.getSubject()).get(0));
            }
            this.refreshConfFileHandler();
            this.compositeField.setEnable(true);
        }
    }

    private void refreshConfFileHandler() {
        ExplorerResult controllerExplorerResult;
        ExplorerResult selected = (ExplorerResult)this.resultChoiceField.getValue();
        selected = selected instanceof NullExplorerResult ? null : selected;
        ExplorerResult explorerResult = controllerExplorerResult = this.confFileHandlerController.getSubject() == null ? null : ((ConfsFileHandler)this.confFileHandlerController.getSubject()).getExplorerResult();
        if (selected != controllerExplorerResult) {
            if (this.confFileHandlerController.getSubject() != null) {
                ((ConfsFileHandler)this.confFileHandlerController.getSubject()).close();
            }
            try {
                this.confFileHandlerController.setSubject(selected == null ? null : new ConfsFileHandler(selected));
            }
            catch (Exception e) {
                this.errorHandler.handleError(2, DiagnosticUtil.createMessage((Throwable)e) + "\n");
            }
            this.confFileHandlerController.refreshFields();
        }
    }

    public boolean updateSubject(Field field) {
        if (this.resultChoiceField == field) {
            this.refreshFields();
            return false;
        }
        return this.confFileHandlerController.updateSubject(field);
    }

    public void close() {
        if (this.confFileHandlerController.getSubject() != null) {
            ((ConfsFileHandler)this.confFileHandlerController.getSubject()).close();
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

