/*
 * Decompiled with CFR 0.152.
 */
package obp.transfo.property;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import obp.cdl.EventDeclaration;
import obp.cdl.EventReference;
import obp.cdl.PropertyDeclaration;
import obp.event.GammaEvent;
import obp.obs.Observer;
import obp.obs.Reset;
import obp.obs.State;
import obp.obs.Transition;
import obp.obs.Type;
import obp.obs.When;
import obp.predicate.ComparisonOperator;
import obp.property.Arity;
import obp.property.Immediacy;
import obp.property.Nullity;
import obp.property.NullityExpression;
import obp.property.Occurrence;
import obp.property.OccurrenceEvent;
import obp.property.OccurrenceExpression;
import obp.property.Precedency;
import obp.property.PrecedencyExpression;
import obp.property.Property;
import obp.property.PropertyAbsence;
import obp.property.PropertyExistence;
import obp.property.PropertyObserver;
import obp.property.PropertyResponse;
import obp.property.TempGuard;
import obp.property.TimeConstrain;
import obp.util.ObsUtil;
import obp.util.PropertyUtil;

public class PropertyToObserver {
    private static final String clockName = "c";
    private static final Reset clockReset = ObsUtil.createReset("c", -1);
    private final PrintWriter out;
    private Observer observer;
    private State stateInit = null;
    private State stateReject = null;
    private State stateSuccess = null;
    private State stateInter = null;
    private boolean lazy = true;
    private TempGuard delayExpress;

    public PropertyToObserver(PrintWriter out) {
        this.out = out == null ? new PrintWriter(System.out) : out;
    }

    public Observer toObserver(PropertyDeclaration declaration) {
        Property property = declaration.getIs();
        if (property instanceof PropertyObserver) {
            Observer handwrittenObserver = ((PropertyObserver)property).getObserver();
            handwrittenObserver.setName(declaration.getName());
            handwrittenObserver.setScope(property.getScope());
            return handwrittenObserver;
        }
        this.observer = new Observer();
        this.observer.setName(declaration.getName());
        this.observer.setScope(property.getScope());
        this.createStates(property);
        switch (this.propertyType(property)) {
            case 1: {
                this.observer = this.toObserverAbsence(property);
                break;
            }
            case 2: {
                this.observer = this.toObserverExistence(property);
                break;
            }
            case 3: {
                this.observer = this.toObserverResponse(property);
                break;
            }
            default: {
                this.out.println("[PropertyToObserver]:Type error ! ");
                return null;
            }
        }
        if (this.delayExpress != null) {
            this.observer.setClock(clockName);
        }
        return this.observer;
    }

    private Observer toObserverAbsence(Property property) {
        PropertyAbsence absenceProp = (PropertyAbsence)property;
        switch (absenceProp.getOccurrenceExpression().getOccurrence()) {
            case An: {
                return this.toObserverAbsenceAn(absenceProp);
            }
            case AllOrdered: {
                return this.toObserverAbsenceAllOrdered(absenceProp);
            }
            case AllCombined: {
                return this.toObserverAbsenceAllCombined(absenceProp);
            }
        }
        return null;
    }

    private Observer toObserverAbsenceAn(PropertyAbsence absenceProp) {
        if (this.delayExpress != null) {
            this.creerTransEnsAn_WithDelay(this.stateInit, this.stateReject, absenceProp.getOccurrenceExpression());
        } else {
            this.creerTransEnsAn(this.stateInit, this.stateReject, absenceProp.getOccurrenceExpression());
        }
        return this.observer;
    }

    private Observer toObserverAbsenceAllOrdered(PropertyAbsence absenceProp) {
        if (this.delayExpress != null) {
            this.creerTransEnsAllOrder_WithDelay(this.stateInit, this.stateReject, this.stateInit, absenceProp.getOccurrenceExpression());
        } else {
            this.creerTransEnsAllOrder(this.stateInit, this.stateReject, this.stateInit, absenceProp.getOccurrenceExpression());
        }
        return this.observer;
    }

    private Observer toObserverAbsenceAllCombined(PropertyAbsence absenceProp) {
        if (this.delayExpress != null) {
            this.creerTransEnsAllCombined_WithDelay(this.stateInit, this.stateReject, this.stateInit, absenceProp.getOccurrenceExpression());
        } else {
            this.creerTransEnsAllCombined(this.stateInit, this.stateReject, this.stateInit, absenceProp.getOccurrenceExpression());
        }
        return this.observer;
    }

    private Observer toObserverExistence(Property property) {
        PropertyExistence existenceProp = (PropertyExistence)property;
        this.delayExpress = existenceProp.getTempGuard();
        switch (existenceProp.getOccurrenceExpression().getOccurrence()) {
            case An: {
                return this.toObserverExistenceAn(existenceProp);
            }
            case AllOrdered: {
                return this.toObserverExistenceAllOrdered(existenceProp);
            }
            case AllCombined: {
                return this.toObserverExistenceAllCombined(existenceProp);
            }
        }
        return null;
    }

    private Observer toObserverExistenceAn(PropertyExistence existenceProp) {
        this.addOneTransitionWithReset(this.stateInit, this.stateInter, clockReset);
        if (this.delayExpress != null) {
            this.creerTransEnsAn_WithDelay(this.stateInter, this.stateSuccess, existenceProp.getOccurrenceExpression());
        } else {
            this.creerTransEnsAn(this.stateInter, this.stateSuccess, existenceProp.getOccurrenceExpression());
            this.observer.removeState(this.stateReject);
        }
        return this.observer;
    }

    private Observer toObserverExistenceAllOrdered(PropertyExistence existenceProp) {
        if (this.delayExpress != null) {
            this.addOneTransitionWithReset(this.stateInit, this.stateInter, clockReset);
            this.creerTransEnsAllOrder_WithDelay(this.stateInter, this.stateSuccess, this.stateInter, existenceProp.getOccurrenceExpression());
        } else {
            this.creerTransEnsAllOrder(this.stateInit, this.stateSuccess, this.stateInit, existenceProp.getOccurrenceExpression());
            this.observer.removeState(this.stateReject);
            this.observer.removeState(this.stateInter);
        }
        return this.observer;
    }

    private Observer toObserverExistenceAllCombined(PropertyExistence existenceProp) {
        this.addOneTransitionWithReset(this.stateInit, this.stateInter, clockReset);
        if (this.delayExpress != null) {
            this.creerTransEnsAllCombined_WithDelay(this.stateInter, this.stateSuccess, this.stateInter, existenceProp.getOccurrenceExpression());
        } else {
            this.creerTransEnsAllCombined(this.stateInter, this.stateSuccess, this.stateInter, existenceProp.getOccurrenceExpression());
            this.observer.removeState(this.stateReject);
        }
        return this.observer;
    }

    private Observer toObserverResponse(Property property) {
        PropertyResponse responseProp = (PropertyResponse)property;
        this.delayExpress = responseProp.getTemporalOperator().getTempGuard();
        Occurrence preOccurrence = responseProp.getPreExpression().getOccurrence();
        Occurrence postOccurrence = responseProp.getPostExpression().getOccurrence();
        switch (preOccurrence) {
            case An: {
                switch (postOccurrence) {
                    case An: {
                        return this.toObserverResponseAnAn(responseProp);
                    }
                    case AllCombined: {
                        return this.toObserverResponseAnAllCombined(responseProp);
                    }
                    case AllOrdered: {
                        return this.toObserverResponseAnAllOrdered(responseProp);
                    }
                }
            }
            case AllCombined: {
                switch (postOccurrence) {
                    case An: {
                        return this.toObserverResponseAllCombinedAn(responseProp);
                    }
                    case AllCombined: {
                        return this.toObserverResponseAllCombinedAllCombined(responseProp);
                    }
                    case AllOrdered: {
                        return this.toObserverResponseAllCombinedAllOrdered(responseProp);
                    }
                }
            }
            case AllOrdered: {
                switch (postOccurrence) {
                    case An: {
                        return this.toObserverResponseAllOrderedAn(responseProp);
                    }
                    case AllCombined: {
                        return this.toObserverResponseAllOrderedAllCombined(responseProp);
                    }
                    case AllOrdered: {
                        return this.toObserverResponseAllOrderedAllOrdered(responseProp);
                    }
                }
            }
        }
        return null;
    }

    private Observer toObserverResponseAnAn(PropertyResponse responseProp) {
        this.creerTransEnsAn(this.stateInit, this.stateInter, responseProp.getPreExpression());
        if (responseProp.isRepeatability()) {
            this.creerTransEnsAn(this.stateInter, this.stateInit, responseProp.getPostExpression());
        } else {
            this.creerTransEnsAn_WithGuardAndReset(this.stateInter, this.stateSuccess, responseProp.getPostExpression());
        }
        this.addOneTransitionWithGuardAndReset(this.stateInter, this.stateReject, PropertyToObserver.createUpperWhen(this.delayExpress), clockReset);
        this.creerTransImmediacyImmediately(responseProp);
        this.creerTransNullityMayNever(responseProp);
        this.creerTransPrecedencyMayAn(responseProp);
        return this.observer;
    }

    private Observer toObserverResponseAllOrderedAn(PropertyResponse responseProp) {
        this.creerTransEnsAllOrder(this.stateInit, this.stateInter, this.stateInit, responseProp.getPreExpression());
        if (responseProp.isRepeatability()) {
            this.creerTransEnsAn(this.stateInter, this.stateInit, responseProp.getPostExpression());
        } else {
            this.creerTransEnsAn_WithGuardAndReset(this.stateInter, this.stateSuccess, responseProp.getPostExpression());
        }
        this.addOneTransitionWithGuardAndReset(this.stateInter, this.stateReject, PropertyToObserver.createUpperWhen(this.delayExpress), clockReset);
        this.creerTransImmediacyImmediately(responseProp);
        this.creerTransPrecedencyMayAllOrdered(responseProp, "S_");
        this.creerTransNullityMayNever(responseProp);
        return this.observer;
    }

    private Observer toObserverResponseAllCombinedAn(PropertyResponse responseProp) {
        this.creerTransEnsAllCombined(this.stateInit, this.stateInter, this.stateInit, responseProp.getPreExpression());
        if (responseProp.isRepeatability()) {
            this.creerTransEnsAn(this.stateInter, this.stateInit, responseProp.getPostExpression());
        } else {
            this.creerTransEnsAn_WithGuardAndReset(this.stateInter, this.stateSuccess, responseProp.getPostExpression());
        }
        this.addOneTransitionWithGuardAndReset(this.stateInter, this.stateReject, PropertyToObserver.createUpperWhen(this.delayExpress), clockReset);
        this.creerTransImmediacyImmediately(responseProp);
        this.creerTransPrecedencyMayAllCombined(responseProp);
        this.creerTransNullityMayNever(responseProp);
        return this.observer;
    }

    private Observer toObserverResponseAnAllOrdered(PropertyResponse responseProp) {
        this.creerTransEnsAn(this.stateInit, this.stateInter, responseProp.getPreExpression());
        if (responseProp.isRepeatability()) {
            this.creerTransEnsAllOrder_WithDelay(this.stateInter, this.stateInit, this.stateInter, responseProp.getPostExpression());
        } else {
            this.creerTransEnsAllOrder_WithDelay(this.stateInter, this.stateSuccess, this.stateInter, responseProp.getPostExpression());
        }
        this.creerTransImmediacyImmediately(responseProp);
        this.creerTransPrecedencyMayAn(responseProp);
        this.creerTransNullityMayNever(responseProp);
        return this.observer;
    }

    private Observer toObserverResponseAnAllCombined(PropertyResponse responseProp) {
        this.creerTransEnsAn(this.stateInit, this.stateInter, responseProp.getPreExpression());
        if (responseProp.isRepeatability()) {
            this.creerTransEnsAllCombined_WithDelay(this.stateInter, this.stateInit, this.stateInter, responseProp.getPostExpression());
        } else {
            this.creerTransEnsAllCombined_WithDelay(this.stateInter, this.stateSuccess, this.stateInter, responseProp.getPostExpression());
        }
        this.creerTransImmediacyImmediately(responseProp);
        this.creerTransPrecedencyMayAn(responseProp);
        this.creerTransNullityMayNever(responseProp);
        return this.observer;
    }

    private Observer toObserverResponseAllOrderedAllCombined(PropertyResponse responseProp) {
        this.creerTransEnsAllOrder(this.stateInit, this.stateInter, this.stateInit, responseProp.getPreExpression());
        if (responseProp.isRepeatability()) {
            this.creerTransEnsAllCombined_WithDelay(this.stateInter, this.stateInit, this.stateInter, responseProp.getPostExpression());
        } else {
            this.creerTransEnsAllCombined_WithDelay(this.stateInter, this.stateSuccess, this.stateInter, responseProp.getPostExpression());
        }
        this.creerTransImmediacyImmediately(responseProp);
        this.creerTransPrecedencyMayAllOrdered(responseProp, "S_");
        this.creerTransNullityMayNever(responseProp);
        return this.observer;
    }

    private Observer toObserverResponseAllOrderedAllOrdered(PropertyResponse responseProp) {
        this.creerTransEnsAllOrder(this.stateInit, this.stateInter, this.stateInit, responseProp.getPreExpression());
        if (responseProp.isRepeatability()) {
            this.creerTransEnsAllOrder_WithDelay(this.stateInter, this.stateInit, this.stateInter, responseProp.getPostExpression());
        } else {
            this.creerTransEnsAllOrder_WithDelay(this.stateInter, this.stateSuccess, this.stateInter, responseProp.getPostExpression());
        }
        this.creerTransImmediacyImmediately(responseProp);
        this.creerTransPrecedencyMayAllOrdered(responseProp, "S_");
        this.creerTransNullityMayNever(responseProp);
        return this.observer;
    }

    private Observer toObserverResponseAllCombinedAllOrdered(PropertyResponse responseProp) {
        this.creerTransEnsAllCombined(this.stateInit, this.stateInter, this.stateInit, responseProp.getPreExpression());
        if (responseProp.isRepeatability()) {
            this.creerTransEnsAllOrder_WithDelay(this.stateInter, this.stateInit, this.stateInter, responseProp.getPostExpression());
        } else {
            this.creerTransEnsAllOrder_WithDelay(this.stateInter, this.stateSuccess, this.stateInter, responseProp.getPostExpression());
        }
        this.creerTransImmediacyImmediately(responseProp);
        this.creerTransPrecedencyMayAllCombined(responseProp);
        this.creerTransNullityMayNever(responseProp);
        return this.observer;
    }

    private Observer toObserverResponseAllCombinedAllCombined(PropertyResponse responseProp) {
        this.creerTransEnsAllCombined(this.stateInit, this.stateInter, this.stateInit, responseProp.getPreExpression());
        if (responseProp.isRepeatability()) {
            this.creerTransEnsAllCombined_WithDelay(this.stateInter, this.stateInit, this.stateInter, responseProp.getPostExpression());
        } else {
            this.creerTransEnsAllCombined_WithDelay(this.stateInter, this.stateSuccess, this.stateInter, responseProp.getPostExpression());
        }
        this.creerTransImmediacyImmediately(responseProp);
        this.creerTransPrecedencyMayAllCombined(responseProp);
        this.creerTransNullityMayNever(responseProp);
        return this.observer;
    }

    private static boolean isPropertyResponseContainPrecedencyMay(PropertyResponse property) {
        for (PrecedencyExpression precedencyExpress : property.getPrecedencyExpressionList()) {
            if (precedencyExpress.getPrecedency() != Precedency.May) continue;
            return true;
        }
        return false;
    }

    private boolean existsInObserver(Transition toAdd) {
        for (Transition existing : this.observer.getTransitionList()) {
            if (!PropertyToObserver.transitionsEquality(existing, toAdd)) continue;
            return true;
        }
        return false;
    }

    private static boolean transitionsEquality(Transition left, Transition right) {
        return PropertyUtil.print(left).equals(PropertyUtil.print(right));
    }

    private int getPosCondOccurListList(List<OccurrenceEvent> occurList, EventReference eventRef) {
        int pos = -1;
        for (OccurrenceEvent occurEvent : occurList) {
            ++pos;
            if (!occurEvent.getEvent().getName().equals(eventRef.getName())) continue;
            return pos;
        }
        return -1;
    }

    private State getStateInAllOrderedList(int pos, String prefix, int nbStatesPredefined) {
        if (pos == 0) {
            return this.stateInit;
        }
        String stateByName = prefix + (nbStatesPredefined + pos);
        for (State state : this.observer.getStateList()) {
            if (!state.getName().equals(stateByName)) continue;
            return state;
        }
        return null;
    }

    private int propertyType(Property property) {
        if (property instanceof PropertyAbsence) {
            return 1;
        }
        if (property instanceof PropertyExistence) {
            return 2;
        }
        if (property instanceof PropertyResponse) {
            return 3;
        }
        return 0;
    }

    private void createStates(Property property) {
        this.stateInit = ObsUtil.createState("Init", Type.Normal);
        this.observer.setStartState(this.stateInit);
        this.observer.addState(this.stateInit);
        this.stateReject = ObsUtil.createState("Reject", Type.Reject);
        this.observer.addState(this.stateReject);
        if (this.propertyType(property) == 2) {
            this.stateInter = ObsUtil.createState("Inter", Type.Normal);
            this.observer.addState(this.stateInter);
            this.stateSuccess = ObsUtil.createState("Success", Type.Success);
            this.observer.addState(this.stateSuccess);
            return;
        }
        if (this.propertyType(property) == 3) {
            this.stateInter = ObsUtil.createState("Inter", Type.Normal);
            this.observer.addState(this.stateInter);
            if (!((PropertyResponse)property).isRepeatability() || PropertyToObserver.isPropertyResponseContainPrecedencyMay((PropertyResponse)property)) {
                this.stateSuccess = ObsUtil.createState("Success", Type.Success);
                this.observer.addState(this.stateSuccess);
            }
        }
    }

    private void creerTransPrecedencyMayAn(PropertyResponse responseProp) {
        for (PrecedencyExpression precedencyExpres : responseProp.getPrecedencyExpressionList()) {
            if (precedencyExpres.getPrecedency() != Precedency.May) continue;
            for (EventReference eventRef : precedencyExpres.getPreEventList()) {
                this.addOneTransitionEventWithGuardAndReset(this.stateInit, this.stateSuccess, eventRef, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
            }
        }
    }

    private void creerTransPrecedencyMayAllOrdered(PropertyResponse responseProp, String prefixAllOrdered) {
        for (PrecedencyExpression precedencyExpres : responseProp.getPrecedencyExpressionList()) {
            if (precedencyExpres.getPrecedency() != Precedency.May) continue;
            for (EventReference eventRefPre : precedencyExpres.getPreEventList()) {
                for (EventReference eventRefPost : precedencyExpres.getPostEventList()) {
                    int pos = this.getPosCondOccurListList(responseProp.getPreExpression().getOccurrenceEventList(), eventRefPost);
                    this.out.println("[Response ALL ORDERED - AN][Precedency MAY][POST]" + pos);
                    this.addOneTransitionEventWithGuardAndReset(this.getStateInAllOrderedList(pos, prefixAllOrdered, 3), this.stateSuccess, eventRefPre, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
                }
            }
        }
    }

    private void creerTransPrecedencyMayAllCombined(PropertyResponse responseProp) {
        for (PrecedencyExpression precedencyExpres : responseProp.getPrecedencyExpressionList()) {
            if (precedencyExpres.getPrecedency() != Precedency.May) continue;
            for (EventReference eventRefPre : precedencyExpres.getPreEventList()) {
                for (EventReference eventRefPost : precedencyExpres.getPostEventList()) {
                    ArrayList<Transition> obsTransList = new ArrayList<Transition>(this.observer.getTransitionList());
                    for (Transition transition : obsTransList) {
                        if (transition.getEvents(0) == null || transition.getSource() == transition.getTarget() || !transition.getEvents(0).getName().equals(eventRefPost.getName())) continue;
                        this.addOneTransitionEventWithGuardAndReset(transition.getSource(), this.stateSuccess, eventRefPre, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
                    }
                }
            }
        }
    }

    private void creerTransNullityMayNever(PropertyResponse responseProp) {
        for (NullityExpression nullityExpres : responseProp.getNullityExpressionList()) {
            if (nullityExpres.getNullity() != Nullity.MayNever) continue;
            this.addOneTransitionEventWithGuardAndReset(this.stateInit, this.stateReject, nullityExpres.getEvent(), PropertyToObserver.createUpperWhen(this.delayExpress), clockReset);
        }
    }

    private void creerTransImmediacyImmediately(PropertyResponse responseProp) {
        if (responseProp.getTemporalOperator().getImmediacy() == Immediacy.Immediately) {
            this.addOneTransitionGamma(this.stateInter, this.stateReject);
        }
    }

    private void creerTransEnsAn_WithGuardAndReset(State stSource, State stTarget, OccurrenceExpression occurrenceList) {
        for (OccurrenceEvent occurEvent : occurrenceList.getOccurrenceEventList()) {
            this.addOneTransitionEventWithGuardAndReset(this.stateInter, this.stateSuccess, occurEvent, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
            if (occurEvent.getArity() != Arity.OneOrMore) continue;
            this.addOneTransitionEventWithGuardAndReset(this.stateSuccess, this.stateSuccess, occurEvent, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
        }
    }

    private void creerTransEnsAn(State stSource, State stTarget, OccurrenceExpression occurrenceList) {
        for (OccurrenceEvent occurEvent : occurrenceList.getOccurrenceEventList()) {
            this.addOneTransitionEvent(stSource, stTarget, occurEvent);
            if (occurEvent.getArity() != Arity.OneOrMore) continue;
            this.addOneTransitionEvent(stTarget, stTarget, occurEvent);
        }
    }

    private void creerTransEnsAn_WithDelay(State stSource, State stTarget, OccurrenceExpression occurrenceList) {
        for (OccurrenceEvent occurEvent : occurrenceList.getOccurrenceEventList()) {
            this.addOneTransitionEventWithGuardAndReset(stSource, stTarget, occurEvent, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
            if (occurEvent.getArity() != Arity.OneOrMore) continue;
            this.addOneTransitionEventWithGuardAndReset(stTarget, stTarget, occurEvent, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
        }
        this.addOneTransitionWithGuardAndReset(stSource, this.stateReject, PropertyToObserver.createUpperWhen(this.delayExpress), clockReset);
    }

    private final void creerTransEnsAllOrder(State stSource, State stTarget, State stGamma, OccurrenceExpression occurrenceList) {
        int indexOccurEvent = 0;
        State preState = new State();
        preState = stSource;
        State nextState = null;
        for (OccurrenceEvent occurEvent : occurrenceList.getOccurrenceEventList()) {
            if (++indexOccurEvent == occurrenceList.getOccurrenceEventCount()) {
                this.addOneTransitionEvent(preState, stTarget, occurEvent);
                if (!this.lazy) {
                    this.addOneTransitionGamma(preState, stGamma);
                }
                if (occurEvent.getArity() == Arity.OneOrMore) {
                    this.addOneTransitionCircular(stTarget, occurEvent);
                }
            } else {
                nextState = ObsUtil.createState("S_" + this.observer.getStateCount(), Type.Normal);
                this.observer.addState(nextState);
                this.addOneTransitionEvent(preState, nextState, occurEvent);
                if (!this.lazy) {
                    this.addOneTransitionGamma(preState, stGamma);
                }
                if (occurEvent.getArity() == Arity.OneOrMore) {
                    this.addOneTransitionCircular(nextState, occurEvent);
                }
            }
            preState = nextState;
        }
    }

    private final void creerTransEnsAllOrder_WithDelay(State stSource, State stTarget, State stGamma, OccurrenceExpression occurrenceList) {
        State preState = stSource;
        State nextState = null;
        int indexOccurEvent = 0;
        for (OccurrenceEvent occurEvent : occurrenceList.getOccurrenceEventList()) {
            if (++indexOccurEvent == occurrenceList.getOccurrenceEventCount()) {
                this.addOneTransitionEventWithGuardAndReset(preState, stTarget, occurEvent, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
                if (occurEvent.getArity() == Arity.OneOrMore) {
                    this.addOneTransitionEventWithGuardAndReset(stTarget, stTarget, occurEvent, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
                }
                if (!this.lazy) {
                    this.addOneTransitionGamma(preState, stSource);
                }
                this.addOneTransitionWithGuardAndReset(preState, this.stateReject, PropertyToObserver.createUpperWhen(this.delayExpress), clockReset);
            } else {
                nextState = ObsUtil.createState("S_" + this.observer.getStateCount(), Type.Normal);
                this.observer.addState(nextState);
                this.addOneTransitionEvent(preState, nextState, occurEvent);
                if (!this.lazy) {
                    this.addOneTransitionGamma(preState, stGamma);
                }
                this.addOneTransitionWithGuardAndReset(preState, this.stateReject, PropertyToObserver.createUpperWhen(this.delayExpress), clockReset);
                if (occurEvent.getArity() == Arity.OneOrMore) {
                    this.addOneTransitionCircular(nextState, occurEvent);
                }
            }
            preState = nextState;
        }
    }

    private final void creerTransEnsAllCombined(State stSource, State stTarget, State stGamma, OccurrenceExpression occurrenceList) {
        List<OccurrenceEvent> vect_evt = occurrenceList.getOccurrenceEventList();
        if (vect_evt.size() == 1) {
            OccurrenceEvent event = vect_evt.get(0);
            this.addOneTransitionEvent(stSource, stTarget, event);
            if (event.getArity() == Arity.OneOrMore) {
                this.addOneTransitionEvent(stTarget, stTarget, event);
            }
        } else {
            this.create_states_and_transitions_combined_recursive(stSource, stTarget, stGamma, vect_evt);
        }
    }

    private void create_states_and_transitions_combined_recursive(State stSource, State stTarget, State stGamma, List<OccurrenceEvent> event_vector) {
        if (event_vector.size() == 0) {
            return;
        }
        if (event_vector.size() == 1) {
            OccurrenceEvent ei = event_vector.get(0);
            this.addOneTransitionEvent(stSource, stTarget, ei);
            if (!this.lazy) {
                this.addOneTransitionGamma(stSource, stGamma);
            }
            if (ei.getArity() == Arity.OneOrMore) {
                this.addOneTransitionEvent(stTarget, stTarget, ei);
            }
            return;
        }
        if (!this.lazy) {
            this.addOneTransitionGamma(stSource, stGamma);
        }
        for (int i = 0; i < event_vector.size(); ++i) {
            OccurrenceEvent ei = event_vector.get(i);
            ArrayList<OccurrenceEvent> vector_tmp = new ArrayList<OccurrenceEvent>();
            vector_tmp.addAll(event_vector);
            vector_tmp.remove(ei);
            int no_state = this.observer.getStateCount();
            State sti = ObsUtil.createState("State_" + no_state, Type.Normal);
            this.observer.addState(sti);
            this.addOneTransitionEvent(stSource, sti, ei);
            if (ei.getArity() == Arity.OneOrMore) {
                this.addOneTransitionCircular(sti, ei);
            }
            this.create_states_and_transitions_combined_recursive(sti, stTarget, stGamma, vector_tmp);
        }
    }

    private void creerTransEnsAllCombined_WithDelay(State stSource, State stTarget, State stGamma, OccurrenceExpression occurrenceList) {
        List<OccurrenceEvent> vect_evt = occurrenceList.getOccurrenceEventList();
        this.addOneTransitionWithGuardAndReset(stSource, this.stateReject, PropertyToObserver.createUpperWhen(this.delayExpress), clockReset);
        if (vect_evt.size() == 1) {
            OccurrenceEvent event = vect_evt.get(0);
            this.addOneTransitionEventWithGuardAndReset(stSource, stTarget, event, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
            if (event.getArity() == Arity.OneOrMore) {
                this.addOneTransitionEventWithGuardAndReset(stTarget, stTarget, event, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
            }
            return;
        }
        this.create_states_and_transitions_combined_recursive_WithDelay(stSource, stTarget, stGamma, vect_evt);
    }

    private void create_states_and_transitions_combined_recursive_WithDelay(State stSource, State stTarget, State stGamma, List<OccurrenceEvent> event_vector) {
        if (event_vector.isEmpty()) {
            return;
        }
        if (event_vector.size() == 1) {
            OccurrenceEvent ei = event_vector.get(0);
            this.addOneTransitionEventWithGuardAndReset(stSource, stTarget, ei, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
            if (!this.lazy) {
                this.addOneTransitionGamma(stSource, stGamma);
            }
            if (ei.getArity() == Arity.OneOrMore) {
                this.addOneTransitionEventWithGuardAndReset(stTarget, stTarget, ei, PropertyToObserver.createLowerWhen(this.delayExpress), clockReset);
            }
            return;
        }
        if (!this.lazy) {
            this.addOneTransitionGamma(stSource, stGamma);
        }
        for (int i = 0; i < event_vector.size(); ++i) {
            OccurrenceEvent ei = event_vector.get(i);
            ArrayList<OccurrenceEvent> vector_tmp = new ArrayList<OccurrenceEvent>();
            vector_tmp.addAll(event_vector);
            vector_tmp.remove(ei);
            int no_state = this.observer.getStateCount();
            State sti = ObsUtil.createState("State_" + no_state, Type.Normal);
            this.observer.addState(sti);
            this.addOneTransitionEvent(stSource, sti, ei);
            this.addOneTransitionWithGuardAndReset(sti, this.stateReject, PropertyToObserver.createUpperWhen(this.delayExpress), clockReset);
            if (ei.getArity() == Arity.OneOrMore) {
                this.addOneTransitionCircular(sti, ei);
            }
            this.create_states_and_transitions_combined_recursive_WithDelay(sti, stTarget, stGamma, vector_tmp);
        }
    }

    private void addOneTransitionEvent(State stSource, State stTarget, OccurrenceEvent occurEvent) {
        Transition transition = ObsUtil.createTransition(stSource, stTarget, null, occurEvent.getEvent(), null);
        if (!this.existsInObserver(transition)) {
            this.observer.addTransition(transition);
        }
    }

    private void addOneTransitionWithGuardAndReset(State stSource, State stTarget, When when, Reset reset) {
        Transition transition = ObsUtil.createTransition(stSource, stTarget, when, null, reset);
        if (!this.existsInObserver(transition)) {
            this.observer.addTransition(transition);
        }
    }

    private void addOneTransitionWithReset(State stSource, State stTarget, Reset reset) {
        Transition transition = ObsUtil.createTransition(stSource, stTarget, null, null, reset);
        if (!this.existsInObserver(transition)) {
            this.observer.addTransition(transition);
        }
    }

    private void addOneTransitionEventWithGuardAndReset(State stSource, State stTarget, OccurrenceEvent occurEvent, When when, Reset reset) {
        Transition transition = ObsUtil.createTransition(stSource, stTarget, when, occurEvent.getEvent(), reset);
        if (!this.existsInObserver(transition)) {
            this.observer.addTransition(transition);
        }
    }

    private void addOneTransitionEventWithGuardAndReset(State stSource, State stTarget, EventReference eventRef, When when, Reset reset) {
        OccurrenceEvent occurEvent = new OccurrenceEvent();
        occurEvent.setEvent(eventRef);
        occurEvent.setArity(Arity.ExactlyOne);
        Transition transition = ObsUtil.createTransition(stSource, stTarget, when, occurEvent.getEvent(), reset);
        if (!this.existsInObserver(transition)) {
            this.observer.addTransition(transition);
        }
    }

    private void addOneTransitionCircular(State state, OccurrenceEvent event) {
        if (state == this.stateSuccess) {
            return;
        }
        if (state == this.stateInit) {
            return;
        }
        Transition transition = ObsUtil.createTransition(state, state, null, event.getEvent(), null);
        if (!this.existsInObserver(transition)) {
            this.observer.addTransition(transition);
        }
    }

    private void addOneTransitionGamma(State stSource, State stTarget) {
        if (stSource == stTarget) {
            return;
        }
        GammaEvent gammaEvent = new GammaEvent();
        EventDeclaration gammaDeclaration = new EventDeclaration();
        gammaDeclaration.setName("gamma");
        gammaDeclaration.setIs(gammaEvent);
        EventReference gammaEventReference = new EventReference();
        gammaEventReference.setName("gamma");
        gammaEventReference.setReference(gammaDeclaration);
        Transition transition = ObsUtil.createTransition(stSource, stTarget, null, gammaEventReference, null);
        if (!this.existsInObserver(transition)) {
            this.observer.addTransition(transition);
        }
    }

    private static When createLowerWhen(TempGuard tempGuard) {
        TimeConstrain min = tempGuard.getMin();
        ComparisonOperator type = min.isStrict() ? ComparisonOperator.GREATER : ComparisonOperator.GREATER_OR_EQUAL;
        return ObsUtil.createWhen(clockName, type, min.getValue());
    }

    private static When createUpperWhen(TempGuard tempGuard) {
        TimeConstrain max = tempGuard.getMax();
        ComparisonOperator type = max.isStrict() ? ComparisonOperator.GREATER_OR_EQUAL : ComparisonOperator.GREATER;
        return ObsUtil.createWhen(clockName, type, max.getValue());
    }
}

