/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime;

import java.util.Arrays;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.types.ConfigurationMapFactory;

public class Configuration {
    public int id = -1;
    public final BehaviorConfiguration[] behaviorConfigurations;
    public short[] dbm;

    public Configuration(BehaviorConfiguration[] behaviorConfigurations, short[] dbm) {
        this.behaviorConfigurations = behaviorConfigurations;
        this.dbm = dbm;
    }

    public Configuration(Configuration other) {
        this(Arrays.copyOf(other.behaviorConfigurations, other.behaviorConfigurations.length), DBM.copy(other.dbm));
    }

    public Configuration createCopy() {
        return new Configuration(this);
    }

    public BehaviorConfiguration replaceBehaviorConfigurationByCopy(short id) {
        BehaviorConfiguration copy;
        this.behaviorConfigurations[id] = copy = this.behaviorConfigurations[id].createCopy();
        return copy;
    }

    public int hashCode() {
        int code = 17;
        for (int i = 0; i < this.behaviorConfigurations.length; ++i) {
            code = code * 37 + (i + 1) * this.behaviorConfigurations[i].hashCode();
        }
        if (ConfigurationMapFactory.checkDBMInclusion) {
            return code;
        }
        if (this.dbm != null) {
            for (short i : this.dbm) {
                code = code * 37 + i;
            }
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object instanceof Configuration) {
            Configuration other = (Configuration)object;
            if (!Arrays.equals(this.behaviorConfigurations, other.behaviorConfigurations)) {
                return false;
            }
            if (ConfigurationMapFactory.checkDBMInclusion) {
                return true;
            }
            return Arrays.equals(this.dbm, other.dbm);
        }
        return false;
    }

    public String toString() {
        return DBM.toConstrainString(this.dbm);
    }
}

