/*
 * Decompiled with CFR 0.152.
 */
package plug.language.fiacre.runtime;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import obp.cc.ConcreteContext;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.Component;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.Program;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.core.Channel;
import obp.fiacre.compiler.FiacreCompiler;

public class FiacreExplorationContext
implements ExplorationContext {
    String rootClassName;
    File binPath;
    Program program;
    Behavior[] behaviors;
    public Channel[] channels;
    public SymbolsTable symbols;
    Component root;
    ProgramLoader loader;
    File fiacreProgramFile;

    public FiacreExplorationContext(File fiacreProgramFile) {
        this.fiacreProgramFile = fiacreProgramFile;
    }

    public FiacreExplorationContext copy() {
        FiacreExplorationContext copy = new FiacreExplorationContext(this.fiacreProgramFile);
        copy.rootClassName = this.rootClassName;
        copy.binPath = this.binPath;
        copy.loader = this.loader;
        copy.symbols = SymbolsTable.createInstance();
        try {
            copy.program = this.loader.loadProgram();
            copy.root = copy.program.getRoot(copy.symbols);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList behaviorList = new ArrayList();
        copy.root.collectBehaviors(behaviorList);
        copy.symbols.endOfBehaviors();
        copy.behaviors = new Behavior[behaviorList.size()];
        Iterator iterator = behaviorList.iterator();
        while (iterator.hasNext()) {
            Behavior process;
            copy.behaviors[process.id] = process = (Behavior)iterator.next();
        }
        for (Behavior process : behaviorList) {
            process.link((ExplorationContext)copy, copy.symbols);
        }
        ArrayList channelList = new ArrayList();
        copy.root.collectChannels(channelList);
        copy.channels = new Channel[channelList.size()];
        Iterator iterator2 = channelList.iterator();
        while (iterator2.hasNext()) {
            Channel channel;
            copy.channels[channel.id] = channel = (Channel)iterator2.next();
        }
        return copy;
    }

    public void initializeExplorationContext() throws Exception {
        if (this.program != null) {
            return;
        }
        FiacreCompiler compiler = new FiacreCompiler();
        this.rootClassName = compiler.compileFiacre(this.fiacreProgramFile);
        this.binPath = compiler.compileJava(this.fiacreProgramFile);
        this.loader = new ProgramLoader.FromClass(this.rootClassName, this.binPath);
        this.symbols = SymbolsTable.createInstance();
        this.program = this.loader.loadProgram();
        this.root = this.program.getRoot(this.symbols);
        ArrayList behaviorList = new ArrayList();
        this.root.collectBehaviors(behaviorList);
        this.symbols.endOfBehaviors();
        this.behaviors = new Behavior[behaviorList.size()];
        Iterator iterator = behaviorList.iterator();
        while (iterator.hasNext()) {
            Behavior process;
            this.behaviors[process.id] = process = (Behavior)iterator.next();
        }
        for (Behavior process : behaviorList) {
            process.link((ExplorationContext)this, this.symbols);
        }
        ArrayList channelList = new ArrayList();
        this.root.collectChannels(channelList);
        this.channels = new Channel[channelList.size()];
        Iterator iterator2 = channelList.iterator();
        while (iterator2.hasNext()) {
            Channel channel;
            this.channels[channel.id] = channel = (Channel)iterator2.next();
        }
    }

    public ConcreteContext getContext() {
        return null;
    }

    public Program getProgram() {
        return this.program;
    }

    public File getCCSLFile() {
        return null;
    }

    public Behavior getBehavior(short i) {
        return this.behaviors[i];
    }

    public int getProcessBehaviorCount() {
        return this.symbols.getObserversStartIndex();
    }

    public int getBehaviorCount() {
        return this.behaviors.length;
    }

    public Channel getChannel(short i) {
        return this.channels[i];
    }

    public int getChannelCount() {
        return this.channels.length;
    }
}

