/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.Communication;
import obp.fiacre.model.Exp;
import obp.fiacre.model.ModelVisitor;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class Emission
extends Communication
implements BoostObject {
    private final List<Exp> argList = new ArrayList<Exp>();

    public Emission() {
    }

    protected Emission(Boost boost) {
        super(boost);
        for (Exp oneChild : BoostUtil.readObjectList((Boost)boost, Exp.class)) {
            this.argList.add(oneChild);
        }
    }

    public List<Exp> getArgList() {
        return Collections.unmodifiableList(this.argList);
    }

    public int getArgCount() {
        return this.argList.size();
    }

    public Exp getArg(int index) {
        if (index < 0 || index >= this.getArgCount()) {
            return null;
        }
        return this.argList.get(index);
    }

    public void addArg(Exp newValue) {
        this.addArg(this.getArgCount(), newValue);
    }

    public void addArg(int index, Exp newValue) {
        this.argList.add(index, newValue);
    }

    public Exp setArg(int index, Exp newValue) {
        return this.argList.set(index, newValue);
    }

    public void addAllArg(Collection<Exp> toAddList) {
        for (Exp newValue : toAddList) {
            this.addArg(this.getArgCount(), newValue);
        }
    }

    public void removeArg(Exp value) {
        int index = this.argList.indexOf(value);
        if (index >= 0) {
            this.removeArg(index);
        }
    }

    public void removeArg(int index) {
        this.argList.remove(index);
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        BoostUtil.writeObjectCollection((Boost)boost, this.argList);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitEmission(this);
    }
}

