/*
 * Decompiled with CFR 0.152.
 */
package obp.cdl.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import obp.LTL.model.Atom;
import obp.LTL.model.AtomReference;
import obp.LTL.model.Conjunction;
import obp.LTL.model.Disjunction;
import obp.LTL.model.Equivalence;
import obp.LTL.model.Eventually;
import obp.LTL.model.Expression;
import obp.LTL.model.FormulaDeclaration;
import obp.LTL.model.FormulaReference;
import obp.LTL.model.Globally;
import obp.LTL.model.Implication;
import obp.LTL.model.ModelVisitor;
import obp.LTL.model.Negation;
import obp.LTL.model.Next;
import obp.LTL.model.Release;
import obp.LTL.model.Until;
import obp.buchi.BuchiAutomaton;
import obp.buchi.BuchiVisitor;
import obp.buchi.State;
import obp.cdl.Activity;
import obp.cdl.ActivityDeclaration;
import obp.cdl.ActivityReference;
import obp.cdl.AltActivity;
import obp.cdl.Assignment;
import obp.cdl.AtomicGuard;
import obp.cdl.CDLDeclaration;
import obp.cdl.CDLUnit;
import obp.cdl.CdlVisitor;
import obp.cdl.ComposedGuard;
import obp.cdl.Declaration;
import obp.cdl.EventDeclaration;
import obp.cdl.EventReference;
import obp.cdl.Guard;
import obp.cdl.LTLDeclaration;
import obp.cdl.NullActivity;
import obp.cdl.Option;
import obp.cdl.ParActivity;
import obp.cdl.PredicateDeclaration;
import obp.cdl.ProcessId;
import obp.cdl.PropertyDeclaration;
import obp.cdl.PropertyReference;
import obp.cdl.RestrictionDeclaration;
import obp.cdl.RestrictionReference;
import obp.cdl.SeqActivity;
import obp.cdl.TopActivity;
import obp.cdl.VariableDeclaration;
import obp.cdl.VariableReference;
import obp.event.EventVisitor;
import obp.event.GammaEvent;
import obp.event.Informal;
import obp.event.Input;
import obp.event.Output;
import obp.event.PredicateEvent;
import obp.event.Signal;
import obp.event.Synchronous;
import obp.event.Value;
import obp.obs.ObsVisitor;
import obp.obs.Observer;
import obp.obs.Reset;
import obp.obs.Transition;
import obp.obs.When;
import obp.predicate.AllPredicate;
import obp.predicate.ArrayAccess;
import obp.predicate.FieldAccess;
import obp.predicate.LiteralComparisonPredicate;
import obp.predicate.LiteralEqualityPredicate;
import obp.predicate.LogicPredicate;
import obp.predicate.Predicate;
import obp.predicate.PredicateReference;
import obp.predicate.PredicateVisitor;
import obp.predicate.StatePredicate;
import obp.predicate.SystemAccess;
import obp.predicate.VariableComparisonPredicate;
import obp.predicate.VariableEqualityPredicate;
import obp.property.NullityExpression;
import obp.property.OccurrenceEvent;
import obp.property.OccurrenceExpression;
import obp.property.PrecedencyExpression;
import obp.property.Property;
import obp.property.PropertyAbsence;
import obp.property.PropertyBuchi;
import obp.property.PropertyExistence;
import obp.property.PropertyObserver;
import obp.property.PropertyPrecedence;
import obp.property.PropertyPrecedenceResponse;
import obp.property.PropertyResponse;
import obp.property.PropertyVisitor;
import obp.property.Scope;
import obp.property.TempGuard;
import obp.property.TemporalOperator;
import obp.property.TimeConstrain;
import obp.util.CDLUtil;
import org.xid.basics.error.Diagnostic;

public class CDLReferenceResolver
implements CdlVisitor,
PropertyVisitor,
EventVisitor,
ObsVisitor,
BuchiVisitor,
PredicateVisitor,
ModelVisitor {
    private final CDLUnit unit;
    private final List<Diagnostic> errors = new ArrayList<Diagnostic>();

    public CDLReferenceResolver(CDLUnit unit) {
        this.unit = unit;
    }

    public List<Diagnostic> getErrors() {
        return this.errors;
    }

    public void handleActivity(Activity activity) {
    }

    public void handleTopActivity(TopActivity toVisit) {
        this.handleActivity(toVisit);
        for (Activity activity : toVisit.getActivityList()) {
            activity.accept(this);
        }
    }

    @Override
    public void visitParActivity(ParActivity toVisit) {
        this.handleTopActivity(toVisit);
    }

    @Override
    public void visitAltActivity(AltActivity toVisit) {
        this.handleTopActivity(toVisit);
    }

    @Override
    public void visitSeqActivity(SeqActivity toVisit) {
        this.handleTopActivity(toVisit);
    }

    @Override
    public void visitActivityReference(ActivityReference toVisit) {
        this.handleActivity(toVisit);
        if (toVisit.getReference() == null) {
            ActivityDeclaration referenced = CDLUtil.findDeclaration(this.unit, toVisit.getName(), ActivityDeclaration.class);
            toVisit.setReference(referenced);
            if (referenced == null) {
                this.addError("Can't find activity named '" + toVisit.getName() + "'.");
            }
        }
    }

    @Override
    public void visitEventReference(EventReference toVisit) {
        this.handleActivity(toVisit);
        if (toVisit.getReference() == null) {
            EventDeclaration referenced = CDLUtil.findDeclaration(this.unit, toVisit.getName(), EventDeclaration.class);
            toVisit.setReference(referenced);
            if (referenced == null) {
                this.addError("Can't find event named '" + toVisit.getName() + "'.");
            }
        } else if ("*anonymous*".equals(toVisit.getName())) {
            toVisit.getReference().accept(this);
        }
    }

    @Override
    public void visitVariableReference(VariableReference toVisit) {
        if (toVisit.getReference() == null) {
            VariableDeclaration referenced = CDLUtil.findDeclaration(this.unit, toVisit.getName(), VariableDeclaration.class);
            toVisit.setReference(referenced);
            if (referenced == null) {
                this.addError("Can't find variable named '" + toVisit.getName() + "'.");
            }
        }
    }

    @Override
    public void visitPropertyReference(PropertyReference toVisit) {
        if (toVisit.getReference() == null) {
            PropertyDeclaration referenced = CDLUtil.findDeclaration(this.unit, toVisit.getName(), PropertyDeclaration.class);
            toVisit.setReference(referenced);
            if (referenced == null) {
                this.addError("Can't find property named '" + toVisit.getName() + "'.");
            }
        }
    }

    @Override
    public void visitRestrictionReference(RestrictionReference toVisit) {
        if (toVisit.getReference() == null) {
            RestrictionDeclaration referenced = CDLUtil.findDeclaration(this.unit, toVisit.getName(), RestrictionDeclaration.class);
            toVisit.setReference(referenced);
            if (referenced == null) {
                this.addError("Can't find restriction named '" + toVisit.getName() + "'.");
            }
        }
    }

    @Override
    public void visitPredicateDeclaration(PredicateDeclaration toVisit) {
        toVisit.getIs().accept(this);
    }

    @Override
    public void visitCDLUnit(CDLUnit toVisit) {
        HashMap allNames = new HashMap();
        for (Declaration declaration : toVisit.getDeclarationList()) {
            Class<?> type = declaration.getClass();
            String name = declaration.getName();
            HashSet<String> names = (HashSet<String>)allNames.get(type);
            if (names == null) {
                names = new HashSet<String>();
                allNames.put(type, names);
            }
            if (names.contains(name)) {
                this.addError("Two or more '" + type.getSimpleName() + "' named '" + name + "' exist.");
            }
            names.add(name);
            declaration.accept(this);
        }
    }

    @Override
    public void visitCDLDeclaration(CDLDeclaration toVisit) {
        for (RestrictionReference restriction : toVisit.getRestrictionList()) {
            restriction.accept(this);
        }
        for (PropertyReference property : toVisit.getPropertyList()) {
            property.accept(this);
        }
        for (Predicate azzert : toVisit.getAssertList()) {
            azzert.accept(this);
        }
        for (FormulaReference ltl : toVisit.getLtlList()) {
            ltl.accept(this);
        }
        if (toVisit.getFoldingPredicate() != null) {
            toVisit.getFoldingPredicate().accept(this);
        }
        if (toVisit.getInit() != null) {
            toVisit.getInit().accept(this);
        }
        if (toVisit.getMain() != null) {
            toVisit.getMain().accept(this);
        }
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration toVisit) {
    }

    @Override
    public void visitEventDeclaration(EventDeclaration toVisit) {
        toVisit.getIs().accept(this);
    }

    @Override
    public void visitActivityDeclaration(ActivityDeclaration toVisit) {
        toVisit.getIs().accept(this);
    }

    @Override
    public void visitPropertyDeclaration(PropertyDeclaration toVisit) {
        if (toVisit.getIs() instanceof PropertyObserver) {
            ((PropertyObserver)toVisit.getIs()).getObserver().setName(toVisit.getName());
        }
        toVisit.getIs().accept(this);
    }

    @Override
    public void visitRestrictionDeclaration(RestrictionDeclaration toVisit) {
        if (toVisit.getIs() instanceof PropertyObserver) {
            ((PropertyObserver)toVisit.getIs()).getObserver().setName(toVisit.getName());
        }
        toVisit.getIs().accept(this);
    }

    @Override
    public void visitAssignment(Assignment toVisit) {
        toVisit.getVariable().accept(this);
    }

    @Override
    public void visitNullActivity(NullActivity toVisit) {
    }

    @Override
    public void visitProcessId(ProcessId toVisit) {
    }

    @Override
    public void visitGuard(Guard toVisit) {
    }

    @Override
    public void visitAtomicGuard(AtomicGuard toVisit) {
    }

    @Override
    public void visitComposedGuard(ComposedGuard toVisit) {
    }

    @Override
    public void visitOption(Option toVisit) {
    }

    @Override
    public void visitOccurrenceEvent(OccurrenceEvent toVisit) {
        EventReference event = toVisit.getEvent();
        EventDeclaration referenced = CDLUtil.findDeclaration(this.unit, event.getName(), EventDeclaration.class);
        event.setReference(referenced);
        if (referenced == null) {
            this.addError("Can't find event named '" + event.getName() + "'.");
        }
    }

    @Override
    public void visitNullityExpression(NullityExpression toVisit) {
        EventReference event = toVisit.getEvent();
        EventDeclaration referenced = CDLUtil.findDeclaration(this.unit, event.getName(), EventDeclaration.class);
        event.setReference(referenced);
        if (referenced == null) {
            this.addError("Can't find event named '" + event.getName() + "'.");
        }
    }

    @Override
    public void visitOccurrenceExpression(OccurrenceExpression toVisit) {
        for (OccurrenceEvent occurenceEvent : toVisit.getOccurrenceEventList()) {
            occurenceEvent.accept(this);
        }
    }

    @Override
    public void visitPrecedencyExpression(PrecedencyExpression toVisit) {
        EventDeclaration referenced;
        for (EventReference event : toVisit.getPreEventList()) {
            referenced = CDLUtil.findDeclaration(this.unit, event.getName(), EventDeclaration.class);
            event.setReference(referenced);
            if (referenced != null) continue;
            this.addError("Can't find event named '" + event.getName() + "'.");
        }
        for (EventReference event : toVisit.getPostEventList()) {
            referenced = CDLUtil.findDeclaration(this.unit, event.getName(), EventDeclaration.class);
            event.setReference(referenced);
            if (referenced != null) continue;
            this.addError("Can't find event named '" + event.getName() + "'.");
        }
    }

    private void handleProperty(Property property) {
        if (property.getScope() != null) {
            property.getScope().accept(this);
        }
    }

    @Override
    public void visitScope(Scope toVisit) {
        toVisit.getPredicate().accept(this);
    }

    @Override
    public void visitPropertyAbsence(PropertyAbsence toVisit) {
        this.handleProperty(toVisit);
        for (EventReference event : toVisit.getEventList()) {
            EventDeclaration referenced = CDLUtil.findDeclaration(this.unit, event.getName(), EventDeclaration.class);
            event.setReference(referenced);
            if (referenced != null) continue;
            this.addError("Can't find event named '" + event.getName() + "'.");
        }
        toVisit.getOccurrenceExpression().accept(this);
    }

    @Override
    public void visitPropertyExistence(PropertyExistence toVisit) {
        this.handleProperty(toVisit);
        for (EventReference event : toVisit.getEventList()) {
            EventDeclaration referenced = CDLUtil.findDeclaration(this.unit, event.getName(), EventDeclaration.class);
            event.setReference(referenced);
            if (referenced != null) continue;
            this.addError("Can't find event named '" + event.getName() + "'.");
        }
        toVisit.getOccurrenceExpression().accept(this);
    }

    private void handlePropertyPrecedenceResponse(PropertyPrecedenceResponse toVisit) {
        this.handleProperty(toVisit);
        for (EventReference eventReference : toVisit.getEventList()) {
            EventDeclaration referenced = CDLUtil.findDeclaration(this.unit, eventReference.getName(), EventDeclaration.class);
            eventReference.setReference(referenced);
            if (referenced != null) continue;
            this.addError("Can't find event named '" + eventReference.getName() + "'.");
        }
        for (NullityExpression nullityExpression : toVisit.getNullityExpressionList()) {
            nullityExpression.accept(this);
        }
        for (PrecedencyExpression precedencyExpression : toVisit.getPrecedencyExpressionList()) {
            precedencyExpression.accept(this);
        }
        toVisit.getPreExpression().accept(this);
        toVisit.getPostExpression().accept(this);
        toVisit.getTemporalOperator().accept(this);
    }

    @Override
    public void visitPropertyPrecedence(PropertyPrecedence toVisit) {
        this.handlePropertyPrecedenceResponse(toVisit);
    }

    @Override
    public void visitPropertyResponse(PropertyResponse toVisit) {
        this.handlePropertyPrecedenceResponse(toVisit);
    }

    @Override
    public void visitPropertyObserver(PropertyObserver toVisit) {
        this.handleProperty(toVisit);
        toVisit.getObserver().accept(this);
    }

    @Override
    public void visitTempGuard(TempGuard toVisit) {
    }

    @Override
    public void visitTimeConstrain(TimeConstrain toVisit) {
    }

    @Override
    public void visitTemporalOperator(TemporalOperator toVisit) {
        toVisit.getTempGuard().accept(this);
    }

    @Override
    public void visitAllPredicate(AllPredicate toVisit) {
    }

    @Override
    public void visitStatePredicate(StatePredicate toVisit) {
    }

    @Override
    public void visitLiteralEqualityPredicate(LiteralEqualityPredicate toVisit) {
    }

    @Override
    public void visitVariableEqualityPredicate(VariableEqualityPredicate toVisit) {
    }

    @Override
    public void visitSystemAccess(SystemAccess toVisit) {
    }

    @Override
    public void visitArrayAccess(ArrayAccess toVisit) {
    }

    @Override
    public void visitFieldAccess(FieldAccess toVisit) {
    }

    @Override
    public void visitPredicateReference(PredicateReference toVisit) {
        PredicateDeclaration referenced = CDLUtil.findDeclaration(this.unit, toVisit.getName(), PredicateDeclaration.class);
        toVisit.setReference(referenced);
        if (referenced == null) {
            this.addError("Can't find predicate named '" + toVisit.getName() + "'.");
        }
    }

    @Override
    public void visitLogicPredicate(LogicPredicate toVisit) {
        toVisit.getLeft().accept(this);
        if (toVisit.getRight() != null) {
            toVisit.getRight().accept(this);
        }
    }

    @Override
    public void visitLiteralComparisonPredicate(LiteralComparisonPredicate toVisit) {
        toVisit.getLeft().accept(this);
    }

    @Override
    public void visitVariableComparisonPredicate(VariableComparisonPredicate toVisit) {
        toVisit.getLeft().accept(this);
        toVisit.getRight().accept(this);
    }

    @Override
    public void visitObserver(Observer toVisit) {
        String clockName = toVisit.getClock();
        for (obp.obs.State state : toVisit.getStateList()) {
            state.accept(this);
        }
        for (Transition transition : toVisit.getTransitionList()) {
            Reset reset;
            When when = transition.getWhen();
            if (when != null && clockName != null && !clockName.equals(when.getClock())) {
                this.addError("There is no clock named '" + when.getClock() + "' in observer '" + toVisit.getName() + "'.");
            }
            if ((reset = transition.getReset()) != null && clockName != null && !clockName.equals(reset.getClock())) {
                this.addError("There is no clock named '" + reset.getClock() + "' in observer '" + toVisit.getName() + "'.");
            }
            transition.accept(this);
        }
    }

    @Override
    public void visitState(obp.obs.State toVisit) {
    }

    @Override
    public void visitReset(Reset toVisit) {
    }

    @Override
    public void visitWhen(When toVisit) {
    }

    @Override
    public void visitTransition(Transition toVisit) {
        if (toVisit.getGuard() != null) {
            toVisit.getGuard().accept(this);
        }
        for (EventReference eR : toVisit.getEventsList()) {
            eR.accept(this);
        }
    }

    @Override
    public void visitGammaEvent(GammaEvent toVisit) {
    }

    @Override
    public void visitInformal(Informal toVisit) {
    }

    @Override
    public void visitSynchronous(Synchronous toVisit) {
    }

    @Override
    public void visitInput(Input toVisit) {
    }

    @Override
    public void visitOutput(Output toVisit) {
    }

    @Override
    public void visitPredicateEvent(PredicateEvent toVisit) {
        toVisit.getPredicate().accept(this);
    }

    @Override
    public void visitSignal(Signal toVisit) {
    }

    @Override
    public void visitValue(Value toVisit) {
    }

    private void addError(String string) {
        for (int i = 0; i < this.errors.size(); ++i) {
            Diagnostic diagnostic = this.errors.get(i);
            if (!diagnostic.getMessage().equals(string)) continue;
            return;
        }
        this.errors.add((Diagnostic)new Diagnostic.Stub(2, string));
    }

    @Override
    public void visitLTLDeclaration(LTLDeclaration toVisit) {
    }

    @Override
    public void visitPropertyBuchi(PropertyBuchi toVisit) {
        this.handleProperty(toVisit);
        toVisit.getBuchi().accept(this);
    }

    @Override
    public void visitBuchiAutomaton(BuchiAutomaton toVisit) {
    }

    @Override
    public void visitState(State toVisit) {
    }

    @Override
    public void visitTransition(obp.buchi.Transition toVisit) {
        if (toVisit.getGuard() != null) {
            toVisit.getGuard().accept(this);
        }
    }

    @Override
    public void visitGlobally(Globally toVisit) {
    }

    @Override
    public void visitEventually(Eventually toVisit) {
    }

    @Override
    public void visitAtom(Atom toVisit) {
        toVisit.getIs().accept(this);
    }

    @Override
    public void visitAtomReference(AtomReference toVisit) {
    }

    @Override
    public void visitFormulaReference(FormulaReference toVisit) {
        if (toVisit.getRef() == null) {
            LTLDeclaration referenced = CDLUtil.findDeclaration(this.unit, toVisit.getName(), LTLDeclaration.class);
            if (referenced == null) {
                this.addError("Can't find property named '" + toVisit.getName() + "'.");
            }
            referenced.getIs().accept(this);
            toVisit.setRef(referenced.getIs());
        }
    }

    @Override
    public void visitFormulaDeclaration(FormulaDeclaration toVisit) {
        for (Atom at : toVisit.getAtomsList()) {
            this.visitAtom(at);
        }
    }

    @Override
    public void visitExpression(Expression toVisit) {
    }

    @Override
    public void visitRelease(Release toVisit) {
    }

    @Override
    public void visitUntil(Until toVisit) {
    }

    @Override
    public void visitConjunction(Conjunction toVisit) {
    }

    @Override
    public void visitDisjunction(Disjunction toVisit) {
    }

    @Override
    public void visitImplication(Implication toVisit) {
    }

    @Override
    public void visitEquivalence(Equivalence toVisit) {
    }

    @Override
    public void visitNegation(Negation toVisit) {
    }

    @Override
    public void visitNext(Next toVisit) {
    }
}

