/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.types;

import java.util.Set;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.fiacre.ConcreteContextConfiguration;
import obp.explorer.runtime.types.ArrayedCtxConfMap;
import obp.explorer.runtime.types.ConfigurationMapFactory;
import obp.explorer.runtime.types.HashedCtxConfMap;
import obp.explorer.runtime.types.IConfigurationMap;

public abstract class ContextConfigurationMap
implements IConfigurationMap {
    int indexOfContextStateInConfiguration;
    int tally;

    public static ContextConfigurationMap createMap(int size, int contextBehaviorID) {
        if (size < 65536) {
            return new ArrayedCtxConfMap(size, contextBehaviorID);
        }
        return new HashedCtxConfMap(size, contextBehaviorID);
    }

    public ContextConfigurationMap(int contextBehaviorID) {
        this.indexOfContextStateInConfiguration = contextBehaviorID;
    }

    private int getContextState(Configuration conf) {
        return ((ConcreteContextConfiguration)conf.behaviorConfigurations[this.indexOfContextStateInConfiguration]).getState();
    }

    @Override
    public Configuration get(Configuration conf) {
        return this.get(this.getContextState(conf), conf);
    }

    public Configuration get(int index, Configuration config) {
        IConfigurationMap map = this.internalGet(index);
        if (map == null) {
            return null;
        }
        return map.get(config);
    }

    @Override
    public void put(Configuration conf) {
        this.add(this.getContextState(conf), conf);
    }

    public void add(int index, Configuration c) {
        IConfigurationMap map = this.internalGet(index);
        if (map == null) {
            map = ConfigurationMapFactory.createConfigurationMap();
            this.setMap(index, map);
        }
        map.put(c);
    }

    @Override
    public long size() {
        long count = 0L;
        for (int i = 0; i < this.tally; ++i) {
            count += this.size(i);
        }
        return count;
    }

    public long size(int index) {
        IConfigurationMap map = this.internalGet(index);
        return map == null ? 0L : map.size();
    }

    public abstract void remove(int var1);

    protected abstract IConfigurationMap internalGet(int var1);

    protected abstract void setMap(int var1, IConfigurationMap var2);

    @Override
    public Set<Configuration> getConfigurations() {
        throw new RuntimeException("get configurations not yet implemented");
    }
}

