/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.buchi.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import obp2.language.buchi.runtime.BuchiConfiguration;
import obp2.language.buchi.runtime.BuchiMarshaller;
import obp2.language.buchi.runtime.BuchiResource;
import obp2.language.buchi.runtime.BuchiRuntime;
import obp2.language.buchi.runtime.BuchiRuntimeView;
import obp2.runtime.core.IAtomicPropositionsProvider;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ILanguagePlugin;
import obp2.runtime.core.IMarshaller;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.runtime.core.LanguageModule;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import properties.BuchiAutomata.BuchiAutomataModel.AcceptingState;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.LTL.transformations.LTL2Buchi;

public class BuchiPlugin
implements ILanguagePlugin<URI, BuchiConfiguration, GuardedTransition, Void> {
    public String getName() {
        return "B\u00fcchi";
    }

    public String[] getExtensions() {
        return new String[]{".buchi"};
    }

    public static LanguageModule<BuchiConfiguration, GuardedTransition, Void> getLanguageModule(String propertiesString, String propertyName) throws Exception {
        ANTLRInputStream is = new ANTLRInputStream(propertiesString);
        return BuchiPlugin.getLanguageModule(is, propertyName);
    }

    public static LanguageModule<BuchiConfiguration, GuardedTransition, Void> getLanguageModule(Path propertiesPath, String propertyName) throws Exception {
        ANTLRFileStream is = new ANTLRFileStream(propertiesPath.toAbsolutePath().toString());
        return BuchiPlugin.getLanguageModule((ANTLRInputStream)is, propertyName);
    }

    public static LanguageModule<BuchiConfiguration, GuardedTransition, Void> getLanguageModule(ANTLRInputStream properties, String propertyName) throws Exception {
        LTL2Buchi converter = new LTL2Buchi(new PrintWriter(System.out));
        BuchiDeclaration buchi = converter.getBuchiDeclaration(propertyName, properties);
        return BuchiPlugin.getLanguageModule(buchi);
    }

    public static LanguageModule<BuchiConfiguration, GuardedTransition, Void> getLanguageModule(BuchiDeclaration buchi) {
        BuchiRuntime runtime = new BuchiRuntime(buchi);
        BuchiRuntimeView runtimeView = new BuchiRuntimeView();
        BuchiMarshaller marshaller = new BuchiMarshaller(buchi);
        return new LanguageModule((ITransitionRelation)runtime, null, (IAtomicPropositionsProvider)runtime, (ITreeProjector)runtimeView, (IMarshaller)marshaller, c -> c.buchiState instanceof AcceptingState);
    }

    public static Map<String, Supplier<ILanguageModule>> getLanguageModuleSupplierMap(Path propertiesPath) throws Exception {
        ANTLRFileStream is = new ANTLRFileStream(propertiesPath.toAbsolutePath().toString());
        LTL2Buchi convertor = new LTL2Buchi(new PrintWriter(System.out));
        Collection buchiDeclarations = convertor.getBuchiDeclarations((ANTLRInputStream)is);
        LinkedHashMap<String, Supplier<ILanguageModule>> modules = new LinkedHashMap<String, Supplier<ILanguageModule>>();
        for (BuchiDeclaration decl : buchiDeclarations) {
            modules.put(decl.getName(), () -> BuchiPlugin.getLanguageModule(decl));
        }
        return modules;
    }

    public ILanguageModule<BuchiConfiguration, GuardedTransition, Void> getRuntime(URI uri) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            BuchiResource description = (BuchiResource)mapper.readValue(uri.toURL(), BuchiResource.class);
            return BuchiPlugin.getLanguageModule(description.getPropertiesString(), description.getPropertyName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Function<URI, ILanguageModule<BuchiConfiguration, GuardedTransition, Void>> languageModuleFunction() {
        return this::getRuntime;
    }

    public Supplier<ILanguageModule<BuchiConfiguration, GuardedTransition, Void>> languageModuleSupplier(Path propertiesPath, String propertyName) {
        return () -> {
            try {
                return BuchiPlugin.getLanguageModule(propertiesPath, propertyName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public boolean isOmegaRegular() {
        return true;
    }
}

