/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.buchi.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import obp2.core.IFiredTransition;
import obp2.core.defaults.FiredTransition;
import obp2.language.buchi.runtime.BuchiConfiguration;
import obp2.runtime.core.IAtomicPropositionsProvider;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.defaults.DefaultLanguageService;
import properties.BuchiAutomata.BuchiAutomataModel.Automaton;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.BuchiAutomata.analysis.AtomExtractor;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;

public class BuchiRuntime
extends DefaultLanguageService<BuchiConfiguration, GuardedTransition, Void>
implements ITransitionRelation<BuchiConfiguration, GuardedTransition, Void>,
IAtomicPropositionsProvider<BuchiConfiguration, GuardedTransition, Void> {
    public final BuchiDeclaration buchiAutomaton;

    public BuchiRuntime(BuchiDeclaration buchiAutomaton) {
        this.buchiAutomaton = buchiAutomaton;
    }

    Automaton getAutomaton() {
        return (Automaton)this.buchiAutomaton.getAutomaton();
    }

    public Set<BuchiConfiguration> initialConfigurations() {
        return Collections.singleton(new BuchiConfiguration(this.getAutomaton().getInitial()));
    }

    public Collection<GuardedTransition> fireableTransitionsFrom(BuchiConfiguration source) {
        return this.getAutomaton().getTransitions().stream().filter(t -> t.getFrom() == source.buchiState).collect(Collectors.toList());
    }

    public IFiredTransition<BuchiConfiguration, GuardedTransition, Void> fireOneTransition(BuchiConfiguration source, GuardedTransition transition) {
        return new FiredTransition((Object)source, (Object)new BuchiConfiguration(transition.getTo()), (Object)transition);
    }

    public Collection<String> getAtomicPropositions() {
        AtomExtractor extractor = new AtomExtractor();
        List atoms = extractor.getAtoms(this.buchiAutomaton);
        return atoms.stream().map(Atom::getCode).collect(Collectors.toList());
    }
}

