/*
 * Decompiled with CFR 0.152.
 */
package obp2.ui2.simulation.trace;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import obp2.core.IFiredTransition;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.simulation.trace_storage.TraceEntry;
import org.reactfx.util.TriFunction;
import plug.utils.Pair;
import plug.utils.ui.graph.GraphViewModel;

public class SimulationGraphViewModel<C, A, O>
extends GraphViewModel<TraceEntry<C, A, O>, Pair<A, O>> {
    private final ObjectProperty<ITransitionRelation<C, A, O>> transitionRelationProperty;
    private final ObjectProperty<ITreeProjector<C, A, O>> runtimeViewProperty;
    private final BooleanProperty inCollapsedConfiguration;
    private final BooleanProperty inShowDifferencesProperty;
    TriFunction<TraceEntry<C, A, O>, BooleanProperty, BooleanProperty, Node> configurationViewBuilder;
    private boolean allColorsConsumed = false;
    private final List<Color> colors = new ArrayList<Color>(Arrays.stream(Color.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers()) && f.getType() == Color.class).map(f -> {
        try {
            return (Color)f.get(Color.class);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }).filter(Objects::nonNull).filter(Color::isOpaque).filter(color -> color.getSaturation() > 0.2 && color.getSaturation() < 0.7).collect(Collectors.toList()));
    private int colorIndex = 0;
    private final ObservableMap<Object, Integer> configurationCounts = FXCollections.observableHashMap();
    private final Map<Object, Color> colorMap = new HashMap<Object, Color>();

    public SimulationGraphViewModel(ObjectProperty<ITransitionRelation<C, A, O>> transitionRelationProperty, ObjectProperty<ITreeProjector<C, A, O>> runtimeViewProperty, TriFunction<TraceEntry<C, A, O>, BooleanProperty, BooleanProperty, Node> configurationViewBuilder, BooleanProperty inShowDifferencesProperty, BooleanProperty inCollapsedConfiguration) {
        this.transitionRelationProperty = transitionRelationProperty;
        this.runtimeViewProperty = runtimeViewProperty;
        this.configurationViewBuilder = configurationViewBuilder;
        this.inShowDifferencesProperty = inShowDifferencesProperty;
        this.inCollapsedConfiguration = inCollapsedConfiguration;
        this.getInitialVertices().addListener(this::onInitialChanged);
        this.getEdges().addListener(this::onEdgesChanged);
        this.configurationCounts.addListener(this::onConfigurationCounts);
    }

    public String vertexDescription(TraceEntry<C, A, O> vertex) {
        return ((ITreeProjector)this.runtimeViewProperty.get()).projectConfiguration((Object)vertex.getConfiguration()).name;
    }

    public String edgeDescription(Pair<A, O> edge) {
        ITreeProjector projector = (ITreeProjector)this.runtimeViewProperty.get();
        return String.format("%s/\n%s", projector.projectFireable((Object)edge.a).name, projector.projectPayload((Object)edge.b).name);
    }

    public Region vertexNode(TraceEntry<C, A, O> vertex) {
        if (this.configurationViewBuilder == null) {
            return new Label("no view builder");
        }
        return (Region)this.configurationViewBuilder.apply(vertex, (Object)this.inShowDifferencesProperty, (Object)this.inCollapsedConfiguration);
    }

    public boolean vertexIsSink(TraceEntry<C, A, O> vertex) {
        ITransitionRelation transitionRelation = (ITransitionRelation)this.transitionRelationProperty.get();
        Collection fireables = transitionRelation.fireableTransitionsFrom(vertex.getConfiguration());
        if (transitionRelation.hasBlockingTransitions()) {
            Iterator iterator = fireables.iterator();
            while (iterator.hasNext()) {
                Object fireable = iterator.next();
                IFiredTransition fired = transitionRelation.fireOneTransition(vertex.getConfiguration(), fireable);
                if (fired != null && !fired.getTargets().isEmpty()) continue;
                iterator.remove();
            }
        }
        return fireables.isEmpty();
    }

    public Color vertexColor(TraceEntry<C, A, O> vertex) {
        return this.allColorsConsumed ? Color.WHITE : this.colorMap.getOrDefault(vertex.getConfiguration(), Color.WHITE);
    }

    protected void onInitialChanged(ListChangeListener.Change<? extends TraceEntry<C, A, O>> change) {
        change.reset();
        while (change.next()) {
            for (TraceEntry entry : change.getAddedSubList()) {
                this.count(entry.getConfiguration());
            }
            for (TraceEntry traceEntry : change.getRemoved()) {
                this.decount(traceEntry.getConfiguration());
            }
        }
    }

    protected void onEdgesChanged(ListChangeListener.Change<? extends GraphViewModel.Edge<TraceEntry<C, A, O>, Pair<A, O>>> change) {
        if (!this.allColorsConsumed) {
            change.reset();
            while (change.next()) {
                for (GraphViewModel.Edge pair : change.getAddedSubList()) {
                    this.count(((TraceEntry)pair.target).getConfiguration());
                }
                for (GraphViewModel.Edge pair : change.getRemoved()) {
                    this.decount(((TraceEntry)pair.target).getConfiguration());
                }
            }
        }
    }

    protected void count(Object configuration) {
        this.configurationCounts.put(configuration, (Object)((Integer)this.configurationCounts.getOrDefault(configuration, (Object)0) + 1));
    }

    protected void decount(Object configuration) {
        Integer count = (Integer)this.configurationCounts.getOrDefault(configuration, (Object)0);
        if (count <= 1) {
            this.configurationCounts.remove(configuration);
        } else {
            this.configurationCounts.put(configuration, (Object)(count - 1));
        }
    }

    protected void onConfigurationCounts(MapChangeListener.Change<? extends Object, ? extends Integer> change) {
        if (change.wasAdded()) {
            Color removed;
            Object key = change.getKey();
            if ((Integer)change.getValueAdded() >= 2) {
                if (!this.colorMap.containsKey(key)) {
                    this.newColorForConfiguration(key);
                }
            } else if ((Integer)change.getValueAdded() == 1 && (removed = this.colorMap.remove(key)) != null) {
                this.colors.add(this.colorIndex, removed);
            }
        }
    }

    protected void newColorForConfiguration(Object configuration) {
        if (this.colorIndex < this.colors.size()) {
            this.colorMap.put(configuration, this.colors.get(this.colorIndex));
            ++this.colorIndex;
        } else {
            this.allColorsConsumed = true;
            this.colorMap.clear();
        }
    }

    public Set<TraceEntry<C, A, O>> equivalentVertices(TraceEntry<C, A, O> vertex) {
        HashSet<TraceEntry<C, A, O>> equivalent = new HashSet<TraceEntry<C, A, O>>();
        for (TraceEntry entry : this.initialVertices) {
            if (vertex == entry || !entry.getConfiguration().equals(vertex.getConfiguration())) continue;
            equivalent.add(entry);
        }
        for (GraphViewModel.Edge edge : this.edges) {
            if (vertex == edge.target || !((TraceEntry)edge.target).getConfiguration().equals(vertex.getConfiguration())) continue;
            equivalent.add((TraceEntry<C, A, O>)edge.target);
        }
        return equivalent;
    }
}

