/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.ValueHolder;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Statement;

public class SpecialTypeStmt
implements Statement {
    private ValueHolder receiver;
    private String selector;
    private final List<Expression> argumentsList = new ArrayList<Expression>();

    public ValueHolder getReceiver() {
        return this.receiver;
    }

    public void setReceiver(ValueHolder newValue) {
        if (this.receiver == null ? newValue != null : !this.receiver.equals(newValue)) {
            this.receiver = newValue;
        }
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String newValue) {
        if (this.selector == null ? newValue != null : !this.selector.equals(newValue)) {
            this.selector = newValue;
        }
    }

    public List<Expression> getArgumentsList() {
        return Collections.unmodifiableList(this.argumentsList);
    }

    public int getArgumentsCount() {
        return this.argumentsList.size();
    }

    public Expression getArguments(int index) {
        if (index < 0 || index >= this.getArgumentsCount()) {
            return null;
        }
        return this.argumentsList.get(index);
    }

    public void addArguments(Expression newValue) {
        this.addArguments(this.getArgumentsCount(), newValue);
    }

    public void addArguments(int index, Expression newValue) {
        this.argumentsList.add(index, newValue);
    }

    public Expression setArguments(int index, Expression newValue) {
        return this.argumentsList.set(index, newValue);
    }

    public void addAllArguments(Collection<Expression> toAddList) {
        for (Expression newValue : toAddList) {
            this.addArguments(this.getArgumentsCount(), newValue);
        }
    }

    public void removeArguments(Expression value) {
        int index = this.argumentsList.indexOf(value);
        if (index >= 0) {
            this.removeArguments(index);
        }
    }

    public void removeArguments(int index) {
        this.argumentsList.remove(index);
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitSpecialTypeStmt(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof SpecialTypeStmt)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((SpecialTypeStmt)that, cache);
    }

    protected boolean equalsFeatures(SpecialTypeStmt that, IdentityHashMap<Object, Object> cache) {
        int l1size = 0;
        int l2size = 0;
        if (!this.selector.equals(that.selector)) {
            return false;
        }
        if (this.argumentsList != null) {
            if (that.argumentsList == null) {
                return false;
            }
            l1size = this.argumentsList.size();
            if (l1size != (l2size = that.argumentsList.size())) {
                return false;
            }
            for (int i = 0; i < l1size; ++i) {
                if (this.argumentsList.get(i).equalsCached(that.argumentsList.get(i), cache)) continue;
                return false;
            }
        }
        return true;
    }
}

