/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.ElementWithArgumentMap;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.PortMap;
import org.cte.ABCD.model.declarations.ProcessDecl;

public class ProcessInstance
implements NamedDeclaration,
ElementWithArgumentMap {
    private String instanceName;
    private ProcessDecl process;
    private final List<PortMap> inputsList = new ArrayList<PortMap>();
    private final List<PortMap> outputsList = new ArrayList<PortMap>();
    private ABCDSystem parent;
    private String name;
    private final List<ArgumentMap> argumentsList = new ArrayList<ArgumentMap>();

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String newValue) {
        if (this.instanceName == null ? newValue != null : !this.instanceName.equals(newValue)) {
            this.instanceName = newValue;
        }
    }

    public ProcessDecl getProcess() {
        return this.process;
    }

    public void setProcess(ProcessDecl newValue) {
        if (this.process == null ? newValue != null : !this.process.equals(newValue)) {
            this.process = newValue;
        }
    }

    public List<PortMap> getInputsList() {
        return Collections.unmodifiableList(this.inputsList);
    }

    public int getInputsCount() {
        return this.inputsList.size();
    }

    public PortMap getInputs(int index) {
        if (index < 0 || index >= this.getInputsCount()) {
            return null;
        }
        return this.inputsList.get(index);
    }

    public void addInputs(PortMap newValue) {
        this.addInputs(this.getInputsCount(), newValue);
    }

    public void addInputs(int index, PortMap newValue) {
        this.inputsList.add(index, newValue);
    }

    public PortMap setInputs(int index, PortMap newValue) {
        return this.inputsList.set(index, newValue);
    }

    public void addAllInputs(Collection<PortMap> toAddList) {
        for (PortMap newValue : toAddList) {
            this.addInputs(this.getInputsCount(), newValue);
        }
    }

    public void removeInputs(PortMap value) {
        int index = this.inputsList.indexOf(value);
        if (index >= 0) {
            this.removeInputs(index);
        }
    }

    public void removeInputs(int index) {
        this.inputsList.remove(index);
    }

    public List<PortMap> getOutputsList() {
        return Collections.unmodifiableList(this.outputsList);
    }

    public int getOutputsCount() {
        return this.outputsList.size();
    }

    public PortMap getOutputs(int index) {
        if (index < 0 || index >= this.getOutputsCount()) {
            return null;
        }
        return this.outputsList.get(index);
    }

    public void addOutputs(PortMap newValue) {
        this.addOutputs(this.getOutputsCount(), newValue);
    }

    public void addOutputs(int index, PortMap newValue) {
        this.outputsList.add(index, newValue);
    }

    public PortMap setOutputs(int index, PortMap newValue) {
        return this.outputsList.set(index, newValue);
    }

    public void addAllOutputs(Collection<PortMap> toAddList) {
        for (PortMap newValue : toAddList) {
            this.addOutputs(this.getOutputsCount(), newValue);
        }
    }

    public void removeOutputs(PortMap value) {
        int index = this.outputsList.indexOf(value);
        if (index >= 0) {
            this.removeOutputs(index);
        }
    }

    public void removeOutputs(int index) {
        this.outputsList.remove(index);
    }

    public ABCDSystem getParent() {
        return this.parent;
    }

    public void setParent(ABCDSystem newValue) {
        if (this.parent == null ? newValue != null : !this.parent.equals(newValue)) {
            this.parent = newValue;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public List<ArgumentMap> getArgumentsList() {
        return Collections.unmodifiableList(this.argumentsList);
    }

    @Override
    public int getArgumentsCount() {
        return this.argumentsList.size();
    }

    @Override
    public ArgumentMap getArguments(int index) {
        if (index < 0 || index >= this.getArgumentsCount()) {
            return null;
        }
        return this.argumentsList.get(index);
    }

    @Override
    public void addArguments(ArgumentMap newValue) {
        this.addArguments(this.getArgumentsCount(), newValue);
    }

    @Override
    public void addArguments(int index, ArgumentMap newValue) {
        this.argumentsList.add(index, newValue);
    }

    @Override
    public ArgumentMap setArguments(int index, ArgumentMap newValue) {
        return this.argumentsList.set(index, newValue);
    }

    @Override
    public void addAllArguments(Collection<ArgumentMap> toAddList) {
        for (ArgumentMap newValue : toAddList) {
            this.addArguments(this.getArgumentsCount(), newValue);
        }
    }

    @Override
    public void removeArguments(ArgumentMap value) {
        int index = this.argumentsList.indexOf(value);
        if (index >= 0) {
            this.removeArguments(index);
        }
    }

    @Override
    public void removeArguments(int index) {
        this.argumentsList.remove(index);
    }

    @Override
    public void addArgumentsAndOpposite(ArgumentMap newValue) {
        this.addArguments(newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public void addAllArgumentsAndOpposite(Collection<ArgumentMap> toAddList) {
        for (ArgumentMap newValue : toAddList) {
            this.addArgumentsAndOpposite(this.getArgumentsCount(), newValue);
        }
    }

    @Override
    public void addArgumentsAndOpposite(int index, ArgumentMap newValue) {
        this.addArguments(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
    }

    @Override
    public ArgumentMap setArgumentsAndOpposite(int index, ArgumentMap newValue) {
        ArgumentMap oldValue = this.argumentsList.set(index, newValue);
        if (newValue != null) {
            newValue.setContainer(this);
        }
        return oldValue;
    }

    @Override
    public void removeArgumentsAndOpposite(ArgumentMap removed) {
        this.removeArguments(removed);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void removeArgumentsAndOpposite(int index) {
        ArgumentMap removed = this.argumentsList.get(index);
        this.removeArguments(index);
        if (removed != null) {
            removed.setContainer(null);
        }
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitProcessInstance(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof ProcessInstance)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((ProcessInstance)that, cache);
    }

    protected boolean equalsFeatures(ProcessInstance that, IdentityHashMap<Object, Object> cache) {
        int i;
        int l1size = 0;
        int l2size = 0;
        if (!this.instanceName.equals(that.instanceName)) {
            return false;
        }
        if (this.inputsList != null) {
            if (that.inputsList == null) {
                return false;
            }
            l1size = this.inputsList.size();
            if (l1size != (l2size = that.inputsList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.inputsList.get(i).equalsCached(that.inputsList.get(i), cache)) continue;
                return false;
            }
        }
        if (this.outputsList != null) {
            if (that.outputsList == null) {
                return false;
            }
            l1size = this.outputsList.size();
            if (l1size != (l2size = that.outputsList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.outputsList.get(i).equalsCached(that.outputsList.get(i), cache)) continue;
                return false;
            }
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.argumentsList != null) {
            if (that.argumentsList == null) {
                return false;
            }
            l1size = this.argumentsList.size();
            if (l1size != (l2size = that.argumentsList.size())) {
                return false;
            }
            for (i = 0; i < l1size; ++i) {
                if (this.argumentsList.get(i).equalsCached(that.argumentsList.get(i), cache)) continue;
                return false;
            }
        }
        return true;
    }
}

