/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import obp.cdl.CDLDeclaration;
import obp.cdl.CDLUnit;
import obp.cdl.Declaration;
import obp.cdl.PropertyDeclaration;
import obp.cdl.RestrictionDeclaration;
import obp.dot.Graph;
import obp.dot.util.DotUtil;
import obp.obs.Observer;
import obp.property.PropertyObserver;
import obp.transfo.property.PropertyToObserver;
import obp.ui.cdl.diagram.CDLDiagram;
import obp.ui.dot.diagram.GraphDiagram;
import obp.util.CDLUtil;
import obp.util.ObsUtil;
import obp.util.PropertyUtil;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.field.BorderField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.DiagramField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.MultiPageField;
import org.xid.basics.ui.field.TextField;

public class CDLUnitController
extends Controller<CDLUnit> {
    private BorderField compositeField;
    private ListField<Declaration> listField;
    private MultiPageField diagramsField;
    private DiagramField<CDLDeclaration> cdlDiagramField;
    private BorderField patternField;
    private TextField patternTextField;
    private DiagramField<Graph> patternGraphField;
    private Map<Declaration, Graph> patternGraphCache;

    public CompositeField createFields() {
        this.createList();
        this.createDiagramField();
        this.compositeField = new BorderField(0, (Field)this.diagramsField);
        this.compositeField.setWest(this.listField, 20);
        return this.compositeField;
    }

    private void createList() {
        this.listField = new ListField<Declaration>(null, 2){

            public String getText(Declaration element) {
                StringBuilder text = new StringBuilder();
                if (element instanceof CDLDeclaration) {
                    text.append("[C] ");
                } else if (element instanceof PropertyDeclaration) {
                    text.append("[P] ");
                } else if (element instanceof RestrictionDeclaration) {
                    text.append("[R] ");
                }
                text.append(element.getName());
                return text.toString();
            }
        };
        this.listField.setNbLines(3);
    }

    private void createDiagramField() {
        this.cdlDiagramField = new DiagramField((Diagram)new CDLDiagram());
        this.cdlDiagramField.getController().setContainer((Object)this);
        this.cdlDiagramField.addAction(this.cdlDiagramField.getController().createIncreaseZoomAction());
        this.cdlDiagramField.addAction(this.cdlDiagramField.getController().createDecreaseZoomAction());
        this.cdlDiagramField.addAction(this.cdlDiagramField.getController().createSaveImageAction());
        this.patternTextField = new TextField(null, 3);
        this.patternTextField.setNbLines(2);
        this.patternGraphField = new DiagramField((Diagram)new GraphDiagram());
        this.patternGraphField.addAction(this.patternGraphField.getController().createIncreaseZoomAction());
        this.patternGraphField.addAction(this.patternGraphField.getController().createDecreaseZoomAction());
        this.patternField = new BorderField(2, this.patternGraphField);
        this.patternField.setNorth((Field)this.patternTextField, 30);
        this.diagramsField = new MultiPageField(new Field[]{this.cdlDiagramField, this.patternField});
    }

    public void refreshFields() {
        if (this.getSubject() == null) {
            this.compositeField.setEnable(false);
            this.listField.setValue(null);
            this.cdlDiagramField.setValue(null);
        } else {
            this.compositeField.setEnable(true);
            ArrayList<Declaration> values = new ArrayList<Declaration>();
            values.addAll(CDLUtil.findAllDeclarations((CDLUnit)this.getSubject(), CDLDeclaration.class));
            values.addAll(CDLUtil.findAllDeclarations((CDLUnit)this.getSubject(), PropertyDeclaration.class));
            values.addAll(CDLUtil.findAllDeclarations((CDLUnit)this.getSubject(), RestrictionDeclaration.class));
            this.listField.setValue(values);
            this.refreshDiagramField();
        }
    }

    private void refreshDiagramField() {
        Declaration singleSelection = (Declaration)this.listField.getSingleSelection();
        if (singleSelection instanceof CDLDeclaration) {
            CDLDeclaration value = (CDLDeclaration)singleSelection;
            this.cdlDiagramField.setValue((Object)value);
            this.diagramsField.setSelected(0);
        } else if (singleSelection instanceof RestrictionDeclaration) {
            RestrictionDeclaration value = (RestrictionDeclaration)singleSelection;
            Graph graph = null;
            if (!this.patternGraphCache.containsKey(singleSelection)) {
                Observer observer = ((PropertyObserver)value.getIs()).getObserver();
                try {
                    String dot = ObsUtil.toDot(observer);
                    graph = DotUtil.layoutDot(dot);
                    this.patternGraphCache.put(value, graph);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                graph = this.patternGraphCache.get(singleSelection);
            }
            this.patternGraphField.setValue((Object)graph);
            this.diagramsField.setSelected(1);
        } else if (singleSelection instanceof PropertyDeclaration) {
            PropertyDeclaration value = (PropertyDeclaration)singleSelection;
            this.patternTextField.setValue(PropertyUtil.print(value.getIs()));
            Graph graph = null;
            if (!this.patternGraphCache.containsKey(singleSelection)) {
                PropertyToObserver transformer = new PropertyToObserver(new PrintWriter(System.out));
                Observer observer = transformer.toObserver(value);
                try {
                    String dot = ObsUtil.toDot(observer);
                    graph = DotUtil.layoutDot(dot);
                    this.patternGraphCache.put(value, graph);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                graph = this.patternGraphCache.get(singleSelection);
            }
            this.patternGraphField.setValue((Object)graph);
            this.diagramsField.setSelected(1);
        }
    }

    public boolean updateSubject(Field field) {
        if (field == this.listField) {
            this.refreshDiagramField();
            return false;
        }
        return false;
    }

    public void setSubject(CDLUnit subject) {
        if (subject != this.subject) {
            super.setSubject((Object)subject);
            this.patternGraphCache = new HashMap<Declaration, Graph>();
        }
    }
}

