/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.controler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import obp.explorer.ExplorerResult;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.Action;
import obp.explorer.runtime.simulation.InteractiveSimulator;
import obp.explorer.runtime.simulation.SimulationResult;
import obp.simulation.component.ObserverDialog;
import obp.simulation.component.SimulationView;
import obp.simulation.controler.AutoSim;
import obp.simulation.model.ConfigurationModel;
import obp.simulation.model.DiagramModel;
import obp.simulation.model.GraphicsModel;
import obp.simulation.model.Previous;
import obp.simulation.model.TransitionModel;
import obp.simulation.zgr.Observateur;

public class SimulationControler
implements Observateur {
    private ConfigurationModel confModel;
    private TransitionModel transModel;
    private DiagramModel diagramModel;
    private GraphicsModel graphicsModel;
    private InteractiveSimulator simulator;
    private List<Action> currentActions = new ArrayList<Action>();
    private Map<Integer, Action> configurationSequence = new HashMap<Integer, Action>();
    private Map<Integer, Map<String, Integer>> transitionSequence = new HashMap<Integer, Map<String, Integer>>();
    private List<ObserverDialog> obsViewerList = null;
    private SimulationView view;
    private AutoSim autoMode;
    private boolean start = false;

    public SimulationControler(ConfigurationModel model, TransitionModel transitionModel, DiagramModel diagramModel, GraphicsModel graphicsModel, InteractiveSimulator simulator, SimulationView view) {
        this.transModel = transitionModel;
        this.confModel = model;
        this.simulator = simulator;
        this.view = view;
        this.diagramModel = diagramModel;
        this.graphicsModel = graphicsModel;
    }

    public void initSimulation(Configuration conf) {
        System.out.println("************* Initialisation ***************");
        this.graphicsModel.addToGraph(Integer.toString(this.confModel.getCurrentConfigId()));
        this.confModel.addConfiguration(conf, null, null, null);
        this.transModel.newTransitions(this.getFireableTransition());
        this.diagramModel.toSequence(this.simulator.getAction(), this.simulator.getSymbols());
        this.configurationSequence.put(this.confModel.getCurrentConfigId(), null);
        this.view.getTraceDialog().setTrace(this.generateTrace(), this.configurationSequence.size());
        this.view.getStateLinePanel().updateStateLine(this.configurationSequence, this.confModel, this);
    }

    public void restart() {
        Configuration initConfig = this.confModel.getConfiguration(0);
        this.confModel.reset();
        this.graphicsModel.reset();
        this.currentActions.clear();
        this.configurationSequence.clear();
        this.transitionSequence.clear();
        this.simulator.getAction().clear();
        this.simulator.getKnown().clear();
        this.simulator.getKnown().put(initConfig);
        this.simulator.currentConfiguration = initConfig;
        this.simulator.getToSee().clear();
        this.simulator.getToSee().add(initConfig);
        this.initSimulation(this.simulator.currentConfiguration);
    }

    public void next(Transition toFire) {
        String toFireString = this.simulator.transitionString(toFire);
        Configuration existConf = this.confModel.alreadyFired(toFire);
        if (existConf == null) {
            SimulationResult result = this.simulator.nextWith(toFire);
            ExplorerResult eRes = result.getExplorerResult();
            if (eRes != null) {
                this.transModel.clear();
                this.view.getConsole().addText("****" + eRes.getState().toString() + "****");
                this.view.getConsole().addText(eRes.getObserverRejectReachedFirstConfiguration().toString());
                this.view.getConsole().addText(eRes.getObserverSuccessReachedFirstConfiguration().toString());
                this.view.getConsole().addText(eRes.getResultFile().getPath());
            } else {
                Configuration newConf = this.simulator.getNextConfiguration();
                int lastActionId = this.simulator.getAction().size() - 1;
                Action newAction = this.simulator.getAction().get(lastActionId);
                int lastCurrentConfig = this.confModel.getCurrentConfigId();
                toFireString = toFireString.replace(";", "\\n");
                this.graphicsModel.addToGraph(Integer.toString(lastCurrentConfig), Integer.toString(newConf.id), toFireString);
                for (Transition fired : result.getFiredTransitions()) {
                    this.confModel.addConfiguration(newConf, fired, newAction, toFireString);
                }
                this.transModel.newTransitions(this.getFireableTransition());
                this.getActionSequence(this.confModel.getCurrentConfigId(), this.currentActions);
                this.diagramModel.toSequence(this.currentActions, this.simulator.getSymbols());
                this.view.getTraceDialog().setTrace(this.generateTrace(), this.configurationSequence.size());
                this.view.getStateLinePanel().updateStateLine(this.configurationSequence, this.confModel, this);
            }
        } else {
            this.getConfig(existConf.id);
        }
    }

    public Transition nextRandom() {
        Transition toFire = this.transModel.getRandomTransition();
        if (toFire == null) {
            return null;
        }
        this.next(toFire);
        return toFire;
    }

    public String transitionToString(Transition t) {
        return this.simulator.transitionString(t);
    }

    public String configurationToString(Configuration c) {
        return this.simulator.configurationToString(c);
    }

    public String stringOfConfiguration(int id) {
        return this.simulator.configurationToString(this.confModel.getConfiguration(id));
    }

    public List<Transition> getFireableTransition() {
        ArrayList<Transition> trans = new ArrayList<Transition>();
        for (Transition transition : this.simulator.getReallyFireable()) {
            trans.add(transition);
        }
        return trans;
    }

    public int getNbConfig() {
        return this.confModel.getNbConfig();
    }

    public int getCurrentConfigId() {
        return this.confModel.getCurrentConfigId();
    }

    public void getPreviousConfig() {
        Configuration previousConf = this.confModel.returnToPrevious();
        this.getActionSequence(previousConf.id, this.currentActions);
        this.simulator.currentConfiguration = previousConf;
        this.simulator.getToSee().clear();
        this.simulator.getToSee().add(previousConf);
        this.transModel.newTransitions(this.getFireableTransition());
        this.diagramModel.toSequence(this.currentActions, this.simulator.getSymbols());
        this.view.getTraceDialog().setTrace(this.generateTrace(), this.configurationSequence.size());
        this.view.getStateLinePanel().updateStateLine(this.configurationSequence, this.confModel, this);
    }

    public void getConfig(int id) {
        Configuration conf = this.confModel.returnTo(id);
        this.getActionSequence(conf.id, this.currentActions);
        this.simulator.currentConfiguration = conf;
        this.simulator.getToSee().clear();
        this.simulator.getToSee().add(conf);
        this.transModel.newTransitions(this.getFireableTransition());
        this.diagramModel.toSequence(this.currentActions, this.simulator.getSymbols());
        this.view.getTraceDialog().setTrace(this.generateTrace(), this.configurationSequence.size());
        this.view.getStateLinePanel().updateStateLine(this.configurationSequence, this.confModel, this);
    }

    public int getNbPrevious() {
        return this.confModel.nbPrevious();
    }

    public Map<Integer, Previous> getPreviousList() {
        return this.confModel.getPreviousList();
    }

    @Override
    public void update(String id) {
        Configuration conf = this.confModel.returnTo(Integer.parseInt(id));
        this.getActionSequence(conf.id, this.currentActions);
        this.simulator.currentConfiguration = conf;
        this.simulator.getToSee().clear();
        this.simulator.getToSee().add(conf);
        this.transModel.newTransitions(this.getFireableTransition());
        this.diagramModel.toSequence(this.currentActions, this.simulator.getSymbols());
        this.view.getTraceDialog().setTrace(this.generateTrace(), this.configurationSequence.size());
        this.view.getStateLinePanel().updateStateLine(this.configurationSequence, this.confModel, this);
    }

    private void getActionSequence(int id, List<Action> actionList) {
        actionList.clear();
        this.configurationSequence.clear();
        this.transitionSequence.clear();
        this.view.getGraphicsPanel().unHighLigthAllEdge();
        this.findSequence(id, actionList, this.configurationSequence, this.transitionSequence);
        Collections.reverse(actionList);
    }

    private void findSequence(int id, List<Action> actionList, Map<Integer, Action> past, Map<Integer, Map<String, Integer>> transitionSequence) {
        past.put(id, null);
        if (id > 0) {
            Previous previous = this.confModel.getPreviousConfigWithActionOf(id);
            if (!past.containsKey(previous.getId())) {
                if (previous.getAction() != null) {
                    actionList.add(previous.getAction());
                    this.view.getGraphicsPanel().highligthEdge(id, previous.getId());
                    HashMap<String, Integer> tmp = new HashMap<String, Integer>();
                    tmp.put(previous.getTransition(), id);
                    past.put(id, previous.getAction());
                    transitionSequence.put(previous.getId(), tmp);
                }
                this.findSequence(previous.getId(), actionList, past, transitionSequence);
            } else {
                this.confModel.getConfigurationFromLts(id).switchPrevious();
                previous = this.confModel.getPreviousConfigWithActionOf(id);
                if (previous.getId() != id) {
                    if (previous.getAction() != null) {
                        actionList.add(previous.getAction());
                        this.view.getGraphicsPanel().highligthEdge(id, previous.getId());
                        HashMap<String, Integer> tmp = new HashMap<String, Integer>();
                        tmp.put(previous.getTransition(), id);
                        transitionSequence.put(previous.getId(), tmp);
                    }
                    this.findSequence(previous.getId(), actionList, past, transitionSequence);
                } else {
                    System.out.println("Boucle detect");
                }
            }
        }
    }

    public void startAutoMode() {
        if (this.start) {
            this.autoMode.resumeSimu();
        } else {
            this.autoMode = new AutoSim(this);
            this.autoMode.start();
        }
    }

    public void pauseAutoMode() {
        this.autoMode.pauseSimu();
    }

    public void stopAutoMode() {
        this.autoMode.stopSimu();
        this.start = false;
    }

    public void setDelayAutoMode(int delay) {
        this.start = true;
        if (true) {
            this.autoMode.setDelay(delay);
        }
    }

    public void autoModeEnd() {
        this.view.getToolBar().stopAction();
        this.start = false;
    }

    public void exit() {
        this.graphicsModel.exit();
    }

    public File getGraphFile() {
        return this.graphicsModel.getFile();
    }

    @Override
    public void altUpdate(String id) {
        this.confModel.getConfigurationFromLts(Integer.parseInt(id)).switchPrevious();
        this.getActionSequence(this.confModel.getCurrentConfigId(), this.currentActions);
        this.diagramModel.toSequence(this.currentActions, this.simulator.getSymbols());
        this.view.getTraceDialog().setTrace(this.generateTrace(), this.configurationSequence.size());
    }

    public void svgExport(File file) {
        this.view.getGraphicsPanel().svgExport(file);
    }

    public void setObsViewerList(List<ObserverDialog> obsViewerList) {
        this.obsViewerList = obsViewerList;
    }

    public List<ObserverDialog> getObsViewerList() {
        return this.obsViewerList;
    }

    public void openAllObsViewer() {
        if (this.obsViewerList != null) {
            for (ObserverDialog obsDial : this.obsViewerList) {
                obsDial.setVisible(true);
            }
        } else {
            this.view.getConsole().addTextError("No observer available !");
        }
    }

    public void closeAllObsViewer() {
        if (this.obsViewerList != null) {
            for (ObserverDialog obsDial : this.obsViewerList) {
                obsDial.setVisible(false);
            }
        } else {
            this.view.getConsole().addTextError("No observer available !");
        }
    }

    public String generateTrace() {
        StringBuilder trace = new StringBuilder();
        StringBuilder transition = new StringBuilder();
        Iterator<Object> iterator = this.configurationSequence.keySet().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            trace.append("Config: " + this.stringOfConfiguration(n));
            trace.append("\n\n");
        }
        if (this.transitionSequence.size() > 0) {
            transition.append("transitions: {\n");
            for (Map.Entry entry : this.transitionSequence.entrySet()) {
                transition.append("( " + entry.getKey() + " , ");
                for (Map.Entry second : ((Map)entry.getValue()).entrySet()) {
                    transition.append("\"" + (String)second.getKey() + "\" , " + second.getValue() + ")\n");
                }
            }
            transition.append("\n}\n");
        }
        return trace.toString() + transition.toString();
    }
}

