/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker;

import java.util.LinkedHashSet;
import java.util.Set;
import obp.fiacre.checker.ProgramAnalyzer;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.ExternalFunctionRef;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.ModelWalker;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.VarRef;
import obp.fiacre.model.Variable;
import obp.fiacre.util.CommentedUtil;
import obp.fiacre.util.ComponentUtil;
import obp.fiacre.util.ProcessUtil;

public class VariableAnalyzer {
    public static final String localToTransitionsAnnotation = "ltt";
    private final ProgramAnalyzer caller;
    private boolean valid = true;
    private final Set<LocalVariable> unusedVariableSet = new LinkedHashSet<LocalVariable>();
    private final Set<LocalVariable> constantVariableSet = new LinkedHashSet<LocalVariable>();
    private final Set<LocalVariable> localToTransitionsVariableSet = new LinkedHashSet<LocalVariable>();

    public VariableAnalyzer(ProgramAnalyzer caller) {
        this.caller = caller;
    }

    public boolean analyze() {
        for (Declaration declaration : this.caller.getProgram().getDeclarationList()) {
            if (declaration instanceof ComponentDecl) {
                this.checkComponent((ComponentDecl)declaration);
                continue;
            }
            if (!(declaration instanceof ProcessDecl)) continue;
            this.checkProcess((ProcessDecl)declaration);
        }
        return this.valid;
    }

    private void checkComponent(ComponentDecl componentDecl) {
        Set<Variable> usedVariables = ComponentUtil.getUsedVariables(componentDecl);
        Set<LocalVariable> referencedVariables = ComponentUtil.getReferencedVariables(componentDecl);
        for (LocalVariable variable : componentDecl.getVarList()) {
            if (!usedVariables.contains(variable) || referencedVariables.contains(variable)) continue;
            this.info("Variable '" + variable.getName() + "' in '" + componentDecl.getName() + "' is constant.\n");
            this.constantVariableSet.add(variable);
        }
    }

    private void checkProcess(ProcessDecl processDecl) {
        ModelWalker walker;
        Set<Variable> usedVariables = ProcessUtil.getUsedVariables(processDecl);
        Set<Variable> modifiedVariables = ProcessUtil.getModifiedVariables(processDecl);
        CheckIfExternalFunctionModifiesVariable visitor = new CheckIfExternalFunctionModifiesVariable();
        visitor.walker = walker = new ModelWalker(visitor);
        visitor.modifiedVariables = modifiedVariables;
        processDecl.accept(walker);
        for (LocalVariable localVariable : processDecl.getVarList()) {
            if (!usedVariables.contains(localVariable)) {
                this.info("Removing variable '" + localVariable.getName() + "' in '" + processDecl.getName() + "'.\n");
                this.unusedVariableSet.add(localVariable);
            } else if (!modifiedVariables.contains(localVariable)) {
                this.info("Variable '" + localVariable.getName() + "' in '" + processDecl.getName() + "' is constant.\n");
                this.constantVariableSet.add(localVariable);
            } else if (CommentedUtil.containsAnnotation(localVariable, localToTransitionsAnnotation)) {
                this.info("Variable '" + localVariable.getName() + "' in '" + processDecl.getName() + "' is local to transitions.\n");
                this.localToTransitionsVariableSet.add(localVariable);
                if (localVariable.getInitializer() == null) {
                    this.addError("Local to transition variable '" + localVariable.getName() + "' in '" + processDecl.getName() + "' must be declared with an initializer.\n");
                }
            }
            for (ArgumentVariable argument : processDecl.getArgList()) {
                if (!localVariable.getName().equals(argument.getName())) continue;
                this.addError("Local variable '" + localVariable.getName() + "' in '" + processDecl.getName() + "' is in conflict with the argument of the same name.\n");
            }
        }
        for (ArgumentVariable argumentVariable : processDecl.getArgList()) {
            if (argumentVariable.isRef() || !modifiedVariables.contains(argumentVariable)) continue;
            this.addError("Variable '" + argumentVariable.getName() + "' in '" + processDecl.getName() + "' is a parameter argument, it can't be modified (use a reference argument).\n");
        }
    }

    private boolean isConstant(Variable variable) {
        return this.constantVariableSet.contains(variable);
    }

    private boolean isUnused(Variable variable) {
        return this.unusedVariableSet.contains(variable);
    }

    public boolean isLocalToTransitions(Variable variable) {
        return this.localToTransitionsVariableSet.contains(variable);
    }

    public boolean isConfigurationVariable(Variable variable) {
        if (this.isUnused(variable)) {
            return false;
        }
        if (this.isConstant(variable)) {
            return false;
        }
        return !this.isLocalToTransitions(variable);
    }

    public boolean isBehaviorVariable(Variable variable) {
        return this.isConstant(variable);
    }

    private void info(String message) {
        this.caller.getErrorHandler().handleError(0, message);
    }

    private void addError(String message) {
        this.valid = false;
        this.caller.getErrorHandler().handleError(2, message);
    }

    class CheckIfExternalFunctionModifiesVariable
    extends ModelVisitor.Stub {
        ModelWalker walker;
        Set<Variable> modifiedVariables;

        CheckIfExternalFunctionModifiesVariable() {
        }

        @Override
        public void visitVarRef(VarRef toVisit) {
            if (this.walker.getParentStack().peek() instanceof ExternalFunctionRef) {
                ExternalFunctionRef eFR = (ExternalFunctionRef)this.walker.getParentStack().peek();
                int paramIdx = eFR.getParamList().indexOf(toVisit);
                if (eFR.getDecl().getArg(paramIdx).isWrite()) {
                    this.modifiedVariables.add(toVisit.getDecl());
                }
            }
        }
    }
}

