/*
 * Decompiled with CFR 0.152.
 */
package obp.cc.splitter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import obp.cc.ConcreteContext;
import obp.partition.SimplePartitioner;
import obp.transfo.cc.ConcreteContextExport;
import obp.transfo.cc.ConcreteContextTopological;
import obp.util.ConcreteContextUtil;

public class Splitter {
    File concreteContextPath = null;
    File ctxDirectory = null;
    int splitStep = 0;
    boolean splitAll;

    public List<File> split(ConcreteContext cc, int splitStep, File contextDirectory) {
        SimplePartitioner partitioner = new SimplePartitioner(cc, splitStep);
        ArrayList<File> contextPaths = new ArrayList<File>();
        while (partitioner.hasNext()) {
            ConcreteContext currentCtx = partitioner.next();
            try {
                File file = new File(contextDirectory, currentCtx.getName() + ".cc");
                contextPaths.add(file);
                ConcreteContextUtil.saveCC(currentCtx, file);
                currentCtx = ConcreteContextTopological.orderCC(currentCtx);
                System.out.println(currentCtx.getName() + " has " + ConcreteContextUtil.countPathsLinear(currentCtx).toString() + " paths");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return contextPaths;
    }

    File saveToFile(ConcreteContext context, String name, File contextDirectory) {
        try {
            File file = new File(contextDirectory, name + ".cc");
            ConcreteContextUtil.saveCC(context, file);
            return file;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<File> splitAll(ConcreteContext cc, File contextDirectory) {
        ArrayList<File> contextPaths = new ArrayList<File>();
        LinkedList<ConcreteContext> toSee = new LinkedList<ConcreteContext>();
        int idx = 0;
        String name = cc.getName();
        toSee.addLast(cc);
        while (!toSee.isEmpty()) {
            ConcreteContext current = (ConcreteContext)toSee.removeFirst();
            SimplePartitioner partitioner = new SimplePartitioner(current, 1);
            while (partitioner.hasNext()) {
                ConcreteContext next = partitioner.next();
                if (ConcreteContextUtil.countPathsLinear(next = ConcreteContextTopological.orderCC(next)) == BigInteger.ONE) {
                    String myName = name + "_" + String.format("%02d", idx);
                    next.setName(myName);
                    contextPaths.add(this.saveToFile(next, myName, contextDirectory));
                    ++idx;
                    continue;
                }
                toSee.addLast(next);
            }
        }
        return contextPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toDot(File contextDirectory, ConcreteContext next, String myName) {
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new FileWriter(contextDirectory.getAbsolutePath() + "/" + myName + ".dot"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                bw.write(ConcreteContextExport.toDot(next));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void usage() {
        System.out.println("Usage: Splitter [options] concrete-context-path");
        System.out.println("Mandatory parameters: ");
        System.out.println("\t[--context-directory or -o] path\tdestination Path for generated contexts.");
        System.out.println();
        System.out.println("Context parameters:");
        System.out.println("\t[--step or -s] int\t\t The split step value");
        System.out.println("\t[--all-linear] Enumerate all linear paths in the context");
        System.out.println();
        System.out.println("Other parameters:");
        System.out.println("\t[--help or -h]\t\t\tPrints this help and exit.");
    }

    public boolean readArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("--context-directory".equals(args[i]) || "-o".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--context-directory' needs an argument.");
                    return false;
                }
                if (args[i].length() == 0 || args[i].startsWith("-")) {
                    System.err.println("Invalid file name '" + args[i] + "'.");
                    return false;
                }
                this.ctxDirectory = new File(args[i]);
                continue;
            }
            if ("--step".equals(args[i]) || "-s".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--step' needs an argument.");
                    return false;
                }
                if (args[i].length() == 0 || args[i].startsWith("-")) {
                    System.err.println("Invalid split parameter '" + args[i] + "'.");
                    return false;
                }
                this.splitStep = Integer.parseInt(args[i]);
                continue;
            }
            if ("--all-linear".equals(args[i])) {
                this.splitAll = true;
                continue;
            }
            if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                this.usage();
                return false;
            }
            if (this.concreteContextPath != null) continue;
            this.concreteContextPath = new File(args[i]);
        }
        if (this.concreteContextPath == null) {
            System.err.println("missing path to the concrete context file");
            this.usage();
            return false;
        }
        if (this.ctxDirectory == null) {
            System.err.println("Missing context directory path (--context-directory)");
            this.usage();
            return false;
        }
        return true;
    }

    public void defaultSplit() {
        if (!this.ctxDirectory.exists()) {
            this.ctxDirectory.mkdirs();
        }
        try {
            ConcreteContext cc = ConcreteContextUtil.loadCC(this.concreteContextPath);
            List<File> contextPaths = this.splitAll ? this.splitAll(cc, this.ctxDirectory) : this.split(cc, this.splitStep, this.ctxDirectory);
            System.out.println("Context " + cc.getName() + " splitted in " + contextPaths.size() + " contexts.");
            for (File file : contextPaths) {
                System.out.println("\t- " + file.getPath());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Splitter main = new Splitter();
        try {
            if (main.readArguments(args)) {
                main.defaultSplit();
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

