/*
 * Decompiled with CFR 0.152.
 */
package plug.modules.synchronization.byClocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.core.IStateSpaceManager;
import obp2.core.defaults.FiredTransition;
import obp2.explorer.PastFreezeExplorer;
import obp2.runtime.core.ITransitionRelation;
import obp2.statespace.PastFreezeStateSpaceManager;
import plug.modules.synchronization.ISynchronizedTransition;
import plug.modules.synchronization.ISynchronizingRuntime;
import plug.modules.synchronization.byClocks.ClockBuDDySatisfiability;
import plug.modules.synchronization.byClocks.CompositeClockedTransition;
import plug.modules.synchronization.byClocks.IClockSatisfiability;
import plug.modules.synchronization.byClocks.IClockSynchronizationManager;
import plug.modules.synchronization.byClocks.IClockedTransition;
import plug.modules.synchronization.runtime.SynchronizationConfiguration;
import plug.modules.synchronization.runtime.SynchronizationTransitionRelation;
import plug.utils.CartesianProduct;

public class ClockSynchronizationManager<C extends IConfiguration, T>
implements IClockSynchronizationManager<C, T> {
    protected ISynchronizingRuntime<C, T> runtime;
    public boolean exploreSynchronization = false;
    private IClockSatisfiability solver = new ClockBuDDySatisfiability();
    int numberOfAutomata = 0;
    private List<IClockedTransition>[] fireableByAutomaton;
    private int[][] vocabularyByAutomaton;

    public ClockSynchronizationManager(ISynchronizingRuntime<C, T> runtime) {
        this.runtime = runtime;
    }

    @Override
    public void setRuntime(ISynchronizingRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public ISynchronizingRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    public void setExploreSynchronization(boolean isExploring) {
        this.exploreSynchronization = isExploring;
    }

    @Override
    public boolean getExploreSynchronization() {
        return this.exploreSynchronization;
    }

    @Override
    public void initialize(int numberOfClocks, int numberOfAutomata) {
        this.numberOfAutomata = numberOfAutomata;
        this.fireableByAutomaton = new List[numberOfAutomata];
        this.vocabularyByAutomaton = new int[numberOfAutomata][];
        this.solver.initialize(numberOfClocks, numberOfAutomata);
    }

    @Override
    public void addVocabulary(int behaviorId, int[] vocabulary) {
        this.vocabularyByAutomaton[behaviorId] = vocabulary;
    }

    @Override
    public void addTransition(int behaviorId, IClockedTransition behavior) {
        List<IClockedTransition> transitionsList = this.fireableByAutomaton[behaviorId];
        if (transitionsList == null) {
            transitionsList = this.fireableByAutomaton[behaviorId] = new ArrayList<IClockedTransition>();
        }
        transitionsList.add(behavior);
        this.solver.addTransitionConstraint(behaviorId, behavior.vector(), this.vocabularyByAutomaton[behaviorId]);
    }

    boolean isTransitionActivated(IClockedTransition transition, int automataID, boolean[] clockValuation) {
        int[] blocked;
        int[] vector;
        for (int i : vector = transition.vector()) {
            if (clockValuation[i]) continue;
            return false;
        }
        for (int i : blocked = this.solver.blockedClocks(vector, this.vocabularyByAutomaton[automataID])) {
            if (!clockValuation[i]) continue;
            return false;
        }
        return true;
    }

    List<IClockedTransition>[] selectActivatedTransitions(boolean[] clockValuation) {
        List[] fireables = new List[this.numberOfAutomata];
        int activatedCount = 0;
        for (int automataID = 0; automataID < this.numberOfAutomata; ++automataID) {
            List<IClockedTransition> transitions = this.fireableByAutomaton[automataID];
            fireables[automataID] = new ArrayList();
            for (int i = 0; i < transitions.size(); ++i) {
                IClockedTransition transition = transitions.get(i);
                if (!this.isTransitionActivated(transition, automataID, clockValuation)) continue;
                fireables[automataID].add(transition);
                ++activatedCount;
            }
        }
        if (activatedCount == 0) {
            return null;
        }
        return fireables;
    }

    @Override
    public Collection<ISynchronizedTransition<T>> fireableTransitionsFrom(C currentConfiguration) {
        ArrayList<ISynchronizedTransition<T>> results = new ArrayList<ISynchronizedTransition<T>>();
        this.solver.globalAllSAT(oneSolution -> {
            List<IClockedTransition>[] activatedByClockValuation = this.selectActivatedTransitions(oneSolution);
            if (activatedByClockValuation != null) {
                results.addAll(this.retrieveSynchronizedTransitionsFrom(currentConfiguration, activatedByClockValuation));
            }
        });
        this.fireableByAutomaton = new List[this.numberOfAutomata];
        this.solver.clear();
        return results;
    }

    private Collection<ISynchronizedTransition<T>> retrieveSynchronizedTransitionsFrom(C current, List<IClockedTransition>[] activatedByAutomaton) {
        ArrayList<List<IClockedTransition>> theSoS = new ArrayList<List<IClockedTransition>>();
        for (int i = 0; i < this.numberOfAutomata; ++i) {
            List<IClockedTransition> activatedTransitions = activatedByAutomaton[i];
            if (activatedTransitions.isEmpty()) continue;
            theSoS.add(activatedTransitions);
        }
        List allCombinations = CartesianProduct.recursiveCartesianProduct(theSoS);
        ArrayList<ISynchronizedTransition<T>> reallyFireables = new ArrayList<ISynchronizedTransition<T>>();
        for (List tuple : allCombinations) {
            CompositeClockedTransition oneCompositeTransition = new CompositeClockedTransition();
            oneCompositeTransition.addOutputBehaviors(tuple);
            reallyFireables.add(oneCompositeTransition);
        }
        return reallyFireables;
    }

    @Override
    public IFiredTransition<C, ?, ?> fireOneTransition(C currentConfiguration, ISynchronizedTransition<T> transition) {
        HashSet targetConfigurations = new HashSet();
        if (!(transition instanceof CompositeClockedTransition)) {
            return this.getRuntime().executeOneTransition(currentConfiguration, transition);
        }
        this.executeSynchronizedBehaviors(currentConfiguration, (CompositeClockedTransition)transition, targetConfigurations);
        return new FiredTransition(currentConfiguration, targetConfigurations, transition);
    }

    private void executeSynchronizedBehaviors(C initialConfiguration, CompositeClockedTransition synchronousTransitions, Set<C> ioResults) {
        if (this.exploreSynchronization) {
            this.executeSynchronizedBehaviorsExploring(initialConfiguration, synchronousTransitions, ioResults);
            return;
        }
        this.executeSynchronizedBehaviorsArbitraryOrder(initialConfiguration, synchronousTransitions, ioResults);
    }

    private void executeSynchronizedBehaviorsArbitraryOrder(C initialConfiguration, CompositeClockedTransition synchronousTransitions, Set<C> ioResults) {
        Object nowConfig = initialConfiguration;
        for (Object transition : synchronousTransitions.getOutputBehaviors()) {
            IFiredTransition<C, ?, ?> fired = this.getRuntime().executeOneTransition(nowConfig, transition);
            nowConfig = (IConfiguration)fired.getTarget(0);
            if (nowConfig != null) continue;
            return;
        }
        ioResults.add(nowConfig);
    }

    PastFreezeExplorer newSynchronizationExplorer(SynchronizationTransitionRelation syncRuntime) {
        PastFreezeStateSpaceManager stateSpaceManager = new PastFreezeStateSpaceManager(1, SynchronizationConfiguration::clusterIndexGetter);
        PastFreezeExplorer explorer = new PastFreezeExplorer((ITransitionRelation)syncRuntime, (IStateSpaceManager)stateSpaceManager, SynchronizationConfiguration::clusterIndexGetter);
        return explorer;
    }

    private void executeSynchronizedBehaviorsExploring(C initialConfiguration, CompositeClockedTransition synchronousTransitions, Set<C> ioResults) {
        SynchronizationTransitionRelation syncRuntime = new SynchronizationTransitionRelation();
        syncRuntime.availableTransitions = new IClockedTransition[1][];
        ((IClockedTransition[][])syncRuntime.availableTransitions)[0] = synchronousTransitions.getOutputBehaviors().toArray(new IClockedTransition[synchronousTransitions.getOutputBehaviors().size()]);
        syncRuntime.initial = initialConfiguration;
        syncRuntime.results = ioResults;
        syncRuntime.runtime = this.runtime;
        PastFreezeExplorer explorer = this.newSynchronizationExplorer(syncRuntime);
        explorer.execute();
    }
}

