/*
 * Decompiled with CFR 0.152.
 */
package plug.modules.synchronization.byChannels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import obp2.core.IFiredTransition;
import obp2.core.defaults.FiredTransition;
import plug.modules.synchronization.ISynchronizedTransition;
import plug.modules.synchronization.ISynchronizingRuntime;
import plug.modules.synchronization.SynchronizationExplorer;
import plug.modules.synchronization.byChannels.IChannelSynchronizationManager;
import plug.utils.CartesianProduct;

public class ChannelSynchronizationManager<C, T>
implements IChannelSynchronizationManager<C, T> {
    ISynchronizingRuntime<C, T> runtime;
    Map<Integer, ScheduledBehaviors> scheduledSynchronizations = new HashMap<Integer, ScheduledBehaviors>();
    private final SynchronizationExplorer<C, T> syncExplorer;
    public boolean exploreSynchronization = true;
    CartesianProduct<Object> cartesianProductProvider = new CartesianProduct();

    @Override
    public void setSynchronizationArraySupplier2(Function<Integer, T[][]> synchronizationArrayMaker) {
    }

    @Override
    public void setSynchronizationArraySupplier1(Function<Integer, T[]> synchronizationArrayMaker) {
    }

    @Override
    public void registerChannel(int channelID, int requiredOutputs, int requiredInputs) {
    }

    @Override
    public void addVocabulary(int automataID, int[] outputVocabulary, int[] inputVocabulary) {
    }

    @Override
    public void scheduleOutput(int channelId, int behaviorId, T behavior) {
    }

    @Override
    public void scheduleInput(int channelId, int behaviorId, T behavior) {
    }

    @Override
    public boolean isComplete(int channelID) {
        return false;
    }

    @Override
    public void clearSchedule() {
    }

    public ChannelSynchronizationManager(ISynchronizingRuntime runtime) {
        this.runtime = runtime;
        this.syncExplorer = new SynchronizationExplorer(runtime);
    }

    @Override
    public void setExploreSynchronization(boolean isExploring) {
        this.exploreSynchronization = isExploring;
    }

    @Override
    public boolean getExploreSynchronization() {
        return this.exploreSynchronization;
    }

    @Override
    public void setRuntime(ISynchronizingRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public ISynchronizingRuntime getRuntime() {
        return this.runtime;
    }

    public void addInput(int channelID, int behaviorID, T behavior) {
        ArrayList<Object> fireableBehaviors;
        ScheduledBehaviors channelSchedule = this.scheduledSynchronizations.get(channelID);
        if (channelSchedule == null) {
            channelSchedule = new ScheduledBehaviors();
            this.scheduledSynchronizations.put(channelID, channelSchedule);
        }
        if ((fireableBehaviors = channelSchedule.inputs.get(behaviorID)) == null) {
            fireableBehaviors = new ArrayList();
            channelSchedule.inputs.put(behaviorID, fireableBehaviors);
        }
        fireableBehaviors.add(behavior);
    }

    public void addOutput(int channelID, int behaviorID, T behavior) {
        ArrayList<Object> fireableBehaviors;
        ScheduledBehaviors channelSchedule = this.scheduledSynchronizations.get(channelID);
        if (channelSchedule == null) {
            channelSchedule = new ScheduledBehaviors();
            this.scheduledSynchronizations.put(channelID, channelSchedule);
        }
        if ((fireableBehaviors = channelSchedule.outputs.get(behaviorID)) == null) {
            fireableBehaviors = new ArrayList();
            channelSchedule.outputs.put(behaviorID, fireableBehaviors);
        }
        fireableBehaviors.add(behavior);
    }

    @Override
    public Collection<ISynchronizedTransition<T>> fireableTransitionsFrom(C currentConfiguration) {
        return this.retrieveSynchronizedTransitionsFrom(currentConfiguration);
    }

    private Collection<ISynchronizedTransition<T>> retrieveSynchronizedTransitionsFrom(C current) {
        ArrayList<ISynchronizedTransition<T>> synchronizedTransitions = new ArrayList<ISynchronizedTransition<T>>();
        for (int channelID : this.scheduledSynchronizations.keySet()) {
            ScheduledBehaviors channelSchedule = this.scheduledSynchronizations.get(channelID);
            synchronizedTransitions.addAll(this.retrieveSynchronizedTransitionsOnChannel(current, channelID, channelSchedule));
        }
        this.scheduledSynchronizations = new HashMap<Integer, ScheduledBehaviors>();
        return synchronizedTransitions;
    }

    private Collection<ISynchronizedTransition<T>> new_retrieveSynchronizedTransitionsOnChannel(C current, int channelID, ScheduledBehaviors scheduled) {
        Collection outsList = scheduled.outputs.values().stream().map(arr -> arr.toArray()).collect(Collectors.toList());
        Object[][] outs = (Object[][])outsList.toArray((T[])new Object[outsList.size()][]);
        Collection insList = scheduled.outputs.values().stream().map(arr -> arr.toArray()).collect(Collectors.toList());
        Object[][] ins = (Object[][])insList.toArray((T[])new Object[insList.size()][]);
        Set<ISynchronizedTransition<T>> result = Collections.newSetFromMap(new IdentityHashMap());
        Consumer<Object[][]> callback = tuple -> {};
        Object[][] resultTuple = new Object[][]{new Object[outs.length], new Object[ins.length]};
        this.cartesianProductProvider.cartesianProduct(outs, ins, callback, resultTuple);
        return result;
    }

    private Collection<ISynchronizedTransition<T>> retrieveSynchronizedTransitionsOnChannel(C current, int channelID, ScheduledBehaviors scheduled) {
        ArrayList outs = new ArrayList(scheduled.outputs.values());
        List productOuts = CartesianProduct.recursiveCartesianProduct(outs);
        ArrayList ins = new ArrayList(scheduled.inputs.values());
        List productIns = CartesianProduct.recursiveCartesianProduct(ins);
        ArrayList<List> lol = new ArrayList<List>();
        lol.add(productOuts);
        lol.add(productIns);
        List allCombinations = CartesianProduct.recursiveCartesianProduct(lol);
        HashSet<ISynchronizedTransition<T>> result = new HashSet<ISynchronizedTransition<T>>();
        for (List tuple : allCombinations) {
            ISynchronizedTransition<T> synchronizedTransition = this.runtime.newSynchronizedTransitionObject();
            synchronizedTransition.addOutputBehaviors((Collection)tuple.get(0));
            synchronizedTransition.addInputBehaviors((Collection)tuple.get(1));
            result.add(synchronizedTransition);
        }
        return result;
    }

    @Override
    public IFiredTransition<C, ?, ?> fireOneTransition(C currentConfiguration, ISynchronizedTransition<T> transition) {
        HashSet targetConfigurations = new HashSet();
        this.executeSynchronizedBehaviors(currentConfiguration, transition, targetConfigurations);
        return new FiredTransition(currentConfiguration, targetConfigurations, transition);
    }

    private void executeSynchronizedBehaviors(C initialConfiguration, ISynchronizedTransition<T> transition, Set<C> ioResults) {
        if (this.exploreSynchronization) {
            this.executeSynchronizedBehaviorsExploring(initialConfiguration, transition, ioResults);
            return;
        }
        this.executeSynchronizedBehaviorsArbitraryOrder(initialConfiguration, transition, ioResults);
    }

    private void executeSynchronizedBehaviorsArbitraryOrder(C initialConfiguration, ISynchronizedTransition<T> transition, Set<C> ioResults) {
        IFiredTransition<C, ?, ?> fired;
        Object nowConfig = initialConfiguration;
        for (T behavior : transition.getOutputBehaviors()) {
            fired = this.runtime.executeOneTransition(nowConfig, behavior);
            if (fired != null && (nowConfig = fired.getTarget(0)) != null) continue;
            return;
        }
        for (T behavior : transition.getInputBehaviors()) {
            fired = this.runtime.executeOneTransition(nowConfig, behavior);
            if (fired != null && (nowConfig = fired.getTarget(0)) != null) continue;
            return;
        }
        ioResults.add(nowConfig);
    }

    private void executeSynchronizedBehaviorsExploring(C initialConfiguration, ISynchronizedTransition<T> transition, Set<C> ioResults) {
        this.syncExplorer.reset();
        this.syncExplorer.addOutputs(transition.getOutputBehaviors());
        this.syncExplorer.addInputs(transition.getInputBehaviors());
        this.syncExplorer.execute(initialConfiguration, ioResults);
    }

    class ScheduledBehaviors {
        Map<Integer, ArrayList<T>> inputs = new HashMap();
        Map<Integer, ArrayList<T>> outputs = new HashMap();

        ScheduledBehaviors() {
        }
    }
}

