/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.tool.FingerprintException;
import tlc2.value.Enumerable;
import tlc2.value.EnumerableValue;
import tlc2.value.MVPerm;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import util.Assert;

public class SetCapValue
extends EnumerableValue
implements Enumerable {
    public Value set1;
    public Value set2;
    protected SetEnumValue capSet;

    public SetCapValue(Value set1, Value set2) {
        this.set1 = set1;
        this.set2 = set2;
        this.capSet = null;
    }

    @Override
    public final byte getKind() {
        return 18;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.capSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            this.convertAndCache();
            return this.capSet.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            return this.set1.member(elem) && this.set2.member(elem);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            if (!this.set1.isFinite() && !this.set2.isFinite()) {
                Assert.fail("Attempted to check if the set " + SetCapValue.ppr(this.toString()) + "is finite.");
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SetCapValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SetCapValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            this.convertAndCache();
            return this.capSet.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            if (this.capSet == null || this.capSet == DummyEnum) {
                return this.set1.isNormalized() && this.set2.isNormalized();
            }
            return this.capSet.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.capSet == null || this.capSet == DummyEnum) {
                this.set1.normalize();
                this.set2.normalize();
            } else {
                this.capSet.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            return this.set1.isDefined() && this.set2.isDefined();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.capSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        try {
            this.convertAndCache();
            return this.capSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.capSet == null) {
            this.capSet = SetEnumValue.convert(this);
        } else if (this.capSet == DummyEnum) {
            SetEnumValue val = null;
            SetCapValue setCapValue = this;
            synchronized (setCapValue) {
                if (this.capSet == DummyEnum) {
                    val = SetEnumValue.convert(this);
                    val.deepNormalize();
                }
            }
            setCapValue = this;
            synchronized (setCapValue) {
                if (this.capSet == DummyEnum) {
                    this.capSet = val;
                }
            }
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            try {
                if (expand) {
                    SetEnumValue val = SetEnumValue.convert(this);
                    return ((Value)val).toString(sb, offset);
                }
            }
            catch (Throwable val) {
                // empty catch block
            }
            sb = this.set1.toString(sb, offset);
            sb = sb.append(" \\cap ");
            sb = this.set2.toString(sb, offset);
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.capSet == null || this.capSet == DummyEnum) {
                return new Enumerator();
            }
            return this.capSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration enum1;
        Value set;

        public Enumerator() {
            if (SetCapValue.this.set1 instanceof Enumerable) {
                this.enum1 = ((Enumerable)((Object)SetCapValue.this.set1)).elements();
                this.set = SetCapValue.this.set2;
            } else if (SetCapValue.this.set2 instanceof Enumerable) {
                this.enum1 = ((Enumerable)((Object)SetCapValue.this.set2)).elements();
                this.set = SetCapValue.this.set1;
            } else {
                Assert.fail("Attempted to enumerate S \\cap T when neither S:\n" + Value.ppr(SetCapValue.this.set1.toString()) + "\nnor T:\n" + Value.ppr(SetCapValue.this.set2.toString()) + "\nis enumerable");
            }
        }

        @Override
        public final void reset() {
            this.enum1.reset();
        }

        @Override
        public final Value nextElement() {
            Value elem = this.enum1.nextElement();
            while (elem != null) {
                if (this.set.member(elem)) {
                    return elem;
                }
                elem = this.enum1.nextElement();
            }
            return null;
        }
    }
}

