/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.luaj.vm2.lib.ResourceFinder;

public final class MocResourceFinder
implements ResourceFinder {
    private final ResourceFinder parentFinder;
    private List<File> resourcePathList = new ArrayList<File>();

    public MocResourceFinder(ResourceFinder parentFinder) {
        this(parentFinder, null);
    }

    public MocResourceFinder(ResourceFinder parentFinder, Collection<File> resourcePaths) {
        this.parentFinder = parentFinder;
        if (resourcePaths != null) {
            this.resourcePathList.addAll(resourcePaths);
        }
    }

    public InputStream findResource(String filename) {
        try {
            for (File parent : this.resourcePathList) {
                File file = new File(parent, filename);
                if (!file.exists() || !file.isFile()) continue;
                return new FileInputStream(file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return this.parentFinder.findResource(filename);
    }
}

