/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.obs;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.obs.EventWatcher;

public class EventTester {
    private final EventWatcher[] eventWatchers;
    private int currentIndex;
    private int actionsSize;
    private int dispatchedWitdh;
    private BitSet dispatchedEvents;
    private BitSet predicateEventBackup;

    public EventTester(List<EventWatcher> eventWatcherList) {
        this.eventWatchers = new EventWatcher[eventWatcherList.size()];
        Iterator<EventWatcher> iterator = eventWatcherList.iterator();
        while (iterator.hasNext()) {
            EventWatcher eventWatcher;
            this.eventWatchers[eventWatcher.id] = eventWatcher = iterator.next();
        }
    }

    public void dispatch(Configuration source, List<AtomicAction> actions2, Configuration target) {
        this.currentIndex = 0;
        this.actionsSize = actions2.size();
        this.dispatchedWitdh = this.actionsSize + 1;
        this.dispatchedEvents = new BitSet(this.dispatchedWitdh * this.eventWatchers.length);
        this.predicateEventBackup = new BitSet(this.eventWatchers.length);
        for (int i = 0; i < this.actionsSize; ++i) {
            AtomicAction action = actions2.get(i);
            for (int j = 0; j < this.eventWatchers.length; ++j) {
                EventWatcher watcher = this.eventWatchers[j];
                this.dispatchedEvents.set(i + j * this.dispatchedWitdh, watcher.watch(action));
            }
        }
        for (int j = 0; j < this.eventWatchers.length; ++j) {
            boolean watch = this.eventWatchers[j].watch(source, target);
            this.predicateEventBackup.set(j, watch);
            this.dispatchedEvents.set(this.actionsSize + j * this.dispatchedWitdh, watch);
        }
    }

    public void reset() {
        this.currentIndex = 0;
        for (int j = 0; j < this.eventWatchers.length; ++j) {
            boolean watch = this.predicateEventBackup.get(j);
            this.dispatchedEvents.set(this.actionsSize + j * this.dispatchedWitdh, watch);
        }
    }

    public boolean testEvent(short id) {
        int index = this.actionsSize + id * this.dispatchedWitdh;
        boolean result = this.dispatchedEvents.get(index);
        this.dispatchedEvents.set(index, false);
        if (!result && this.currentIndex < this.actionsSize && (result = this.dispatchedEvents.get(index = this.currentIndex + id * this.dispatchedWitdh))) {
            ++this.currentIndex;
        }
        return result;
    }

    public boolean isTheEventAmongstTheActions(short id) {
        int index = this.actionsSize + id * this.dispatchedWitdh;
        boolean result = this.dispatchedEvents.get(index);
        this.dispatchedEvents.set(index, false);
        for (int actionIndex = 0; !result && actionIndex < this.actionsSize; actionIndex = (int)((short)(actionIndex + 1))) {
            index = actionIndex + id * this.dispatchedWitdh;
            result = this.dispatchedEvents.get(index);
        }
        return result;
    }

    public boolean discard() {
        ++this.currentIndex;
        return this.currentIndex < this.actionsSize;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("EventTester {");
        text.append(this.eventWatchers.length);
        text.append(",");
        text.append(this.currentIndex);
        text.append(", ");
        text.append(this.dispatchedEvents);
        text.append("}");
        return text.toString();
    }
}

