/*
 * Decompiled with CFR 0.152.
 */
package obp.cdl.parser;

import beaver.Action;
import beaver.Parser;
import beaver.ParsingTables;
import beaver.Symbol;
import java.util.ArrayList;
import java.util.List;
import obp.LTL.model.Expression;
import obp.LTL.model.FormulaDeclaration;
import obp.cdl.Activity;
import obp.cdl.ActivityDeclaration;
import obp.cdl.AltActivity;
import obp.cdl.CDLDeclaration;
import obp.cdl.Declaration;
import obp.cdl.EventDeclaration;
import obp.cdl.EventReference;
import obp.cdl.Guard;
import obp.cdl.LTLDeclaration;
import obp.cdl.Option;
import obp.cdl.ParActivity;
import obp.cdl.PredicateDeclaration;
import obp.cdl.ProcessId;
import obp.cdl.PropertyDeclaration;
import obp.cdl.RestrictionDeclaration;
import obp.cdl.SeqActivity;
import obp.cdl.VariableDeclaration;
import obp.cdl.parser.CDLParserHelper;
import obp.cdl.parser.CDLParsingReport;
import obp.event.Event;
import obp.event.Message;
import obp.literal.Literal;
import obp.literal.LiteralField;
import obp.obs.Reset;
import obp.obs.Transition;
import obp.obs.When;
import obp.predicate.AtomicAccess;
import obp.predicate.ComparisonOperator;
import obp.predicate.Predicate;
import obp.predicate.SystemAccess;
import obp.property.Arity;
import obp.property.Immediacy;
import obp.property.Nullity;
import obp.property.NullityExpression;
import obp.property.Occurrence;
import obp.property.OccurrenceEvent;
import obp.property.OccurrenceExpression;
import obp.property.Precedency;
import obp.property.PrecedencyExpression;
import obp.property.Property;
import obp.property.Scope;
import obp.property.TempGuard;
import obp.property.TimeConstrain;

public class CDLParser
extends Parser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9oDcWUS5KKIXwlUFAAm0WRY0alEYA8e640Ce28IH5IIIWO9If8aA1a498iAWaWGYGgAYY96JAVdcKzFp#oPpgodr$TLJ#$RsO3dljz$AbVNTFTqzxot8ka7PB9CqhuwNUf97VSVEQHdoW9vLbwH$ygjsbWMILsPAjVBD9akDyYDCaDcIXF9bjkaiLubLILRZvKSELPAI7sfvkNINcua3QMQ7f86SYAPEqXA9iei#LI#recwHWSu9#lbNAskDUKdYtALGfRXP9aiKwGf5VqilyYlyX$vJNwN8#GI6IZNI2JTvE925Tqd1wIKr9B7POTKaMFa37bTkiepafPtPBDqbFFaVBb0jih7ih#Gxr#2RqLy7vJTqa#EbfRuVe0lbKcvK5bVAYiGgttZMBr4tj5UqjFzv7Aa6R5RY2thlHV9STwxZPHnjV0UZdTlMdfBziafyeQyZFT3UEy9zxTHikG1UKpc#xuy5DhEfksSlFxpqUijMZlg4iPhZvJMM$KMsUX6#sYpT$BPYqabNOgzioxNbMHVLTZEU6AN4wHBFdjzRpzJshbhi3EUsXDxWroxLl3jbtDBVVpfnFUJZLegVxoMTjVISt6yvCRxc6nwkR7lpN8oo8$4oSHqrRDb73EcEzbi3fbV0$nECexiZQMlBiIllyxJ1Sor#hhO#nsd9V0pheTS3MVUS#ByEajlzwDrekKdtpZwqiR6l3zYR1feFst1s6Gp2t9aMsQKdmupvCWmGxwK9xMfBC$OtmkpO2RsuephGdbVph6w$DWjpZTsfdaqrb1N$AJC2XvDa9lGVz#3tBdw8xKsuUusehjSBlMr6XgWRo3bYNwGw7LULzNtaS$bziMvfKB8$IBoBaRZPNbUtZPEsyaUzw3NRMHSRBHMvtBq$KPvnElCivMyAazupspiESaOtPI9peRByPpTqyZGxdEqoogYbulJaxpb$aH5rdjMaVLUFsrBxxwcmtK4NeCAzTgrGRCln1biL4g2hiouyVv#NmrzkoJsya#3PU#1fgikqUjCux4KJNLx6hnKGVw6fXmmZM6XdezaiykanSXBt4DUDl$5SfGMPwHVr3b#f5zcTYt6lmwo#IzXLA#J2Rvzcu4v5ezF9jwtVqzk#x9IbidhFA5$pOlNQlYORopNqjhaCDboLCQs6AqzpJNY#t7TDSlx7abxDVt8pSBBuinhZzUSJayrywFqOgoX$pTozpQMvMIFDjUKLcCaQsT6ibNezpAXtstMMxzlPzPtrJQwpw$RbKE$buwzt7#bkVUwJtOoEftq4KRVrXZBq5aRUPlnbRLIXh#GjSXuyxj8lc8jskNNfxsor7Ikkr#VLieNLDoA#XBLw6wgkT1BXaUHdWAvyj$Xturbxkzg#IUyjTA9gZh77DbZRhnU01SYTPViqBrucxsJjniwQnLVoNSwJYTeLKrhCJr6MpFwz9vMrEEqiMxNkcwQDj0JjANkyDUJzHJiBRI2Dj9JcMkDzGmtMKzpa$GYTjwgxZetKRkvOTf7#xeRoTFUJT7ssbzMwbHeUnthMxjU1wDPxwQmtl#eT#e6lKjQw6OvNbf96ntbNf3MSfgqbLEblPmbPxlVtMzocVIIFj9Rhf0hvIfzIX$N0tgl3931UfyCaQ4oJ4R8I1cbEsMqZ96nxXVtg$jPhfNPCaVcoaAP9pV9OhcPSLZ2ph12Rf4rV6wNjNA7t2aRv2xPn8vvjzmhzyj1ULXUa9Va7$Avl2aVoYVih9$93$8l8hy1$vPlzMYts2ro2zrDRe6Rx#QfkjaQkMwkgvPqixIC7g5bwSloij3DrAFSHPej2xM6wymrHvleyQwFwuszdkjF7onmLxahjRusT3FqR3rBpzMBjOEUfvtqGksiNTrmv2xQNI$5UevUfbUuCMw2NeaqK8Vo6QB3TBHUuwQJVOnEqcawMQVeZR9ARz0PEfldSQxErvjqaTwiotI5hjBLUfkkrIsw3fyxz6dThrlrRdr2xz77T9lkSGVr0NrOzxldtUFw45aFKkL2VT9Vdv45#gm#vpxs9vSHd5nwCIx2ypL6AajfpZSJEDjCP6uFzZs#X3vVnbwpWjccd9xASvQPwxcHSCNORygm0feytij7SMefoIvG4OrbtisODEViqOBvSGBFjR233kP9wIpt#AY38KiZegoYR2hQn$dd8KPnFtk0CgjEveJIXQUuMw6A#h2dMolCAlRfAvXpWwG$CseWCseuPmO$0vbJrp2N2lhMokVR4Di2AejzhJ8DbGscieAn8nAnOrXdXJwR5M9tUEzIp5hpLjQb2Ez6UC$5sp9NzfbZxrBX$ifI#v6SG2BlqI2qdQBjTAB$p7QIjzq9NvdeYxnVMLOzYpPx2M#taQo0FOlrx5ZirOkmgxUdMQkJzZBUVe3LrrPI6q$5NZ5Zh#BjsKHP$2AaNjX75eWVJ$JW43yb4r$5UmpsCRtXh$EzkOkO$aW3lRPNQ3D5J9gLD7Uk3VPxm2nV#NYuBE#taEmLFJUJR1MzTzMGlmOrMlxvFd#A$6a$DkPjOrEHq$0jZ4sAiKapDWL7UK5YbBUHlw0z2lOIs6k57atv7iqREzFS63HLmvDI8yZgvJJl3#dCN9rDhGfkHrU7TnwhrL0HNKLwFSKgbsOrJFQHvOf2xZBvSgSyNzvpDXlYsLKMpaPZPuQp4IwV6S6It5TZpwMmf$F5hCbmfajdOkQ4TcSGRJtHYFDZ4s#vFr6HzPxnrdjjE4$sPuG6Ug$DXNhj$8GcdXUzVPoXFst7SOCEatqUcdXEcSPG0Kdzqs1I5IgjuC#dfZd6dp0s85dj9cKXA$rbilbd4T7Iwwe6NGrq5Rni$efiOn9NR3EmXDVbnPjluqpxmtax68HkI2A#FhBPOdaixmSbl6mv9cFB2lL7uNuYVrevbhkewcUDpQmAFiwqfRncCZqLXL4g5MP4MU9CauscFEyuzT5CJOn#tACveKTjrlUBTsvwT6JezvpWDJvu2JdDoxpxK$T0Hj$gDbiMDPdD#FuoAS6NyBpvzQVAhB0#sTLqaL#VhAVAqigHHLHZai4aGr5oFJ8QRndj7IShS57WEh9IPHMAD7i9RpTaoQXGoUcyqu$p8zsJjo7rlJU15MOYxy$d87VWvDEEMBjUm8cjdjZvVom#sVYCmZB9FuKZo1BnkSpll2FWwZCM4HZZsodlFzRQT6YigSpgi5fkbTlWrh8UMfxMd9GNmIihK35eJR6$NlvJbr5IjFTnRjtBURKcAqfhh#y5P$IImCL$v#9ToUzyG$spOlmgTeR8wvHLfvPVOIlHKobsJ6j$5JFFra6RsvLyhqLugO#f3gtkiwpp#hoFzKDEXjikJSEgPt5ba8Rw6fhwQzosVLhwlREoNvTEv1FtutgkrVZSvMTE6NzjoFC$5ThCvwm6R0tSvBFCGHlByNr6laAhTWidqW4yImEA#2WdpPI$cmQSRciJrHt#OdILu7kmnfksjiyxb1hpNwq5qUUdnVrS7BG1RJasr4U$9UZh1heKT0ty8h00dxQnhFl1FqHIKqtE1RhTN3w2FfZKnxOKvvFKM#3jXFzCBfKIFbyN4VTVBitmPKv5MR4kUXBvG7u$pdWIlHlu3V3l1z#dy3sOvnTz33vCrF0yydE1Rrsm$OJVUu5#Mg3TbuZ$0feD$HBxXM0R61VyRqHF6xezKSFBu5lmDNgJtmo#tU1VWxu9VODxBnVqGv7VHguE$JkqOyXp4Bo7l3N8Z6TgHLuxQSOuNKBicoP9bppSlINyIv7ZEsXfK0R5Cq6VbV0v4fzVeA6sw4SkDo5NIFWS3Ow5AHtaYi7tP$XqmgygA4RDOPwbwKFUbeIJjwIhnxgKpJtQqsz2Zjnx$mcVd4IVNb1WN3uZXlj9rmfzYB$#a6YxKj1$22g3NnEnkMF#LQXXTOWv0jGBElAbQeDMHVHZxP2d3$RG1odhjz$9sJ38HmVV1ecuO4it1UK1ypvz5BvrY3qxs5g0Qk04S0nwThrqav2Jlaot12U2aq0hS38u1RIcRUP#QW0npD7qgQ06$7pewU0CxAmFaOrbkz0M$P9k4t8$awZpD50Jj0LMMmViz6EKHZuNVZru5xv3yE$edFi6QksU2Rg0zecnkmgvBcWK$1idskgAVJZvlWs#8uE#Uw0NWnw1xucT#qjV3jXFebj1P$XBeEl05FW#YNOVGBuYn9x5$TkyFG$XEUZve3y#Gm3hNVfAC2JudWtw0cjhUFwnvnrVU5UIz21mAJdfZyZcyoZe8o7#MZ0GZ0NZqJyAji2pHaPFG2S6FsfFCTxH22ZrHKy7lTq7klJr05Lq88nH9tXof$f19s2x0LmDPW1RGvP1fuSSCqEzhEEw9iHRJQEXeOzJnay7v4hD1Oi1#qAAzIGLzelKpa0V2FIfG5y4z6EAvrbpd#yLWFKmlH9C1cF01O2wqzISleWQ7uDE0hU56DfDCtQfJx1jXRUvzKrYVim2x4qfMvDcXt6rTMmEycemBEXuPg9vYJZBjJpmsy6gmEy2p9lqVM0Ds6Dwvc$eDoaPKpqZqD#IunzyVm#sOWLjIV2NkyQz$aT#UVwfkUJU$ETyfLP#EPfGmBwiWBr7WY#mhqldXEs6n7s##WUrlXFe1mLoXJLLFWWqh5tHaa2N1fgllaJygmd#KF2z8z3rGP#xLsm8T5E1UzrokBh3VJtxH$QYwuhR#WFxf9YcsEFrgC9sxPBmNV1$SXt8uuKrLquka8jzDBKtjFV2ONBCpo$pVf0Ov#2JBZfM6sChNeH#KuXxjB0jTLdmAVIy56YpJA3XhATX$ucE$gEuH3kV4jFyCBdPL$MiN9bnBdAE9VoNSs6FY5uisYws9hrI86RbdwcJjdV5zQHOxrANsnayaUF3G3yEzBC$apDHr#U9N5N$V5pg7lmv1qJju6rVEg#8FacSeQA3eRrJOweV1VtZXsyZ#gW8tRU9seyBkYu5$OA#Pw1$fRsrWVy#pwxX7I3rUz7nwSJxHdpcmxTi4UrS0RebvFT2VDr4hd0MZCzmYVDRldDCxlaiy4q3RHPeyq33VQTR7EQ#XyRZaWiz7d0EYDhQkRgmVzxzOszOHBx46IjUAqBxTOBkK7x$v7ajVKw2xrWujxrJvVqvTdXthkSuDpdEewwLEz7BBTr9xgpWTRuxnvtfsWMfYgliQLl7V7GDNGDNtzLpTLqThwtjbd1jZjpCopNzjQc$DdPDkDPmsQwwbnk1qzrfxbJNnhLsd8GT9ppNqRLt7IJVdxizq5lTieJsva1l0wiJ#bl0Ah3IIolSyepbH$U3#zvzvxvr$tRVkAyJCL#1QgvgaBvqNtYwnlqhQ3ZJk#CzTvnh4NHlPA8V3PGLoUrml6EwhOudrjtjjhZDmRRVNtSxJZHkPz3jSPnbt2Pm5rZlTNS4smQtpgrrTy9jz1bt1VrUS2zusDtFzP6WZUlzF5ToWxb#9eN#tDp2aflZhvpytOMkK#4OR#qPQ0zmiUlbBWdoPU1ITtcGE7KxdaxNrqlzYimqo0tqT7n2TtM66vkhSQFS23UoKFIu8Z9Ud#7ET5CJUixOZcVJ3Gbot2liGkuJBty4E6CxteVSEu3tTyUxl7lBVSZr0$1Fy3vup$k$cSdpkdlLlU9UTdy9ckVorVEOEv3XEMkx9zrBN9y6JxYd7AkZUyRzZUiXznhNPpE1dyX1KP3AW746Ahl1DEHfqEl$3nPBSRbPqc9zUZNoKYaXoy1oi88SDqWaMu1zPpK0EJ#Yms89EUqfMqqSft2WmfC7LEpvl1tAgHoeh8MkXQxq$rsKaZrWh$zj8W8gz$jVFLBiu97S8SLaAtGh#ZxmVIGT4Carw78n6jreT37DvOl9jL33LUIxqaEbRmOHI0Me38CEyx$dH04gCv1dG0VvxoaZMKNkcHaKJo0LT977TSJmXWFiTwhYCXsx$MPP5DWDWCe#uX#aveUaf3mC7Y7FHh39GsGpTBF$3hAOx8Vk9sUCIEQ2CHxshUOHiXxULWpxfOzLGZOWRu2Vvo5o5pAhYimcFeR8Eco62TGn4JhH$xzRIhRXkmrvFlmjKCCa#4d#TuOqY6Io$xL0PHooWRTc$#siOIGOxt$ZJSdsW87eyaFzhspsgqi$v7xvgFhVovAmxsUJw8rkXuVA0e#q30SxqUtqtpv7ij13PHTq5tGHz02mxx#BXls2AFvNHECvyO6O7qgSVV$RI#pNGfN7$mSL$QOY");
    static final Action RETURN2 = new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return _symbols[offset + 2];
        }
    };
    private final CDLParserHelper helper = new CDLParserHelper();
    private final Action[] actions = new Action[]{Action.RETURN, RETURN2, RETURN2, RETURN2, Action.NONE, Action.RETURN, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_ds = _symbols[offset + 1];
            List ds = (List)_symbol_ds.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createCdlUnit(ds));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_d = _symbols[offset + 1];
            Declaration d = (Declaration)_symbol_d.value;
            Symbol _symbol_ds = _symbols[offset + 2];
            List ds = (List)_symbol_ds.value;
            return CDLParser.this.addToList(ds, d);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_d = _symbols[offset + 1];
            Declaration d = (Declaration)_symbol_d.value;
            return CDLParser.this.list(d);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_d = _symbols[offset + 1];
            VariableDeclaration d = (VariableDeclaration)_symbol_d.value;
            return CDLParser.this.symbol(d);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_d = _symbols[offset + 1];
            EventDeclaration d = (EventDeclaration)_symbol_d.value;
            return CDLParser.this.symbol(d);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_d = _symbols[offset + 1];
            ActivityDeclaration d = (ActivityDeclaration)_symbol_d.value;
            return CDLParser.this.symbol(d);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_d = _symbols[offset + 1];
            PredicateDeclaration d = (PredicateDeclaration)_symbol_d.value;
            return CDLParser.this.symbol(d);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_d = _symbols[offset + 1];
            PropertyDeclaration d = (PropertyDeclaration)_symbol_d.value;
            return CDLParser.this.symbol(d);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_d = _symbols[offset + 1];
            RestrictionDeclaration d = (RestrictionDeclaration)_symbol_d.value;
            return CDLParser.this.symbol(d);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_d = _symbols[offset + 1];
            FormulaDeclaration d = (FormulaDeclaration)_symbol_d.value;
            LTLDeclaration ltl = new LTLDeclaration();
            ltl.setName(d.getName());
            ltl.setIs(d);
            return CDLParser.this.symbol(ltl);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_d = _symbols[offset + 1];
            CDLDeclaration d = (CDLDeclaration)_symbol_d.value;
            return CDLParser.this.symbol(d);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 2];
            String n = (String)_symbol_n.value;
            Symbol _symbol_vs = _symbols[offset + 5];
            List vs = (List)_symbol_vs.value;
            Symbol e = _symbols[offset + 6];
            return CDLParser.this.symbol(CDLParser.this.helper.createVariableDeclaration(n, vs));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 2];
            String n = (String)_symbol_n.value;
            Symbol _symbol_e = _symbols[offset + 4];
            Event e = (Event)_symbol_e.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createEventDeclaration(n, e));
        }
    }, Action.NONE, Action.RETURN, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 2];
            String n = (String)_symbol_n.value;
            Symbol _symbol_os = _symbols[offset + 5];
            List os = (List)_symbol_os.value;
            Symbol _symbol_s = _symbols[offset + 6];
            Predicate s = (Predicate)_symbol_s.value;
            CDLParser.this.helper.updateOption(s, (List<Option>)os);
            return CDLParser.this.symbol(CDLParser.this.helper.createPredicateDeclaration(n, s));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 2];
            String n = (String)_symbol_n.value;
            Symbol _symbol_os = _symbols[offset + 5];
            List os = (List)_symbol_os.value;
            Symbol _symbol_p = _symbols[offset + 6];
            Property p = (Property)_symbol_p.value;
            CDLParser.this.helper.updateOption(p, (List<Option>)os);
            return CDLParser.this.symbol(CDLParser.this.helper.createPropertyDeclaration(n, p));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 2];
            String n = (String)_symbol_n.value;
            Symbol _symbol_os = _symbols[offset + 5];
            List os = (List)_symbol_os.value;
            Symbol _symbol_p = _symbols[offset + 6];
            Property p = (Property)_symbol_p.value;
            CDLParser.this.helper.updateOption(p, (List<Option>)os);
            return CDLParser.this.symbol(CDLParser.this.helper.createRestrictionDeclaration(n, p));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(CDLParser.this.helper.ltlContext());
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 2];
            String n = (String)_symbol_n.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createLTLDeclaration(n));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_f = _symbols[offset + 2];
            Expression f = (Expression)_symbol_f.value;
            CDLParser.this.helper.ltlContext().setExpression(f);
            return CDLParser.this.symbol(CDLParser.this.helper.ltlContext());
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 1];
            String n = (String)_symbol_n.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createAtomReference(n));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_e = _symbols[offset + 2];
            Expression e = (Expression)_symbol_e.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createEventually(e));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_e = _symbols[offset + 2];
            Expression e = (Expression)_symbol_e.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createGlobally(e));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_e = _symbols[offset + 2];
            Expression e = (Expression)_symbol_e.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createNext(e));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_s = _symbols[offset + 2];
            Expression s = (Expression)_symbol_s.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createNegation(s));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_lhs = _symbols[offset + 1];
            Expression lhs = (Expression)_symbol_lhs.value;
            Symbol _symbol_rhs = _symbols[offset + 3];
            Expression rhs = (Expression)_symbol_rhs.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createRelease(lhs, rhs));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_lhs = _symbols[offset + 1];
            Expression lhs = (Expression)_symbol_lhs.value;
            Symbol _symbol_rhs = _symbols[offset + 3];
            Expression rhs = (Expression)_symbol_rhs.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createUntil(lhs, rhs));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Expression l = (Expression)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            Expression r = (Expression)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createConjunction(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Expression l = (Expression)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            Expression r = (Expression)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createDisjunction(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Expression l = (Expression)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            Expression r = (Expression)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createImplication(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Expression l = (Expression)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            Expression r = (Expression)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createEquivalence(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_e = _symbols[offset + 2];
            Expression e = (Expression)_symbol_e.value;
            return CDLParser.this.symbol(e);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 2];
            String n = (String)_symbol_n.value;
            Symbol _symbol_a = _symbols[offset + 4];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createActivityDeclaration(n, a));
        }
    }, Action.NONE, Action.RETURN, Action.NONE, Action.RETURN, Action.NONE, Action.RETURN, Action.NONE, Action.RETURN, Action.NONE, Action.RETURN, Action.NONE, Action.RETURN, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 2];
            String n = (String)_symbol_n.value;
            Symbol _symbol_os = _symbols[offset + 5];
            List os = (List)_symbol_os.value;
            Symbol _symbol_ltl = _symbols[offset + 6];
            List ltl = (List)_symbol_ltl.value;
            Symbol _symbol_rs = _symbols[offset + 7];
            List rs = (List)_symbol_rs.value;
            Symbol _symbol_ps = _symbols[offset + 8];
            List ps = (List)_symbol_ps.value;
            Symbol _symbol_as = _symbols[offset + 9];
            List as = (List)_symbol_as.value;
            Symbol _symbol_f = _symbols[offset + 10];
            Predicate f = (Predicate)_symbol_f.value;
            Symbol _symbol_i = _symbols[offset + 11];
            Activity i = (Activity)_symbol_i.value;
            Symbol _symbol_m = _symbols[offset + 12];
            ParActivity m = (ParActivity)_symbol_m.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createCdlDeclaration(n, ltl, rs, ps, as, f, i, m, os));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_is = _symbols[offset + 2];
            List is = (List)_symbol_is.value;
            return CDLParser.this.symbol(is);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_is = _symbols[offset + 2];
            List is = (List)_symbol_is.value;
            return CDLParser.this.symbol(is);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_is = _symbols[offset + 2];
            List is = (List)_symbol_is.value;
            return CDLParser.this.symbol(is);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_as = _symbols[offset + 1];
            List as = (List)_symbol_as.value;
            Symbol _symbol_a = _symbols[offset + 3];
            Predicate a = (Predicate)_symbol_a.value;
            return CDLParser.this.addToList(as, a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            Predicate a = (Predicate)_symbol_a.value;
            return CDLParser.this.list(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 2];
            Predicate p = (Predicate)_symbol_p.value;
            return CDLParser.this.symbol(p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 2];
            Predicate p = (Predicate)_symbol_p.value;
            return CDLParser.this.symbol(p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 3];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 4];
            List p = (List)_symbol_p.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createParActivity(p));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_as = _symbols[offset + 1];
            List as = (List)_symbol_as.value;
            Symbol _symbol_a = _symbols[offset + 3];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.addToList(as, a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.list(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_os = _symbols[offset + 3];
            List os = (List)_symbol_os.value;
            Symbol _symbol_a = _symbols[offset + 4];
            Activity a = (Activity)_symbol_a.value;
            CDLParser.this.helper.updateOption(a, (List<Option>)os);
            a.setAtomic(true);
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 3];
            Activity a = (Activity)_symbol_a.value;
            a.setAtomic(true);
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_os = _symbols[offset + 2];
            List os = (List)_symbol_os.value;
            Symbol _symbol_a = _symbols[offset + 3];
            Activity a = (Activity)_symbol_a.value;
            CDLParser.this.helper.updateOption(a, (List<Option>)os);
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 2];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            AltActivity a = (AltActivity)_symbol_a.value;
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            SeqActivity a = (SeqActivity)_symbol_a.value;
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createSeqActivity(a));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_as = _symbols[offset + 1];
            AltActivity as = (AltActivity)_symbol_as.value;
            Symbol _symbol_g = _symbols[offset + 3];
            Guard g = (Guard)_symbol_g.value;
            Symbol _symbol_a = _symbols[offset + 4];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.symbol(CDLParser.this.helper.addActivityToAltActivity(as, g, a));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_as = _symbols[offset + 1];
            AltActivity as = (AltActivity)_symbol_as.value;
            Symbol _symbol_a = _symbols[offset + 3];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.symbol(CDLParser.this.helper.addActivityToAltActivity(as, null, a));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_g1 = _symbols[offset + 1];
            Guard g1 = (Guard)_symbol_g1.value;
            Symbol _symbol_a1 = _symbols[offset + 2];
            Activity a1 = (Activity)_symbol_a1.value;
            Symbol _symbol_a2 = _symbols[offset + 4];
            Activity a2 = (Activity)_symbol_a2.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createAltActivity(g1, a1, null, a2));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a1 = _symbols[offset + 1];
            Activity a1 = (Activity)_symbol_a1.value;
            Symbol _symbol_g2 = _symbols[offset + 3];
            Guard g2 = (Guard)_symbol_g2.value;
            Symbol _symbol_a2 = _symbols[offset + 4];
            Activity a2 = (Activity)_symbol_a2.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createAltActivity(null, a1, g2, a2));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a1 = _symbols[offset + 1];
            Activity a1 = (Activity)_symbol_a1.value;
            Symbol _symbol_a2 = _symbols[offset + 3];
            Activity a2 = (Activity)_symbol_a2.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createAltActivity(null, a1, null, a2));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_g1 = _symbols[offset + 1];
            Guard g1 = (Guard)_symbol_g1.value;
            Symbol _symbol_a1 = _symbols[offset + 2];
            Activity a1 = (Activity)_symbol_a1.value;
            Symbol _symbol_g2 = _symbols[offset + 4];
            Guard g2 = (Guard)_symbol_g2.value;
            Symbol _symbol_a2 = _symbols[offset + 5];
            Activity a2 = (Activity)_symbol_a2.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createAltActivity(g1, a1, g2, a2));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_s = _symbols[offset + 1];
            SeqActivity s = (SeqActivity)_symbol_s.value;
            Symbol _symbol_a = _symbols[offset + 3];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.symbol(CDLParser.this.helper.addActivityToSeqActivity(s, a));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a1 = _symbols[offset + 1];
            Activity a1 = (Activity)_symbol_a1.value;
            Symbol _symbol_a2 = _symbols[offset + 3];
            Activity a2 = (Activity)_symbol_a2.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createSeqActivity(a1, a2));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 2];
            Integer i = (Integer)_symbol_i.value;
            return CDLParser.this.symbol(i);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Integer l = (Integer)_symbol_l.value;
            Symbol _symbol_a = _symbols[offset + 2];
            Activity a = (Activity)_symbol_a.value;
            a.setLoop(l);
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 1];
            String i = (String)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createActivityReference(i));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            Activity a = (Activity)_symbol_a.value;
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            String a = (String)_symbol_a.value;
            Symbol _symbol_v = _symbols[offset + 3];
            String v = (String)_symbol_v.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createAssignment(a, v));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 2];
            String i = (String)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createEventReference(i));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_e = _symbols[offset + 2];
            Event e = (Event)_symbol_e.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createAnonymousEvent(e));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(CDLParser.this.helper.createNullActivity());
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_g = _symbols[offset + 1];
            Guard g = (Guard)_symbol_g.value;
            return CDLParser.this.symbol(g);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(null);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Guard l = (Guard)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            Guard r = (Guard)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createAndGuard(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Guard l = (Guard)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            Guard r = (Guard)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createOrGuard(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            Guard a = (Guard)_symbol_a.value;
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 2];
            Guard a = (Guard)_symbol_a.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createNotGuard(a));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            Guard a = (Guard)_symbol_a.value;
            return CDLParser.this.symbol(a);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            String l = (String)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            String r = (String)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createAtomicGuard(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_g = _symbols[offset + 2];
            Guard g = (Guard)_symbol_g.value;
            return CDLParser.this.symbol(g);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_os = _symbols[offset + 2];
            List os = (List)_symbol_os.value;
            Symbol _symbol_e = _symbols[offset + 3];
            Event e = (Event)_symbol_e.value;
            CDLParser.this.helper.updateOption(e, (List<Option>)os);
            return CDLParser.this.symbol(e);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 2];
            Message l = (Message)_symbol_l.value;
            Symbol _symbol_t = _symbols[offset + 4];
            ProcessId t = (ProcessId)_symbol_t.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createOutput(l, CDLParser.this.helper.createEnvPid(), t));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 2];
            Message l = (Message)_symbol_l.value;
            Symbol _symbol_f = _symbols[offset + 4];
            ProcessId f = (ProcessId)_symbol_f.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createInput(l, f, CDLParser.this.helper.createEnvPid()));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 2];
            Message l = (Message)_symbol_l.value;
            Symbol _symbol_f = _symbols[offset + 4];
            ProcessId f = (ProcessId)_symbol_f.value;
            Symbol _symbol_t = _symbols[offset + 6];
            ProcessId t = (ProcessId)_symbol_t.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createOutput(l, f, t));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 2];
            Message l = (Message)_symbol_l.value;
            Symbol _symbol_f = _symbols[offset + 4];
            ProcessId f = (ProcessId)_symbol_f.value;
            Symbol _symbol_t = _symbols[offset + 6];
            ProcessId t = (ProcessId)_symbol_t.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createInput(l, f, t));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_m = _symbols[offset + 2];
            Message m = (Message)_symbol_m.value;
            Symbol _symbol_f = _symbols[offset + 4];
            ProcessId f = (ProcessId)_symbol_f.value;
            Symbol _symbol_t = _symbols[offset + 6];
            ProcessId t = (ProcessId)_symbol_t.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createSynchronous(m, f, t));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 2];
            String l = (String)_symbol_l.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createInformal(l, null));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 2];
            String l = (String)_symbol_l.value;
            Symbol _symbol_f = _symbols[offset + 4];
            ProcessId f = (ProcessId)_symbol_f.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createInformal(l, f));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            Predicate p = (Predicate)_symbol_p.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPredicateEvent(p, true));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            Predicate p = (Predicate)_symbol_p.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPredicateEvent(p, false));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Literal l = (Literal)_symbol_l.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createValue(l));
        }
    }, Action.NONE, Action.RETURN, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            ProcessId p = (ProcessId)_symbol_p.value;
            Symbol _symbol_n = _symbols[offset + 3];
            String n = (String)_symbol_n.value;
            Symbol _symbol_as = _symbols[offset + 5];
            List as = (List)_symbol_as.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createSignal(p, n, as));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_s = _symbols[offset + 1];
            Scope s = (Scope)_symbol_s.value;
            Symbol _symbol_p = _symbols[offset + 2];
            Property p = (Property)_symbol_p.value;
            CDLParser.this.helper.updateScope(p, s);
            return CDLParser.this.symbol(p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            Property p = (Property)_symbol_p.value;
            return CDLParser.this.symbol(p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            Property p = (Property)_symbol_p.value;
            return CDLParser.this.symbol(p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            Property p = (Property)_symbol_p.value;
            return CDLParser.this.symbol(p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            Property p = (Property)_symbol_p.value;
            return CDLParser.this.symbol(p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            Property p = (Property)_symbol_p.value;
            return CDLParser.this.symbol(p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            Property p = (Property)_symbol_p.value;
            return CDLParser.this.symbol(p);
        }
    }, Action.NONE, Action.RETURN, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_oe = _symbols[offset + 1];
            OccurrenceExpression oe = (OccurrenceExpression)_symbol_oe.value;
            Symbol _symbol_time = _symbols[offset + 3];
            TempGuard time = (TempGuard)_symbol_time.value;
            Symbol _symbol_r = _symbols[offset + 4];
            Boolean r = (Boolean)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPropertyExistence(oe, time, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_oe = _symbols[offset + 1];
            OccurrenceExpression oe = (OccurrenceExpression)_symbol_oe.value;
            Symbol _symbol_time = _symbols[offset + 4];
            TempGuard time = (TempGuard)_symbol_time.value;
            Symbol _symbol_r = _symbols[offset + 5];
            Boolean r = (Boolean)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPropertyAbsence(oe, time, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_pre = _symbols[offset + 1];
            OccurrenceExpression pre = (OccurrenceExpression)_symbol_pre.value;
            Symbol _symbol_i = _symbols[offset + 2];
            Immediacy i = (Immediacy)((Object)_symbol_i.value);
            Symbol _symbol_time = _symbols[offset + 4];
            TempGuard time = (TempGuard)_symbol_time.value;
            Symbol _symbol_post = _symbols[offset + 5];
            OccurrenceExpression post = (OccurrenceExpression)_symbol_post.value;
            Symbol _symbol_ns = _symbols[offset + 6];
            List ns = (List)_symbol_ns.value;
            Symbol _symbol_ps = _symbols[offset + 7];
            List ps = (List)_symbol_ps.value;
            Symbol _symbol_r = _symbols[offset + 8];
            Boolean r = (Boolean)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPropertyResponse(time, i, r, pre, post, ns, ps));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_pre = _symbols[offset + 1];
            OccurrenceExpression pre = (OccurrenceExpression)_symbol_pre.value;
            Symbol _symbol_i = _symbols[offset + 2];
            Immediacy i = (Immediacy)((Object)_symbol_i.value);
            Symbol _symbol_time = _symbols[offset + 4];
            TempGuard time = (TempGuard)_symbol_time.value;
            Symbol _symbol_post = _symbols[offset + 5];
            OccurrenceExpression post = (OccurrenceExpression)_symbol_post.value;
            Symbol _symbol_ns = _symbols[offset + 6];
            List ns = (List)_symbol_ns.value;
            Symbol _symbol_ps = _symbols[offset + 7];
            List ps = (List)_symbol_ps.value;
            Symbol _symbol_r = _symbols[offset + 8];
            Boolean r = (Boolean)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPropertyPrecedence(time, i, r, pre, post, ns, ps));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            List a = (List)_symbol_a.value;
            Symbol _symbol_s = _symbols[offset + 2];
            String s = (String)_symbol_s.value;
            Symbol _symbol_ts = _symbols[offset + 3];
            List ts = (List)_symbol_ts.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPropertyBuchi(a, s, ts));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_il = _symbols[offset + 2];
            List il = (List)_symbol_il.value;
            return CDLParser.this.symbol(il);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_id = _symbols[offset + 2];
            String id = (String)_symbol_id.value;
            return CDLParser.this.symbol(id);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(null);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_ts = _symbols[offset + 1];
            List ts = (List)_symbol_ts.value;
            Symbol _symbol_t = _symbols[offset + 3];
            obp.buchi.Transition t = (obp.buchi.Transition)_symbol_t.value;
            return CDLParser.this.addToList(ts, t);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_t = _symbols[offset + 1];
            obp.buchi.Transition t = (obp.buchi.Transition)_symbol_t.value;
            return CDLParser.this.list(t);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_source = _symbols[offset + 1];
            String source = (String)_symbol_source.value;
            Symbol _symbol_guard = _symbols[offset + 3];
            Predicate guard = (Predicate)_symbol_guard.value;
            Symbol _symbol_target = _symbols[offset + 5];
            String target = (String)_symbol_target.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createBuchiTransition(source, guard, target));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_ts = _symbols[offset + 1];
            List ts = (List)_symbol_ts.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPropertyObserver(null, ts));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_ts = _symbols[offset + 2];
            List ts = (List)_symbol_ts.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createSynchronousPropertyObserver(null, ts));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_c = _symbols[offset + 1];
            String c = (String)_symbol_c.value;
            Symbol _symbol_ts = _symbols[offset + 2];
            List ts = (List)_symbol_ts.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPropertyObserver(c, ts));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_c = _symbols[offset + 2];
            String c = (String)_symbol_c.value;
            Symbol _symbol_ts = _symbols[offset + 3];
            List ts = (List)_symbol_ts.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createSynchronousPropertyObserver(c, ts));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 2];
            String n = (String)_symbol_n.value;
            return CDLParser.this.symbol(n);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_ts = _symbols[offset + 1];
            List ts = (List)_symbol_ts.value;
            Symbol _symbol_t = _symbols[offset + 3];
            Transition t = (Transition)_symbol_t.value;
            return CDLParser.this.addToList(ts, t);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_t = _symbols[offset + 1];
            Transition t = (Transition)_symbol_t.value;
            return CDLParser.this.list(t);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_source = _symbols[offset + 1];
            String source = (String)_symbol_source.value;
            Symbol _symbol_when = _symbols[offset + 3];
            When when = (When)_symbol_when.value;
            Symbol _symbol_guard = _symbols[offset + 5];
            Predicate guard = (Predicate)_symbol_guard.value;
            Symbol _symbol_events = _symbols[offset + 7];
            List events = (List)_symbol_events.value;
            Symbol _symbol_reset = _symbols[offset + 9];
            Reset reset = (Reset)_symbol_reset.value;
            Symbol _symbol_target = _symbols[offset + 11];
            String target = (String)_symbol_target.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createTransition(source, when, guard, events, reset, target));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_c = _symbols[offset + 1];
            String c = (String)_symbol_c.value;
            Symbol _symbol_t = _symbols[offset + 2];
            ComparisonOperator t = (ComparisonOperator)((Object)_symbol_t.value);
            Symbol _symbol_i = _symbols[offset + 3];
            Integer i = (Integer)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createWhen(c, t, i));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(null);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_guard = _symbols[offset + 1];
            Predicate guard = (Predicate)_symbol_guard.value;
            return CDLParser.this.symbol(guard);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(null);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_ts = _symbols[offset + 1];
            List ts = (List)_symbol_ts.value;
            Symbol _symbol_t = _symbols[offset + 3];
            EventReference t = (EventReference)_symbol_t.value;
            return CDLParser.this.addToList(ts, t);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_t = _symbols[offset + 1];
            EventReference t = (EventReference)_symbol_t.value;
            return CDLParser.this.list(t);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_event = _symbols[offset + 1];
            String event = (String)_symbol_event.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createEventReference(event));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(null);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_c = _symbols[offset + 1];
            String c = (String)_symbol_c.value;
            Symbol _symbol_i = _symbols[offset + 3];
            Integer i = (Integer)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createReset(c, i));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(null);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_s = _symbols[offset + 2];
            Predicate s = (Predicate)_symbol_s.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createScope(true, s));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_s = _symbols[offset + 2];
            Predicate s = (Predicate)_symbol_s.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createScope(false, s));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(null);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)Immediacy.Immediately);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)Immediacy.Eventually);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_o = _symbols[offset + 1];
            Occurrence o = (Occurrence)((Object)_symbol_o.value);
            Symbol _symbol_os = _symbols[offset + 3];
            List os = (List)_symbol_os.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createOccurrenceExpression(os, o));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)Occurrence.An);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)Occurrence.AllOrdered);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)Occurrence.AllCombined);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_os = _symbols[offset + 1];
            List os = (List)_symbol_os.value;
            Symbol _symbol_o = _symbols[offset + 3];
            OccurrenceEvent o = (OccurrenceEvent)_symbol_o.value;
            return CDLParser.this.addToList(os, o);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_o = _symbols[offset + 1];
            OccurrenceEvent o = (OccurrenceEvent)_symbol_o.value;
            return CDLParser.this.list(o);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            Arity a = (Arity)((Object)_symbol_a.value);
            Symbol _symbol_i = _symbols[offset + 2];
            String i = (String)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createOccurrenceEvent(i, a));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)Arity.ExactlyOne);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)Arity.OneOrMore);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_ns = _symbols[offset + 1];
            List ns = (List)_symbol_ns.value;
            Symbol _symbol_n = _symbols[offset + 2];
            NullityExpression n = (NullityExpression)_symbol_n.value;
            return CDLParser.this.addToList(ns, n);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 1];
            NullityExpression n = (NullityExpression)_symbol_n.value;
            return CDLParser.this.list(n);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 1];
            String i = (String)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createNullityExpression(i, Nullity.MayNever));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 1];
            String i = (String)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createNullityExpression(i, Nullity.Must));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_ps = _symbols[offset + 1];
            List ps = (List)_symbol_ps.value;
            Symbol _symbol_p = _symbols[offset + 2];
            PrecedencyExpression p = (PrecedencyExpression)_symbol_p.value;
            return CDLParser.this.addToList(ps, p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            PrecedencyExpression p = (PrecedencyExpression)_symbol_p.value;
            return CDLParser.this.list(p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 2];
            List l = (List)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 4];
            List r = (List)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPrecedencyExpression(l, Precedency.Cannot, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 2];
            List l = (List)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 4];
            List r = (List)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPrecedencyExpression(l, Precedency.May, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(false);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(false);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(true);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_min = _symbols[offset + 1];
            TimeConstrain min = (TimeConstrain)_symbol_min.value;
            Symbol _symbol_max = _symbols[offset + 3];
            TimeConstrain max = (TimeConstrain)_symbol_max.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createTempGuard(min, max));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 2];
            Integer i = (Integer)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createTimeConstrain(i, false));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 2];
            Integer i = (Integer)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createTimeConstrain(i, true));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 1];
            Integer i = (Integer)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createTimeConstrain(i, false));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 1];
            Integer i = (Integer)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createTimeConstrain(i, true));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Predicate l = (Predicate)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            Predicate r = (Predicate)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createAndPredicate(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Predicate l = (Predicate)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            Predicate r = (Predicate)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createOrPredicate(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Predicate l = (Predicate)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            Predicate r = (Predicate)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createImplicationPredicate(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Predicate l = (Predicate)_symbol_l.value;
            Symbol _symbol_r = _symbols[offset + 3];
            Predicate r = (Predicate)_symbol_r.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createEquivalencePredicate(l, r));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_s = _symbols[offset + 1];
            Predicate s = (Predicate)_symbol_s.value;
            return CDLParser.this.symbol(s);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_s = _symbols[offset + 2];
            Predicate s = (Predicate)_symbol_s.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createNotPredicate(s));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_s = _symbols[offset + 1];
            Predicate s = (Predicate)_symbol_s.value;
            return CDLParser.this.symbol(s);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            ProcessId p = (ProcessId)_symbol_p.value;
            Symbol _symbol_s = _symbols[offset + 3];
            String s = (String)_symbol_s.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createStatePredicate(p, s));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            Predicate p = (Predicate)_symbol_p.value;
            return CDLParser.this.symbol(p);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_s = _symbols[offset + 2];
            Predicate s = (Predicate)_symbol_s.value;
            return CDLParser.this.symbol(s);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 1];
            String i = (String)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createPredicateReference(i));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(CDLParser.this.helper.createAllPredicate());
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a1 = _symbols[offset + 1];
            SystemAccess a1 = (SystemAccess)_symbol_a1.value;
            Symbol _symbol_o = _symbols[offset + 2];
            ComparisonOperator o = (ComparisonOperator)((Object)_symbol_o.value);
            Symbol _symbol_a2 = _symbols[offset + 3];
            SystemAccess a2 = (SystemAccess)_symbol_a2.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createVariableComparisonPredicate(a1, o, a2));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            SystemAccess a = (SystemAccess)_symbol_a.value;
            Symbol _symbol_o = _symbols[offset + 2];
            ComparisonOperator o = (ComparisonOperator)((Object)_symbol_o.value);
            Symbol _symbol_l = _symbols[offset + 3];
            Literal l = (Literal)_symbol_l.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createLiteralComparisonPredicate(a, o, l));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            SystemAccess a = (SystemAccess)_symbol_a.value;
            Symbol _symbol_l = _symbols[offset + 3];
            Literal l = (Literal)_symbol_l.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createLiteralEqualityPredicate(a, l));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a1 = _symbols[offset + 1];
            SystemAccess a1 = (SystemAccess)_symbol_a1.value;
            Symbol _symbol_a2 = _symbols[offset + 3];
            SystemAccess a2 = (SystemAccess)_symbol_a2.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createVariableEqualityPredicate(a1, a2));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)ComparisonOperator.LESSER);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)ComparisonOperator.LESSER_OR_EQUAL);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)ComparisonOperator.GREATER);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol((Object)ComparisonOperator.GREATER_OR_EQUAL);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_p = _symbols[offset + 1];
            ProcessId p = (ProcessId)_symbol_p.value;
            Symbol _symbol_sa = _symbols[offset + 3];
            List sa = (List)_symbol_sa.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createSystemAccess(p, sa));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_a = _symbols[offset + 1];
            List a = (List)_symbol_a.value;
            Symbol _symbol_aa = _symbols[offset + 3];
            AtomicAccess aa = (AtomicAccess)_symbol_aa.value;
            return CDLParser.this.addToList(a, aa);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_aa = _symbols[offset + 1];
            AtomicAccess aa = (AtomicAccess)_symbol_aa.value;
            return CDLParser.this.list(aa);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 1];
            String i = (String)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createFieldAccess(i));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 1];
            String i = (String)_symbol_i.value;
            Symbol _symbol_n = _symbols[offset + 3];
            Integer n = (Integer)_symbol_n.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createArrayAccess(i, n));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_os = _symbols[offset + 3];
            List os = (List)_symbol_os.value;
            return CDLParser.this.symbol(os);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_os = _symbols[offset + 1];
            List os = (List)_symbol_os.value;
            Symbol _symbol_o = _symbols[offset + 3];
            Option o = (Option)_symbol_o.value;
            return CDLParser.this.addToList(os, o);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_o = _symbols[offset + 1];
            Option o = (Option)_symbol_o.value;
            return CDLParser.this.list(o);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 1];
            String n = (String)_symbol_n.value;
            Symbol _symbol_v = _symbols[offset + 3];
            String v = (String)_symbol_v.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createOption(n, v));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_ls = _symbols[offset + 1];
            List ls = (List)_symbol_ls.value;
            Symbol _symbol_l = _symbols[offset + 3];
            Literal l = (Literal)_symbol_l.value;
            return CDLParser.this.addToList(ls, l);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Literal l = (Literal)_symbol_l.value;
            return CDLParser.this.list(l);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_ls = _symbols[offset + 1];
            List ls = (List)_symbol_ls.value;
            Symbol _symbol_l = _symbols[offset + 3];
            LiteralField l = (LiteralField)_symbol_l.value;
            return CDLParser.this.addToList(ls, l);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            LiteralField l = (LiteralField)_symbol_l.value;
            return CDLParser.this.list(l);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_n = _symbols[offset + 1];
            String n = (String)_symbol_n.value;
            Symbol _symbol_l = _symbols[offset + 3];
            Literal l = (Literal)_symbol_l.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createLiteralField(n, l));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 2];
            Literal l = (Literal)_symbol_l.value;
            return CDLParser.this.symbol(l);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            Integer l = (Integer)_symbol_l.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createIntegerLiteral(l));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_l = _symbols[offset + 1];
            String l = (String)_symbol_l.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createStringLiteral(l));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(CDLParser.this.helper.createBooleanLiteral(true));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(CDLParser.this.helper.createBooleanLiteral(false));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(CDLParser.this.helper.createAnyLiteral());
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 1];
            String i = (String)_symbol_i.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createConstantReference(i));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_t = _symbols[offset + 1];
            String t = (String)_symbol_t.value;
            Symbol _symbol_vs = _symbols[offset + 3];
            List vs = (List)_symbol_vs.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createArrayLiteral(t, vs));
        }
    }, Action.NONE, Action.RETURN, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_t = _symbols[offset + 1];
            String t = (String)_symbol_t.value;
            Symbol _symbol_vs = _symbols[offset + 3];
            List vs = (List)_symbol_vs.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createRecordLiteral(t, vs));
        }
    }, Action.NONE, Action.RETURN, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_t = _symbols[offset + 1];
            String t = (String)_symbol_t.value;
            Symbol _symbol_n = _symbols[offset + 3];
            String n = (String)_symbol_n.value;
            Symbol _symbol_v = _symbols[offset + 4];
            Literal v = (Literal)_symbol_v.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createUnionLiteral(t, n, v));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_is = _symbols[offset + 1];
            List is = (List)_symbol_is.value;
            Symbol _symbol_i = _symbols[offset + 3];
            String i = (String)_symbol_i.value;
            return CDLParser.this.addToList(is, i);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 1];
            String i = (String)_symbol_i.value;
            return CDLParser.this.list(i);
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            Symbol _symbol_i = _symbols[offset + 2];
            String i = (String)_symbol_i.value;
            Symbol _symbol_n = _symbols[offset + 4];
            Integer n = (Integer)_symbol_n.value;
            return CDLParser.this.symbol(CDLParser.this.helper.createProcessId(i, n));
        }
    }, new Action(){

        public Symbol reduce(Symbol[] _symbols, int offset) {
            return CDLParser.this.symbol(null);
        }
    }};

    private Symbol symbol(Object object) {
        return new Symbol(object);
    }

    private <T> Symbol list(T value) {
        ArrayList<T> result = new ArrayList<T>();
        result.add(value);
        return this.symbol(result);
    }

    private <T> Symbol addToList(List<T> list, T value) {
        list.add(value);
        return this.symbol(list);
    }

    public CDLParser() {
        super(PARSING_TABLES);
        this.report = new CDLParsingReport();
    }

    protected Symbol invokeReduceAction(int rule_num, int offset) {
        return this.actions[rule_num].reduce(this._symbols, offset);
    }

    public static class AltGoals {
        public static final short predicate = 81;
        public static final short system_access = 82;
        public static final short event = 83;
    }

    public static class Terminals {
        public static final short EOF = 0;
        public static final short IDENTIFIER = 1;
        public static final short LEFT_BRACE = 2;
        public static final short RIGHT_BRACE = 3;
        public static final short ANY = 4;
        public static final short LEFT_PAR = 5;
        public static final short NOT = 6;
        public static final short RIGHT_ARROW = 7;
        public static final short ALL = 8;
        public static final short EVENT = 9;
        public static final short AND = 10;
        public static final short OR = 11;
        public static final short INTEGER_LITERAL = 12;
        public static final short ATOMIC = 13;
        public static final short DOUBLE_ARROW = 14;
        public static final short SKIP = 15;
        public static final short LOOP = 16;
        public static final short SEMI_COLON = 17;
        public static final short EVENTUALLY = 18;
        public static final short FALSE = 19;
        public static final short TRUE = 20;
        public static final short LTL_GLOBALLY = 21;
        public static final short LTL_NEXT = 22;
        public static final short STRING_LITERAL = 23;
        public static final short IS = 24;
        public static final short COMA = 25;
        public static final short RIGHT_BRACK = 26;
        public static final short LTL_UNTIL = 27;
        public static final short SLASH = 28;
        public static final short LEFT_BRACK = 29;
        public static final short OPTIONS = 30;
        public static final short LTL_RELEASE = 31;
        public static final short RIGHT_PAR = 32;
        public static final short TWODOTS = 33;
        public static final short EQUAL = 34;
        public static final short MAIN = 35;
        public static final short FROM = 36;
        public static final short TO = 37;
        public static final short REPEATABILITY = 38;
        public static final short ONE_OF = 39;
        public static final short LTL = 40;
        public static final short ASSIGN = 41;
        public static final short SYNC = 42;
        public static final short SQUARE = 43;
        public static final short AN = 44;
        public static final short DOTDOT = 45;
        public static final short TWODASHES = 46;
        public static final short VARIABLE = 47;
        public static final short PREDICATE = 48;
        public static final short PROPERTY = 49;
        public static final short RESTRICTION = 50;
        public static final short CDL = 51;
        public static final short NEVER = 52;
        public static final short OCCUR = 53;
        public static final short ACTIVITY = 54;
        public static final short SEND = 55;
        public static final short RECEIVE = 56;
        public static final short INFORMAL = 57;
        public static final short INIT = 58;
        public static final short CLOCK = 59;
        public static final short DOT = 60;
        public static final short ASSERT = 61;
        public static final short STRONG_SCOPE = 62;
        public static final short WEAK_SCOPE = 63;
        public static final short EXACTLY_ONE_OCCURRENCE_OF = 64;
        public static final short ONE_OR_MORE_OCCURRENCES_OF = 65;
        public static final short LESSER = 66;
        public static final short LESSER_OR_EQUAL = 67;
        public static final short GREATER = 68;
        public static final short GREATER_OR_EQUAL = 69;
        public static final short MAY = 70;
        public static final short INFORMAL_LITERAL = 71;
        public static final short MUST = 72;
        public static final short BECOMES = 73;
        public static final short OCCURS = 74;
        public static final short ACCEPTING = 75;
        public static final short ORDERED = 76;
        public static final short COMBINED = 77;
        public static final short CANNOT_OCCUR_BEFORE_THE_FIRST_ONE_OF = 78;
        public static final short MAY_OCCUR_BEFORE_THE_FIRST_ONE_OF = 79;
        public static final short AT = 80;
        public static final short RESTRICTIONS = 84;
        public static final short PROPERTIES = 85;
        public static final short FOLDING = 86;
        public static final short TWOPIPES = 87;
        public static final short LEADSTO = 88;
        public static final short PRECEDES = 89;
        public static final short COINCIDE = 90;
        public static final short IMMEDIATELY = 91;
    }
}

