/*
 * Decompiled with CFR 0.152.
 */
package plug.language.fiacre;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.AtomicAction;
import obp2.runtime.core.TreeItem;
import obp2.runtime.core.defaults.DefaultTreeProjector;
import plug.language.fiacre.runtime.FiacreConfiguration;
import plug.language.fiacre.runtime.FiacreExplorationContext;
import plug.language.fiacre.runtime.FiacreSynchronizedTransition;
import plug.language.fiacre.runtime.FiacreTransitionRelation;

public class FiacreRuntimeView
extends DefaultTreeProjector<FiacreConfiguration, Transition, Object> {
    public FiacreTransitionRelation getRuntime() {
        return (FiacreTransitionRelation)super.getModule().getTransitionRelation();
    }

    public TreeItem projectConfiguration(FiacreConfiguration value) {
        ArrayList<TreeItem> processes = new ArrayList<TreeItem>();
        processes.add(new TreeItem("clock", DBM.toConstrainString((short[])value.dbm), null, null));
        FiacreExplorationContext context = this.getRuntime().getExplorationContext();
        for (short index = 0; index < context.getBehaviorCount(); index = (short)(index + 1)) {
            Behavior behavior = context.getBehavior(index);
            BehaviorConfiguration processConfiguration = value.behaviorConfigurations[index];
            ArrayList<TreeItem> variables = new ArrayList<TreeItem>();
            for (Field field : processConfiguration.getClass().getDeclaredFields()) {
                try {
                    Object fieldValue = field.get(processConfiguration);
                    String name = field.getName();
                    if (name.equals("state")) {
                        variables.add(new TreeItem("state", "@" + behavior.getStateName(((Short)fieldValue).shortValue()), null, null));
                        continue;
                    }
                    if (field.getType().isPrimitive() || field.getType().isArray()) {
                        variables.add(new TreeItem("variable", name + " = " + this.fieldToString(field, fieldValue), null, null));
                        continue;
                    }
                    ArrayList<TreeItem> items = new ArrayList<TreeItem>();
                    for (Field f : field.getType().getDeclaredFields()) {
                        Object valu = f.get(fieldValue);
                        items.add(new TreeItem("variable", f.getName() + " = " + this.fieldToString(f, valu), null, null));
                    }
                    if (items.isEmpty()) {
                        variables.add(new TreeItem("variable", name + " = " + fieldValue.toString(), null, items));
                        continue;
                    }
                    variables.add(new TreeItem("variable", name, null, items));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            processes.add(new TreeItem("process", behavior.name, null, variables));
        }
        return new TreeItem("fiacre", processes);
    }

    protected String fieldToString(Field field, Object value) {
        if (field.getType().isArray()) {
            int iMax = Array.getLength(value) - 1;
            if (iMax == -1) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            int i = 0;
            while (true) {
                builder.append(Array.get(value, i));
                if (i == Array.getLength(value) - 1) break;
                builder.append(", ");
                ++i;
            }
            builder.append(']');
            return builder.toString();
        }
        if (field.getType().isArray()) {
            return Arrays.deepToString((Object[])value);
        }
        return value.toString();
    }

    public TreeItem projectFireable(Transition transition) {
        if (transition instanceof FiacreSynchronizedTransition) {
            FiacreSynchronizedTransition fiacreSynchronizedTransition = (FiacreSynchronizedTransition)transition;
            return new TreeItem(this.getRuntime().getExplorationContext().getChannel((short)((short)fiacreSynchronizedTransition.getSynchronizationVector()[0])).name);
        }
        Behavior behavior = this.getRuntime().getExplorationContext().getBehavior(transition.behaviorId);
        StringBuilder result = new StringBuilder();
        result.append(behavior.name);
        result.append(": ");
        result.append(transition.getClass().getName());
        return new TreeItem(result.toString());
    }

    public TreeItem projectPayload(Object action) {
        StringBuilder result = new StringBuilder();
        if (action instanceof Collection) {
            for (Object child : (Collection)action) {
                if (child instanceof AtomicAction) {
                    result.append(((AtomicAction)child).toFancyString(this.getRuntime().getExplorationContext().symbols));
                    continue;
                }
                result.append(child.toString());
            }
            result.append("; ");
        } else if (action instanceof AtomicAction) {
            result.append(((AtomicAction)action).toFancyString(this.getRuntime().getExplorationContext().symbols));
        } else {
            result.append(Objects.toString(action));
        }
        return new TreeItem(result.toString());
    }
}

