/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDException;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;

public abstract class BDD {
    public abstract BDDFactory getFactory();

    public abstract boolean isZero();

    public abstract boolean isOne();

    public abstract int var();

    public int level() {
        return this.getFactory().var2Level(this.var());
    }

    public abstract BDD high();

    public abstract BDD low();

    public abstract BDD id();

    public abstract BDD not();

    public BDD and(BDD that) {
        return this.apply(that, BDDFactory.and);
    }

    public BDD andWith(BDD that) {
        return this.applyWith(that, BDDFactory.and);
    }

    public BDD or(BDD that) {
        return this.apply(that, BDDFactory.or);
    }

    public BDD orWith(BDD that) {
        return this.applyWith(that, BDDFactory.or);
    }

    public BDD xor(BDD that) {
        return this.apply(that, BDDFactory.xor);
    }

    public BDD xorWith(BDD that) {
        return this.applyWith(that, BDDFactory.xor);
    }

    public BDD imp(BDD that) {
        return this.apply(that, BDDFactory.imp);
    }

    public BDD impWith(BDD that) {
        return this.applyWith(that, BDDFactory.imp);
    }

    public BDD biimp(BDD that) {
        return this.apply(that, BDDFactory.biimp);
    }

    public BDD biimpWith(BDD that) {
        return this.applyWith(that, BDDFactory.biimp);
    }

    public abstract BDD ite(BDD var1, BDD var2);

    public abstract BDD relprod(BDD var1, BDD var2);

    public abstract BDD compose(BDD var1, int var2);

    public abstract BDD veccompose(BDDPairing var1);

    public abstract BDD constrain(BDD var1);

    public abstract BDD exist(BDD var1);

    public abstract BDD forAll(BDD var1);

    public abstract BDD unique(BDD var1);

    public abstract BDD restrict(BDD var1);

    public abstract BDD restrictWith(BDD var1);

    public abstract BDD simplify(BDD var1);

    public abstract BDD support();

    public abstract BDD apply(BDD var1, BDDFactory.BDDOp var2);

    public abstract BDD applyWith(BDD var1, BDDFactory.BDDOp var2);

    public abstract BDD applyAll(BDD var1, BDDFactory.BDDOp var2, BDD var3);

    public abstract BDD applyEx(BDD var1, BDDFactory.BDDOp var2, BDD var3);

    public abstract BDD applyUni(BDD var1, BDDFactory.BDDOp var2, BDD var3);

    public abstract BDD satOne();

    public abstract BDD fullSatOne();

    public abstract BDD satOne(BDD var1, boolean var2);

    public abstract List allsat();

    public int[] scanSet() {
        BDD n2;
        BDD n22;
        if (this.isOne() || this.isZero()) {
            return null;
        }
        int num = 0;
        BDD n = this.id();
        do {
            ++num;
            n22 = n.high();
            n.free();
        } while (!(n = n22).isZero() && !n.isOne());
        int[] varset = new int[num];
        num = 0;
        n = this.id();
        do {
            varset[num++] = n.var();
            n2 = n.high();
            n.free();
        } while (!(n = n2).isZero() && !n.isOne());
        return varset;
    }

    public int[] scanSetDomains() {
        int i;
        int m;
        boolean found;
        int[] ivar;
        BDDDomain dom;
        int n;
        int[] fv = this.scanSet();
        if (fv == null) {
            return null;
        }
        int fn = fv.length;
        BDDFactory factory = this.getFactory();
        int num = 0;
        for (n = 0; n < factory.numberOfDomains(); ++n) {
            dom = factory.getDomain(n);
            ivar = dom.vars();
            found = false;
            for (m = 0; m < dom.varNum() && !found; ++m) {
                for (i = 0; i < fn && !found; ++i) {
                    if (ivar[m] != fv[i]) continue;
                    ++num;
                    found = true;
                }
            }
        }
        int[] varset = new int[num];
        num = 0;
        for (n = 0; n < factory.numberOfDomains(); ++n) {
            dom = factory.getDomain(n);
            ivar = dom.vars();
            found = false;
            for (m = 0; m < dom.varNum() && !found; ++m) {
                for (i = 0; i < fn && !found; ++i) {
                    if (ivar[m] != fv[i]) continue;
                    varset[num++] = n;
                    found = true;
                }
            }
        }
        return varset;
    }

    public BigInteger scanVar(BDDDomain d) {
        if (this.isZero()) {
            return BigInteger.valueOf(-1L);
        }
        BigInteger[] allvar = this.scanAllVar();
        BigInteger res = allvar[d.getIndex()];
        return res;
    }

    public BigInteger[] scanAllVar() {
        if (this.isZero()) {
            return null;
        }
        BDDFactory factory = this.getFactory();
        int bddvarnum = factory.varNum();
        boolean[] store = new boolean[bddvarnum];
        BDD p = this.id();
        while (!p.isOne() && !p.isZero()) {
            BDD p2;
            BDD lo = p.low();
            if (!lo.isZero()) {
                store[p.var()] = false;
                p2 = p.low();
                p.free();
                p = p2;
            } else {
                store[p.var()] = true;
                p2 = p.high();
                p.free();
                p = p2;
            }
            lo.free();
        }
        int fdvarnum = factory.numberOfDomains();
        BigInteger[] res = new BigInteger[fdvarnum];
        for (int n = 0; n < fdvarnum; ++n) {
            BDDDomain dom = factory.getDomain(n);
            int[] ivar = dom.vars();
            BigInteger val = BigInteger.ZERO;
            for (int m = dom.varNum() - 1; m >= 0; --m) {
                val = val.shiftLeft(1);
                if (!store[ivar[m]]) continue;
                val = val.add(BigInteger.ONE);
            }
            res[n] = val;
        }
        return res;
    }

    private static int[] varset2levels(BDD r) {
        int size = 0;
        BDD p = r.id();
        while (!p.isOne() && !p.isZero()) {
            ++size;
            BDD p2 = p.high();
            p.free();
            p = p2;
        }
        p.free();
        int[] result = new int[size];
        size = -1;
        p = r.id();
        while (!p.isOne() && !p.isZero()) {
            result[++size] = p.level();
            BDD p2 = p.high();
            p.free();
            p = p2;
        }
        p.free();
        return result;
    }

    public BDDIterator iterator(BDD var) {
        return new BDDIterator(this, var);
    }

    public Iterator iterator2(final BDD var) {
        return new Iterator(){
            BDD b = null;
            BDD myVar;
            BDD last = null;
            {
                if (!BDD.this.isZero()) {
                    this.b = BDD.this.id();
                    this.myVar = var.id();
                }
            }

            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                BDD.this.applyWith(this.last.id(), BDDFactory.diff);
                this.last = null;
            }

            public boolean hasNext() {
                return this.b != null;
            }

            public Object next() {
                if (this.b == null) {
                    throw new NoSuchElementException();
                }
                BDD c = this.b.satOne(this.myVar, false);
                this.b.applyWith(c.id(), BDDFactory.diff);
                if (this.b.isZero()) {
                    this.myVar.free();
                    this.myVar = null;
                    this.b.free();
                    this.b = null;
                }
                this.last = c;
                return this.last;
            }
        };
    }

    public abstract BDD replace(BDDPairing var1);

    public abstract BDD replaceWith(BDDPairing var1);

    public void printSet() {
        System.out.println(this.toString());
    }

    public void printSetWithDomains() {
        System.out.println(this.toStringWithDomains());
    }

    public void printDot() {
        PrintStream out = System.out;
        out.println("digraph G {");
        out.println("0 [shape=box, label=\"0\", style=filled, shape=box, height=0.3, width=0.3];");
        out.println("1 [shape=box, label=\"1\", style=filled, shape=box, height=0.3, width=0.3];");
        boolean[] visited = new boolean[this.nodeCount() + 2];
        visited[0] = true;
        visited[1] = true;
        HashMap<BDD, Integer> map = new HashMap<BDD, Integer>();
        map.put(this.getFactory().zero(), new Integer(0));
        map.put(this.getFactory().one(), new Integer(1));
        this.printdot_rec(out, 1, visited, map);
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            BDD b = (BDD)i.next();
            b.free();
        }
        out.println("}");
    }

    protected int printdot_rec(PrintStream out, int current, boolean[] visited, HashMap map) {
        int r;
        Integer ri = (Integer)map.get(this);
        if (ri == null) {
            ri = new Integer(++current);
            map.put(this.id(), ri);
        }
        if (visited[r = ri.intValue()]) {
            return current;
        }
        visited[r] = true;
        out.println(r + " [label=\"" + this.var() + "\"];");
        BDD l = this.low();
        BDD h = this.high();
        Integer li = (Integer)map.get(l);
        if (li == null) {
            li = new Integer(++current);
            map.put(l.id(), li);
        }
        int low = li;
        Integer hi = (Integer)map.get(h);
        if (hi == null) {
            hi = new Integer(++current);
            map.put(h.id(), hi);
        }
        int high = hi;
        out.println(r + " -> " + low + " [style=dotted];");
        out.println(r + " -> " + high + " [style=filled];");
        current = l.printdot_rec(out, current, visited, map);
        l.free();
        current = h.printdot_rec(out, current, visited, map);
        h.free();
        return current;
    }

    public abstract int nodeCount();

    public abstract double pathCount();

    public abstract double satCount();

    public double satCount(BDD varset) {
        BDDFactory factory = this.getFactory();
        double unused = factory.varNum();
        if (varset.isZero() || varset.isOne() || this.isZero()) {
            return 0.0;
        }
        BDD n = varset.id();
        do {
            BDD n2 = n.high();
            n.free();
            n = n2;
            unused -= 1.0;
        } while (!n.isOne() && !n.isZero());
        n.free();
        unused = this.satCount() / Math.pow(2.0, unused);
        return unused >= 1.0 ? unused : 1.0;
    }

    public double logSatCount() {
        return Math.log(this.satCount());
    }

    public double logSatCount(BDD varset) {
        return Math.log(this.satCount(varset));
    }

    public abstract int[] varProfile();

    public abstract boolean equals(BDD var1);

    public boolean equals(Object o) {
        if (!(o instanceof BDD)) {
            return false;
        }
        return this.equals((BDD)o);
    }

    public abstract int hashCode();

    public String toString() {
        BDDFactory f = this.getFactory();
        int[] set = new int[f.varNum()];
        StringBuffer sb = new StringBuffer();
        BDD.bdd_printset_rec(f, sb, this, set);
        return sb.toString();
    }

    private static void bdd_printset_rec(BDDFactory f, StringBuffer sb, BDD r, int[] set) {
        if (r.isZero()) {
            return;
        }
        if (r.isOne()) {
            sb.append('<');
            boolean first = true;
            for (int n = 0; n < set.length; ++n) {
                if (set[n] <= 0) continue;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(f.level2Var(n));
                sb.append(':');
                sb.append(set[n] == 2 ? 1 : 0);
            }
            sb.append('>');
        } else {
            set[f.var2Level((int)r.var())] = 1;
            BDD rl = r.low();
            BDD.bdd_printset_rec(f, sb, rl, set);
            rl.free();
            set[f.var2Level((int)r.var())] = 2;
            BDD rh = r.high();
            BDD.bdd_printset_rec(f, sb, rh, set);
            rh.free();
            set[f.var2Level((int)r.var())] = 0;
        }
    }

    public String toStringWithDomains() {
        return this.toStringWithDomains(BDDToString.INSTANCE);
    }

    public String toStringWithDomains(BDDToString ts) {
        if (this.isZero()) {
            return "F";
        }
        if (this.isOne()) {
            return "T";
        }
        BDDFactory bdd2 = this.getFactory();
        StringBuffer sb = new StringBuffer();
        int[] set = new int[bdd2.varNum()];
        BDD.fdd_printset_rec(bdd2, sb, ts, this, set);
        return sb.toString();
    }

    private static void fdd_printset_helper(OutputBuffer sb, BigInteger value, int i, int[] set, int[] var, int maxSkip) {
        if (i == maxSkip) {
            BigInteger maxValue = value.or(BigInteger.ONE.shiftLeft(i + 1).subtract(BigInteger.ONE));
            sb.append(value, maxValue);
            return;
        }
        int val = set[var[i]];
        if (val == 0) {
            BigInteger temp = value.setBit(i);
            BDD.fdd_printset_helper(sb, temp, i - 1, set, var, maxSkip);
        }
        BDD.fdd_printset_helper(sb, value, i - 1, set, var, maxSkip);
    }

    private static void fdd_printset_rec(BDDFactory bdd2, StringBuffer sb, BDDToString ts, BDD r, int[] set) {
        int fdvarnum = bdd2.numberOfDomains();
        boolean used = false;
        if (r.isZero()) {
            return;
        }
        if (r.isOne()) {
            sb.append('<');
            boolean first = true;
            for (int n = 0; n < fdvarnum; ++n) {
                int val;
                int i;
                used = false;
                BDDDomain domain_n = bdd2.getDomain(n);
                int[] domain_n_ivar = domain_n.vars();
                int domain_n_varnum = domain_n_ivar.length;
                for (int m = 0; m < domain_n_varnum; ++m) {
                    if (set[domain_n_ivar[m]] == 0) continue;
                    used = true;
                }
                if (!used) continue;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(domain_n.getName());
                sb.append(':');
                int[] var = domain_n_ivar;
                BigInteger pos = BigInteger.ZERO;
                int maxSkip = -1;
                boolean hasDontCare = false;
                for (i = 0; i < domain_n_varnum; ++i) {
                    val = set[var[i]];
                    if (val != 0) continue;
                    hasDontCare = true;
                    if (maxSkip != i - 1) continue;
                    maxSkip = i;
                }
                for (i = domain_n_varnum - 1; i >= 0; --i) {
                    pos = pos.shiftLeft(1);
                    val = set[var[i]];
                    if (val != 2) continue;
                    pos = pos.setBit(0);
                }
                if (!hasDontCare) {
                    sb.append(ts.elementName(n, pos));
                    continue;
                }
                OutputBuffer ob = new OutputBuffer(ts, sb, n);
                BDD.fdd_printset_helper(ob, pos, domain_n_varnum - 1, set, var, maxSkip);
                ob.finish();
            }
            sb.append('>');
        } else {
            set[r.var()] = 1;
            BDD lo = r.low();
            BDD.fdd_printset_rec(bdd2, sb, ts, lo, set);
            lo.free();
            set[r.var()] = 2;
            BDD hi = r.high();
            BDD.fdd_printset_rec(bdd2, sb, ts, hi, set);
            hi.free();
            set[r.var()] = 0;
        }
    }

    public abstract void free();

    protected BDD() {
    }

    public static class BDDToString {
        public static final BDDToString INSTANCE = new BDDToString();

        protected BDDToString() {
        }

        public String elementName(int i, BigInteger j) {
            return j.toString();
        }

        public String elementNames(int i, BigInteger lo, BigInteger hi) {
            return lo.toString() + "-" + hi.toString();
        }
    }

    private static class OutputBuffer {
        BDDToString ts;
        StringBuffer sb;
        int domain;
        BigInteger lastLow;
        BigInteger lastHigh;
        boolean done;
        static final BigInteger MINUS2 = BigInteger.valueOf(-2L);

        OutputBuffer(BDDToString ts, StringBuffer sb, int domain) {
            this.ts = ts;
            this.sb = sb;
            this.lastHigh = MINUS2;
            this.domain = domain;
        }

        void append(BigInteger low, BigInteger high) {
            if (low.equals(this.lastHigh.add(BigInteger.ONE))) {
                this.lastHigh = high;
            } else {
                this.finish();
                this.lastLow = low;
                this.lastHigh = high;
            }
        }

        StringBuffer finish() {
            if (!this.lastHigh.equals(MINUS2)) {
                if (this.done) {
                    this.sb.append('/');
                }
                if (this.lastLow.equals(this.lastHigh)) {
                    this.sb.append(this.ts.elementName(this.domain, this.lastHigh));
                } else {
                    this.sb.append(this.ts.elementNames(this.domain, this.lastLow, this.lastHigh));
                }
                this.lastHigh = MINUS2;
            }
            this.done = true;
            return this.sb;
        }

        void append(BigInteger low) {
            this.append(low, low);
        }
    }

    public static class BDDIterator
    implements Iterator {
        protected BDDFactory factory;
        protected int[] levels;
        protected boolean[] values;
        protected BDD[] nodes = null;
        protected boolean more = false;

        public BDDIterator(BDD dis, BDD var) {
            this.factory = dis.getFactory();
            if (!dis.isZero()) {
                this.levels = BDD.varset2levels(var);
                this.values = new boolean[this.levels.length];
                this.nodes = new BDD[this.levels.length];
                this.fillInSatisfyingAssignment(dis.id(), 0);
                this.more = true;
            }
        }

        protected void fillInSatisfyingAssignment(BDD node, int i) {
            while (!node.isOne() && !node.isZero()) {
                int j;
                int v = node.level();
                for (j = i; j < this.levels.length && this.levels[j] != v; ++j) {
                    if (this.nodes[j] == null) continue;
                    throw new InternalError("nodes[" + j + "] should be null");
                }
                if (j == this.levels.length) {
                    int k;
                    StringBuffer sb = new StringBuffer();
                    sb.append("BDD contains variable ");
                    sb.append(this.factory.level2Var(v));
                    sb.append("(level ");
                    sb.append(v);
                    sb.append(") not in iteration set:\n");
                    for (k = 0; k < this.levels.length; ++k) {
                        sb.append(this.factory.level2Var(this.levels[k]));
                        if (k >= this.levels.length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("\n(levels: ");
                    for (k = 0; k < this.levels.length; ++k) {
                        sb.append(this.levels[k]);
                        if (k >= this.levels.length - 1) continue;
                        sb.append(",");
                    }
                    sb.append(")\n");
                    throw new BDDException(sb.toString());
                }
                i = j;
                this.nodes[i] = node;
                BDD node2 = node.low();
                if (node2.isZero()) {
                    node2.free();
                    this.values[i] = true;
                    node2 = node.high();
                }
                node = node2;
                ++i;
            }
        }

        protected boolean findNextSatisfyingAssignment() {
            int i = this.nodes.length - 1;
            while (i >= 0) {
                if (this.nodes[i] != null) {
                    BDD hi;
                    if (!this.values[i] && !(hi = this.nodes[i].high()).isZero()) {
                        this.values[i] = true;
                        this.fillInSatisfyingAssignment(hi, i + 1);
                        return true;
                    }
                    this.nodes[i].free();
                    this.nodes[i] = null;
                    this.values[i] = false;
                }
                --i;
            }
            return false;
        }

        protected void increment() {
            this.more = false;
            boolean carry = true;
            for (int i = this.levels.length - 1; i >= 0; --i) {
                boolean val = this.values[i];
                if (this.nodes[i] != null || !carry) continue;
                this.values[i] = !val;
                this.more |= !val;
                carry = val;
            }
        }

        protected BDD buildAndIncrement() {
            this.more = false;
            BDD b = this.factory.one();
            boolean carry = true;
            for (int i = this.levels.length - 1; i >= 0; --i) {
                int level = this.levels[i];
                int var = this.factory.level2Var(level);
                boolean val = this.values[i];
                if (this.nodes[i] == null && carry) {
                    this.values[i] = !val;
                    this.more |= !val;
                    carry = val;
                }
                BDD v = val ? this.factory.ithVar(var) : this.factory.nithVar(var);
                b.andWith(v);
            }
            return b;
        }

        protected void free() {
            for (int i = this.levels.length - 1; i >= 0; --i) {
                if (this.nodes[i] == null) continue;
                this.nodes[i].free();
                this.nodes[i] = null;
            }
            this.nodes = null;
        }

        public Object next() {
            if (!this.more) {
                throw new NoSuchElementException();
            }
            BDD b = this.buildAndIncrement();
            if (!this.more) {
                this.more = this.findNextSatisfyingAssignment();
                if (!this.more) {
                    this.free();
                }
            }
            return b;
        }

        public boolean hasNext() {
            return this.nodes != null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean isDontCare(int var) {
            if (this.nodes == null) {
                return false;
            }
            if (this.levels == null) {
                throw new BDDException();
            }
            int level = this.factory.var2Level(var);
            int i = Arrays.binarySearch(this.levels, level);
            if (i < 0) {
                throw new BDDException("var " + var + " not in iteration set");
            }
            return this.nodes[i] == null;
        }

        public boolean isDontCare(BDDDomain d) {
            if (this.nodes == null) {
                return false;
            }
            int[] vars = d.vars();
            for (int i = 0; i < vars.length; ++i) {
                if (this.isDontCare(vars[i])) continue;
                return false;
            }
            return true;
        }

        protected void fastForward0(int var) {
            if (this.levels == null) {
                throw new BDDException();
            }
            int level = this.factory.var2Level(var);
            int i = Arrays.binarySearch(this.levels, level);
            if (i < 0) {
                throw new BDDException();
            }
            if (this.nodes[i] != null) {
                throw new BDDException();
            }
            this.values[i] = true;
        }

        public void fastForward(int var) {
            this.fastForward0(var);
        }

        public void skipDontCare(BDDDomain d) {
            int[] vars = d.vars();
            for (int i = 0; i < vars.length; ++i) {
                this.fastForward0(vars[i]);
            }
        }
    }
}

