/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.explicit;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import obp2.language.explicit.ExplicitRuntimeView;
import obp2.language.explicit.diagnosis.ExplicitAtomicPropositionEvaluator;
import obp2.language.explicit.model.ExplicitProgram;
import obp2.language.explicit.runtime.ExplicitConfiguration;
import obp2.language.explicit.runtime.ExplicitTransitionRelation;
import obp2.runtime.core.IAtomicPropositionsEvaluator;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ILanguagePlugin;
import obp2.runtime.core.ITransitionRelation;
import obp2.runtime.core.ITreeProjector;
import obp2.runtime.core.LanguageModule;

public class ExplicitPlugin
implements ILanguagePlugin<URI, ExplicitConfiguration, Integer, Void> {
    public String[] getExtensions() {
        return new String[]{".json"};
    }

    public Function<URI, ILanguageModule<ExplicitConfiguration, Integer, Void>> languageModuleFunction() {
        return this::getRuntime;
    }

    public ILanguageModule<ExplicitConfiguration, Integer, Void> getRuntime(URI explicitProgramURI) {
        return this.getRuntime(new File(explicitProgramURI));
    }

    public ILanguageModule<ExplicitConfiguration, Integer, Void> getRuntime(String explicitProgramFileName) {
        return this.getRuntime(new File(explicitProgramFileName));
    }

    public ILanguageModule<ExplicitConfiguration, Integer, Void> getRuntime(File programFile) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        try {
            ExplicitProgram program = (ExplicitProgram)mapper.readValue(programFile, ExplicitProgram.class);
            ExplicitTransitionRelation runtime = new ExplicitTransitionRelation(programFile.getName(), program);
            return new LanguageModule((ITransitionRelation)runtime, (IAtomicPropositionsEvaluator)new ExplicitAtomicPropositionEvaluator(runtime), (ITreeProjector)new ExplicitRuntimeView(runtime));
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public String getName() {
        return "Explicit";
    }
}

