/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.fiacre;

import java.io.File;
import java.io.IOException;
import obp.fiacre.model.Program;
import obp.fiacre.util.FiacrePrinter;
import org.cte.ABCD.compiler.Compiler;
import org.cte.ABCD.compiler.PrimitiveUtils;
import org.cte.ABCD.fiacre.ABCD2Fiacre;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.transformations.TArgumentExpToVar;
import org.cte.ABCD.transformations.TInlineMutex;
import org.cte.ABCD.transformations.TInlinePrimitiveTypes;
import org.cte.ABCD.transformations.TInlineSemaphore;
import org.cte.ABCD.transformations.TInlineTimer;
import org.cte.ABCD.transformations.TRemoveUnusedDeclarations;
import org.cte.ABCD.transformations.forUML.TInlineEventPool;

public class ABCDUtil {
    public static String toFiacre(String ABCDString) throws IOException {
        ABCDSystem system = Compiler.compile(ABCDString);
        return ABCDUtil.toFiacre(system);
    }

    public static String toFiacre(File file) throws IOException {
        ABCDSystem system = Compiler.compile(file);
        return ABCDUtil.toFiacre(system);
    }

    public static String toFiacre(ABCDSystem system) throws IOException {
        try {
            PrimitiveUtils.checkSelectors(system);
        }
        catch (Exception e1) {
            return null;
        }
        TRemoveUnusedDeclarations.runOn(system);
        TInlinePrimitiveTypes primitiveInliner = new TInlinePrimitiveTypes();
        primitiveInliner.runOn(system);
        try {
            TInlineTimer timerInliner = new TInlineTimer();
            timerInliner.runOn(system);
        }
        catch (Exception e) {
            System.err.println("Unexpected error while inlining timers");
            return null;
        }
        try {
            TInlineMutex mutexInliner = new TInlineMutex();
            mutexInliner.runOn(system);
        }
        catch (Exception e) {
            System.err.println("Unexpected error while inlining mutexes");
            return null;
        }
        try {
            TInlineSemaphore semaphoreInliner = new TInlineSemaphore();
            semaphoreInliner.runOn(system);
        }
        catch (Exception e) {
            System.err.println("Unexpected error while inlining semaphores");
            return null;
        }
        try {
            TInlineEventPool ePInliner = new TInlineEventPool();
            ePInliner.runOn(system);
        }
        catch (Exception e) {
            System.err.println("Unexpected error while inlining event pools");
            return null;
        }
        TRemoveUnusedDeclarations.runOn(system);
        TArgumentExpToVar argExtractor = new TArgumentExpToVar();
        argExtractor.runOn(system);
        ABCD2Fiacre s2f = new ABCD2Fiacre();
        Program fiacreP = s2f.toFiacre(system);
        return FiacrePrinter.toString(fiacreP);
    }
}

