/*
 * Decompiled with CFR 0.152.
 */
package obp.lua;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.xid.basics.serializer.Boost;

public class LuaUtil {
    public static LuaValue evalExpression(String expression, Globals globals) throws IOException {
        return LuaUtil.evalExpression(expression, LuaValue.class, globals);
    }

    public static <T extends LuaValue> T evalExpression(String expression, Class<T> type, Globals globals) throws IOException {
        String script = "return " + expression;
        ByteArrayInputStream stream = new ByteArrayInputStream(script.toString().getBytes());
        LuaFunction block = globals.compiler.load((InputStream)stream, expression, (LuaValue)globals);
        LuaValue value = block.call();
        return (T)((LuaValue)type.cast(value));
    }

    public static LuaFunction parseString(String script, Globals globals) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(script.getBytes());
        return globals.compiler.load((InputStream)stream, script, (LuaValue)globals);
    }

    public static LuaFunction parseFile(File file, Globals globals) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        return globals.compiler.load((InputStream)stream, file.getName(), (LuaValue)globals);
    }

    public static LuaFunction parseResource(String name, Globals globals) throws IOException {
        InputStream stream = LuaUtil.class.getClassLoader().getResourceAsStream(name);
        if (stream == null) {
            throw new IOException("Resource '" + name + "' can't be found.");
        }
        return globals.compiler.load(stream, name, (LuaValue)globals);
    }

    public static LuaValue readFromBoost(Boost boost) {
        int type = boost.readInt();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return LuaValue.valueOf((boolean)boost.readBoolean());
            }
            case -2: {
                return LuaValue.valueOf((int)boost.readInt());
            }
            case 3: {
                return LuaValue.valueOf((double)boost.readDouble());
            }
            case 4: {
                return LuaValue.valueOf((String)boost.readString());
            }
            case 5: {
                LuaTable table = new LuaTable();
                int length = boost.readInt();
                for (int i = 0; i < length; ++i) {
                    table.set(LuaUtil.readFromBoost(boost), LuaUtil.readFromBoost(boost));
                }
                return table;
            }
        }
        throw new IllegalArgumentException("Can't read from boost Lua values of type '" + type + "'.");
    }

    public static void writeToBoost(LuaValue value, Boost boost) {
        int type = value.type();
        boost.writeInt(type);
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                boost.writeBoolean(value.checkboolean());
                break;
            }
            case -2: {
                boost.writeInt(value.checkint());
                break;
            }
            case 3: {
                boost.writeDouble(value.checknumber().todouble());
                break;
            }
            case 4: {
                boost.writeString(value.checkjstring());
                break;
            }
            case 5: {
                LuaTable table = (LuaTable)value;
                int length = value.rawlen();
                boost.writeInt(length);
                Varargs entry = table.next(LuaValue.NIL);
                while (!entry.arg1().isnil()) {
                    LuaValue key = entry.arg1();
                    LuaUtil.writeToBoost(key, boost);
                    LuaUtil.writeToBoost(entry.arg(2), boost);
                    entry = table.next(key);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't write to boost Lua values of type '" + value.typename() + "'.");
            }
        }
    }

    public static LuaValue[] deepCopy(LuaValue[] values) {
        if (values == null) {
            return null;
        }
        LuaValue[] copy = new LuaValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            copy[i] = LuaUtil.deepCopy(values[i]);
        }
        return copy;
    }

    public static LuaValue deepCopy(LuaValue value) {
        int type = value.type();
        switch (type) {
            case -2: 
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return value;
            }
            case 5: {
                LuaTable copy = new LuaTable();
                Varargs entry = value.next(LuaValue.NIL);
                while (!entry.arg1().isnil()) {
                    LuaValue key = entry.arg1();
                    copy.set(LuaUtil.deepCopy(key), LuaUtil.deepCopy(entry.arg(2)));
                    entry = value.next(key);
                }
                copy.setmetatable(value.getmetatable());
                return copy;
            }
        }
        throw new IllegalArgumentException("Can't deep copy Lua values of type '" + value.typename() + "'.");
    }

    public static int deepHashCode(LuaValue[] values) {
        if (values == null) {
            return 0;
        }
        int code = 17;
        for (int i = 0; i < values.length; ++i) {
            code += 37 * LuaUtil.deepHashCode(values[i]);
        }
        return code;
    }

    public static int deepHashCode(LuaValue value) {
        int type = value.type();
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return value.toboolean() ? 2 : 1;
            }
            case -2: 
            case 3: {
                return value.toint();
            }
            case 4: {
                return value.tostring().hashCode();
            }
            case 5: {
                int code = 17;
                Varargs entry = value.next(LuaValue.NIL);
                while (!entry.arg1().isnil()) {
                    LuaValue key = entry.arg1();
                    code += 37 * LuaUtil.deepHashCode(key);
                    code += 37 * LuaUtil.deepHashCode(entry.arg(2));
                    entry = value.next(key);
                }
                return code;
            }
        }
        throw new IllegalArgumentException("Can't get hash code of Lua values of type '" + value.typename() + "'.");
    }

    public static boolean deepEquals(LuaValue[] me, LuaValue[] you) {
        if (me == null) {
            return you == null;
        }
        if (you == null) {
            return false;
        }
        if (me.length != you.length) {
            return false;
        }
        for (int i = 0; i < me.length; ++i) {
            if (LuaUtil.deepEquals(me[i], you[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(LuaValue me, LuaValue you) {
        int youType;
        int meType = me.type();
        if (meType != (youType = you.type())) {
            return false;
        }
        switch (meType) {
            case 0: {
                return true;
            }
            case 1: {
                return me.toboolean() == you.toboolean();
            }
            case -2: 
            case 3: {
                return me.toint() == you.toint();
            }
            case 4: {
                return me.tostring() == you.tostring();
            }
            case 5: {
                if (me.length() != you.length()) {
                    return false;
                }
                Varargs meEntry = me.next(LuaValue.NIL);
                Varargs youEntry = you.next(LuaValue.NIL);
                while (!meEntry.arg1().isnil()) {
                    LuaValue youKey;
                    LuaValue meKey = meEntry.arg1();
                    if (!LuaUtil.deepEquals(meKey, youKey = youEntry.arg1())) {
                        return false;
                    }
                    if (!LuaUtil.deepEquals(meEntry.arg(2), youEntry.arg(2))) {
                        return false;
                    }
                    meEntry = me.next(meKey);
                    youEntry = you.next(youKey);
                }
                return true;
            }
        }
        return me == you;
    }

    public static String toString(LuaValue value) {
        if (value == null) {
            return "nil";
        }
        switch (value.type()) {
            case 5: {
                LuaTable table = (LuaTable)value;
                StringBuilder text = new StringBuilder();
                text.append("{");
                Varargs entry = table.next(LuaValue.NIL);
                while (!entry.arg1().isnil()) {
                    if (text.length() > 1) {
                        text.append(",");
                    }
                    LuaValue key = entry.arg1();
                    text.append(LuaUtil.toString(key));
                    text.append("=>");
                    text.append(LuaUtil.toString(entry.arg(2)));
                    entry = table.next(key);
                }
                text.append("}");
                return text.toString();
            }
        }
        return value.tojstring();
    }
}

